Imports System.Runtime.InteropServices

Public Class StBitmap
	Dim m_Width As System.UInt32
	Dim m_Height As System.UInt32
	Dim m_PixelData() As Byte = Nothing
	Dim m_PixelFormat As System.UInt32 = 0
	Dim m_dwFrameNo As System.UInt32 = 0

	Public ReadOnly Property Width() As System.UInt32
		Get
			Return (m_Width)
		End Get
	End Property

	Public ReadOnly Property Height() As System.UInt32
		Get
			Return (m_Height)
		End Get
	End Property

	Public ReadOnly Property StPixelFormat() As System.UInt32
		Get
			Return (m_PixelFormat)
		End Get
	End Property

	Public ReadOnly Property FrameNo() As System.UInt32
		Get
			Return (m_dwFrameNo)
		End Get
	End Property
	Public ReadOnly Property PixelData() As Byte()
		Get
			Return (m_PixelData)
		End Get
	End Property

	Private Sub CreateBuffer(ByVal dwWidth As System.UInt32, ByVal dwHeight As System.UInt32, ByVal stPixelFormat As System.UInt32)
		If (IsNothing(m_PixelData) Or (Width <> dwWidth) Or (Height <> dwHeight) Or (Me.StPixelFormat <> stPixelFormat)) Then
            Dim size As Integer = CInt(dwWidth)

			Select Case (stPixelFormat)
				Case StTrg.STCAM_PIXEL_FORMAT_24_BGR
					size *= 3
				Case StTrg.STCAM_PIXEL_FORMAT_32_BGR
					size *= 4
            End Select
            If (size And 3) <> 0 Then
                size += 4 - (size And 3)
            End If
            size *= CInt(dwHeight)
			ReDim m_PixelData(size)
			m_Width = dwWidth
			m_Height = dwHeight
			m_PixelFormat = stPixelFormat
		End If

	End Sub
	Public Sub ColorInterpolation(ByVal frameNo As System.UInt32, ByVal width As System.UInt32, ByVal height As System.UInt32, ByVal colorArray As System.UInt16, ByVal pvRaw As IntPtr, ByVal colorInterpolationMethod As Byte, ByVal stPixelFormat As System.UInt32)
		Call CreateBuffer(width, height, stPixelFormat)
		m_dwFrameNo = frameNo

		'Color interpolation
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		StTrg.ColorInterpolation(width, height, colorArray, pvRaw, pvBGR, colorInterpolationMethod, stPixelFormat)
		gch.Free()
	End Sub
	Public Sub ConvYUVOrBGRToBGR(ByVal frameNo As System.UInt32, ByVal width As System.UInt32, ByVal height As System.UInt32, ByVal dwTransferBitsPerPixel As System.UInt32, ByVal pbyteYUV As IntPtr, ByVal stPixelFormat As System.UInt32)
		Call CreateBuffer(width, height, stPixelFormat)
		m_dwFrameNo = frameNo

		'Color interpolation
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		StTrg.ConvYUVOrBGRToBGRImage(width, height, dwTransferBitsPerPixel, pbyteYUV, stPixelFormat, pvBGR)
		gch.Free()
	End Sub
	Public Sub BGRGamma(ByVal hCamera As IntPtr)
		'BGR Gamma
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		StTrg.BGRGamma(hCamera, Width, Height, StPixelFormat, pvBGR)
		gch.Free()
	End Sub
	Public Sub HueSaturationColorMatrix(ByVal hCamera As IntPtr)
		'HueSaturationColorMatrix
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		StTrg.HueSaturationColorMatrix(hCamera, Width, Height, StPixelFormat, pvBGR)
		gch.Free()
	End Sub
	Public Sub Sharpness(ByVal hCamera As IntPtr)
		'Sharpness
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		StTrg.Sharpness(hCamera, Width, Height, StPixelFormat, pvBGR)
		gch.Free()
	End Sub
	Public Function SaveImageFile(ByVal fileName As String) As Boolean
		Dim result As Boolean = True
		Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
		Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
		result = (StTrg.SaveImage(Width, Height, StPixelFormat, pvBGR, fileName, 0) <> 0)
		gch.Free()
		Return (result)
	End Function
	Public Function Draw(ByVal hCamera As IntPtr, ByVal hWnd As IntPtr) As Boolean
		Dim result As Boolean = True
		If Not IsNothing(m_PixelData) Then
			'Set window size
			Native.SetWindowPos(hWnd, IntPtr.Zero, 0, 0, CInt(Width), CInt(Height), Native.SWP_NOMOVE Or Native.SWP_NOZORDER)

			Dim gch As GCHandle = GCHandle.Alloc(m_PixelData, GCHandleType.Pinned)
			Dim pvBGR As IntPtr = gch.AddrOfPinnedObject()
			Dim hDC As IntPtr = Native.GetDC(hWnd)

			result = (StTrg.Draw(hCamera, hDC, _
	0, 0, Width, Height, _
	0, 0, Width, Height, _
	Width, Height, pvBGR, StPixelFormat) <> 0)

			Native.ReleaseDC(hWnd, hDC)
			gch.Free()
		End If
		Return (result)
	End Function

End Class
