Imports System.Threading
Imports System.Runtime.InteropServices
Public Class StCamera

	Private INVALID_HANDLE_VALUE As IntPtr = CType(-1, IntPtr)

	'Camera Info
	Private m_hCamera As IntPtr

	'FPS
	Private m_FramePerSec As FramePerSec = Nothing

	'SDK Version
	Private m_dwFileVersionMS As System.UInt32 = 0
	Private m_dwFileVersionLS As System.UInt32 = 0
	Private m_dwProductVersionMS As System.UInt32 = 0
	Private m_dwProductVersionLS As System.UInt32 = 0

	'V Blank
	Private m_dwMaxVBlankForFPS As System.UInt32 = 0

	'Camera Version
	Private m_wUSBVenderID As System.UInt16 = 0
	Private m_wUSBProductID As System.UInt16 = 0
	Private m_wFPGAVersion As System.UInt16 = 0
	Private m_wFirmVersion As System.UInt16 = 0

	'Color array
	Private m_wColorArray As System.UInt16 = 0

	'Buffer
	Private m_hDisplayBGRMutex As New Mutex(False)
	Private m_ReceivingBGRImage As New StBitmap()
	Private m_DisplayBGRImage As New StBitmap()

	'Setting
	Private m_dwPixelFormat As System.UInt32 = StTrg.STCAM_PIXEL_FORMAT_08_MONO_OR_RAW
	Private m_byteColorInterpolationMode As Byte = StTrg.STCAM_COLOR_INTERPOLATION_BILINEAR
	Private m_dwNoiseReductionMode As System.UInt32 = StTrg.STCAM_NR_OFF
	Private m_byteMirrorMode As Byte = StTrg.STCAM_MIRROR_OFF
	Private m_byteRotationMode As Byte = StTrg.STCAM_ROTATION_OFF

	'Callback
	Private m_TransferEndCallback As StTrg.funcTransferEndCallback = Nothing
	Private m_ExposureEndCallback As StTrg.funcExposureEndCallback = Nothing
	Private m_RcvErrorCallback As StTrg.funcRcvErrorCallback = Nothing


	Public Delegate Sub delPreviewImageUpdated(ByVal sender As Object, ByVal e As EventArgs)
	Private Event PreviewImageUpdated As delPreviewImageUpdated
	Private m_PreviewImageUpdatedMutex As New System.Threading.Mutex(False)

    Public Delegate Sub delErrorRcved(ByVal dwErrorCode As UInt32)
    Private Event ErrorRcved As delErrorRcved
    Private m_ErrorRcvedMutex As New System.Threading.Mutex(False)

	Public Event SettingUpdated(ByVal sender As Object, ByVal e As EventArgs)

	'Dropped frame count
	Private m_dwDroppedFrameCount As Integer = 0

	'Setting dialog
	Private WithEvents m_frmSetting As FormSetting = Nothing

	'Auto StartStop
	Private m_AutoTriggerDueTime As Integer = 1000
	Private m_isAutoTriggerMode As Boolean = False
	Private m_AutoTriggerTimer As System.Threading.Timer

	'ALC
	Private m_dwALCSkipCount As Long = 0

	Private m_dwIOExistence As UInteger = 0

	Public Sub AddPreviewImageUpdatedEventHandler(ByVal handler As delPreviewImageUpdated)
		m_PreviewImageUpdatedMutex.WaitOne()
		AddHandler PreviewImageUpdated, handler
		m_PreviewImageUpdatedMutex.ReleaseMutex()
    End Sub

    Public Sub AddErrRcvedEventHandler(ByVal handler As delErrorRcved)
        m_ErrorRcvedMutex.WaitOne()
        AddHandler ErrorRcved, handler
        m_ErrorRcvedMutex.ReleaseMutex()
    End Sub

	Public Sub New(ByVal hCamera As IntPtr)
		Dim bReval As Boolean = True

		'Camera Info
		m_hCamera = hCamera

		'SDK Version
		bReval = StTrg.GetDllVersion(m_dwFileVersionMS, m_dwFileVersionLS, m_dwProductVersionMS, m_dwProductVersionLS) <> 0

		'FPS
		m_FramePerSec = New FramePerSec(100)


		'Camera Version
		bReval = StTrg.GetCameraVersion(hCamera, m_wUSBVenderID, m_wUSBProductID, m_wFPGAVersion, m_wFirmVersion) <> 0

		'Color array
		bReval = StTrg.GetColorArray(hCamera, m_wColorArray) <> 0


		If StTrg.STCAM_COLOR_ARRAY_MONO <> m_wColorArray Then
			m_dwPixelFormat = StTrg.STCAM_PIXEL_FORMAT_24_BGR
			WhiteBalanceMode = StTrg.STCAM_WB_FULLAUTO
		End If


		ReadCurrentSetting()

		'Callback
		m_TransferEndCallback = New StTrg.funcTransferEndCallback(AddressOf OnTransferEnd)
		bReval = StTrg.SetTransferEndCallback(m_hCamera, m_TransferEndCallback, IntPtr.Zero) <> 0

		m_ExposureEndCallback = New StTrg.funcExposureEndCallback(AddressOf OnExposureEnd)
		bReval = StTrg.SetExposureEndCallback(m_hCamera, m_ExposureEndCallback, IntPtr.Zero) <> 0

		m_RcvErrorCallback = New StTrg.funcRcvErrorCallback(AddressOf OnRcvError)
		bReval = StTrg.SetRcvErrorCallback(m_hCamera, m_RcvErrorCallback, IntPtr.Zero) <> 0


		'Auto StartStop
		m_AutoTriggerTimer = New System.Threading.Timer(AddressOf OnAutoTriggerTimer, Nothing, System.Threading.Timeout.Infinite, System.Threading.Timeout.Infinite)

		StTrg.GetIOExistence(m_hCamera, m_dwIOExistence)


	End Sub
	Public Overrides Function ToString() As String
		Return (Me.CameraUserName)
	End Function
	Public Property StPixelFormat() As System.UInt32
		Get
			Return (m_dwPixelFormat)
		End Get
        Set(ByVal value As System.UInt32)
            StopTransfer()
            m_dwPixelFormat = value
            StartTransfer()
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
	End Property
	Public Property ColorInterpolationMode() As Byte
		Get
			Return (m_byteColorInterpolationMode)
		End Get
		Set(ByVal value As Byte)
			m_byteColorInterpolationMode = value
			RaiseEvent SettingUpdated(Me, New EventArgs())
		End Set
	End Property
	Public Property MirrorMode() As Byte
		Get
            If IsOpened() Then
                If HasMirrorHorizontal() Or HasMirrorVertical() Then
                    Dim byteMirrorMode As Byte = 0
                    StTrg.GetMirrorMode(m_hCamera, byteMirrorMode)
                    m_byteMirrorMode = byteMirrorMode Or Convert.ToByte(m_byteMirrorMode And &HF)
                End If
            End If
            Return (m_byteMirrorMode)
        End Get
        Set(ByVal value As Byte)
            If IsOpened() Then
                m_byteMirrorMode = value
                If HasMirrorHorizontal() Or HasMirrorVertical() Then
                    StopTransfer()
                    StTrg.SetMirrorMode(m_hCamera, Convert.ToByte(m_byteMirrorMode And &HF0))
                    StartTransfer()
                End If
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property RotationMode() As Byte
        Get
            Return (m_byteRotationMode)
        End Get
        Set(ByVal value As Byte)
            m_byteRotationMode = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property NoiseReductionMode() As System.UInt32
        Get
            Return (m_dwNoiseReductionMode)
        End Get
        Set(ByVal value As System.UInt32)
            m_dwNoiseReductionMode = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property

    Public Sub OnAutoTriggerTimer(ByVal o As Object)
        TriggerSoftware(StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_END)
    End Sub

#Region "Open/Close Camera Method"
    Public Shared Function Open() As StCamera
        Dim stCamera As StCamera = Nothing
        Using dlg As New FormSelectCamera()
            Dim cli As New CameraListItem()
            dlg.SelectItem = cli
            If DialogResult.OK = dlg.ShowDialog Then
                stCamera = cli.GetSelectedItem()
                stCamera.StartTransfer()
            End If
            cli.Close()
        End Using

        Return (stCamera)
    End Function
    Public Sub Close()

        If Not IsNothing(m_frmSetting) Then
            m_frmSetting.Close()
            m_frmSetting = Nothing
        End If
        If Not m_hCamera.Equals(Nothing) Then
            StopTransfer()
            StTrg.Close(m_hCamera)
            m_hCamera = Nothing
        End If
    End Sub
#End Region

    Public Sub OnExposureEnd(ByVal hCamera As IntPtr, ByVal dwFrameNo As System.UInt32, ByVal lpContext As IntPtr)

    End Sub

    Private m_pbyteTmpRaw() As Byte = Nothing
    Public Sub OnTransferEnd(ByVal hCamera As IntPtr, ByVal dwFrameNo As System.UInt32, ByVal dwWidth As System.UInt32, ByVal dwHeight As System.UInt32, ByVal wColorArray As System.UInt16, ByVal pvRaw As IntPtr, ByVal lpContext As IntPtr)
        'for FPS
        m_FramePerSec.OnReceiveImage()


        If 1 < MaxRegionCount Then
            Dim pvMultiRaw As IntPtr = IntPtr.Zero
            Dim dwMultiWidth As UInteger = 0
            Dim dwMultiHeight As UInteger = 0
            Dim dwMultiLinePitch As UInteger = 0
            StTrg.DecodingCombinedMultiROI(hCamera, StTrg.STCAM_DECODING_COMBINED_MULTI_ROI_EXCEPT_BLANK_ROW_AND_COL, pvRaw, pvMultiRaw, dwMultiWidth, dwMultiHeight, dwMultiLinePitch)
            pvRaw = pvMultiRaw
            dwWidth = dwMultiWidth
            dwHeight = dwMultiHeight
        End If

        If (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 = TransferBitsPerPixel) Then

            m_ReceivingBGRImage.ConvYUVOrBGRToBGR(dwFrameNo, dwWidth, dwHeight, TransferBitsPerPixel, pvRaw, StPixelFormat)
            ImageProcessingBGR()
        ElseIf (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P = TransferBitsPerPixel) Then
            Dim size As Integer = CInt(dwWidth * dwHeight)
            If (m_pbyteTmpRaw Is Nothing) OrElse (m_pbyteTmpRaw.GetLength(0) < size) Then
                ReDim m_pbyteTmpRaw(size)
            End If
            Dim gch As System.Runtime.InteropServices.GCHandle = System.Runtime.InteropServices.GCHandle.Alloc(m_pbyteTmpRaw, Runtime.InteropServices.GCHandleType.Pinned)
            Dim pvTmpRaw As IntPtr = gch.AddrOfPinnedObject()
            StTrg.ConvTo8BitsImage(dwWidth, dwHeight, TransferBitsPerPixel, pvRaw, pvTmpRaw)
            ImageProcessingRaw(dwFrameNo, dwWidth, dwHeight, wColorArray, pvTmpRaw, True)
            gch.Free()
        ElseIf (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10P = TransferBitsPerPixel) Or (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12P = TransferBitsPerPixel) Then
            Dim size As Integer = CInt(dwWidth * dwHeight)
            If (m_pbyteTmpRaw Is Nothing) OrElse (m_pbyteTmpRaw.GetLength(0) < size) Then
                ReDim m_pbyteTmpRaw(size)
            End If
            Dim gch As System.Runtime.InteropServices.GCHandle = System.Runtime.InteropServices.GCHandle.Alloc(m_pbyteTmpRaw, Runtime.InteropServices.GCHandleType.Pinned)
            Dim pvTmpRaw As IntPtr = gch.AddrOfPinnedObject()
            StTrg.ConvTo8BitsImage(dwWidth, dwHeight, TransferBitsPerPixel, pvRaw, pvTmpRaw)
            ImageProcessingRaw(dwFrameNo, dwWidth, dwHeight, wColorArray, pvTmpRaw, False)
            gch.Free()

        ElseIf (StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08 = TransferBitsPerPixel) Then
            ImageProcessingRaw(dwFrameNo, dwWidth, dwHeight, wColorArray, pvRaw, True)
        Else
            ImageProcessingRaw(dwFrameNo, dwWidth, dwHeight, wColorArray, pvRaw, False)
        End If

    End Sub
    Private Sub ImageProcessingRaw(ByVal dwFrameNo As System.UInt32, ByVal dwWidth As System.UInt32, ByVal dwHeight As System.UInt32, ByVal wColorArray As System.UInt16, ByVal pvRaw As IntPtr, ByVal isMono As Boolean)

        'PC Side ALC
        If (Not HasAE()) And (Not HasAGC()) Then
            If 0 < m_dwALCSkipCount Then
                m_dwALCSkipCount -= 1
            Else
                If ALCMode() <> StTrg.STCAM_ALCMODE_OFF Then
                    Dim pfAverage(4) As Single
                    Dim gch As System.Runtime.InteropServices.GCHandle = System.Runtime.InteropServices.GCHandle.Alloc(pfAverage, System.Runtime.InteropServices.GCHandleType.Pinned)
                    Dim ptrAverage As IntPtr = gch.AddrOfPinnedObject()
                    StTrg.GetAveragePixelValue(dwWidth, dwHeight, wColorArray, StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08, pvRaw, 0, 0, dwWidth, dwHeight, ptrAverage)
                    gch.Free()

                    Dim wAverage As UShort = 0
                    If StTrg.STCAM_COLOR_ARRAY_MONO = wColorArray Then
                        wAverage = CUShort(pfAverage(0))      'B/W
                    Else
                        wAverage = CUShort((pfAverage(1) + pfAverage(2)) / 2)   '(Gr + Gb) / 2
                    End If
                    Dim dwALCStatus As UInteger = 0
                    StTrg.ALC(m_hCamera, wAverage, dwALCStatus)
                    If (dwALCStatus And 3) <> 0 Then
                        m_dwALCSkipCount = 5
                    End If
                End If
            End If
        End If



        'Noise reduction
        StTrg.NoiseReduction(m_hCamera, m_dwNoiseReductionMode, dwWidth, dwHeight, wColorArray, pvRaw)

        'Shading Correction
        StTrg.ShadingCorrection(m_hCamera, dwWidth, dwHeight, dwWidth, pvRaw, 8)

        If Not isMono Then

            'White balance
            StTrg.WhiteBalance(m_hCamera, pvRaw)

            'color gamma
            StTrg.RawColorGamma(m_hCamera, dwWidth, dwHeight, wColorArray, pvRaw)
        End If

        'Mirror Rotation
        StTrg.MirrorRotation(m_byteMirrorMode, m_byteRotationMode, dwWidth, dwHeight, wColorArray, pvRaw)

        'Color interpolation
        m_ReceivingBGRImage.ColorInterpolation(dwFrameNo, dwWidth, dwHeight, wColorArray, pvRaw, m_byteColorInterpolationMode, StPixelFormat)

        ImageProcessingBGR()
    End Sub
    Private Sub ImageProcessingBGR()
        'BGR gamma
        m_ReceivingBGRImage.BGRGamma(m_hCamera)

        'Hue,Saturation
        m_ReceivingBGRImage.HueSaturationColorMatrix(m_hCamera)

        'Sharpness
        m_ReceivingBGRImage.Sharpness(m_hCamera)

        m_hDisplayBGRMutex.WaitOne()

        'Swap Receive Buffer To Display Buffer
        Dim stBitmapTmp As StBitmap = m_ReceivingBGRImage
        m_ReceivingBGRImage = m_DisplayBGRImage
        m_DisplayBGRImage = stBitmapTmp
        m_hDisplayBGRMutex.ReleaseMutex()

        'PreviewImageUpdated
        m_PreviewImageUpdatedMutex.WaitOne()
        RaiseEvent PreviewImageUpdated(Me, New EventArgs())
        m_PreviewImageUpdatedMutex.ReleaseMutex()

    End Sub

    Public Sub OnRcvError(ByVal hCamera As IntPtr, ByVal dwErrorCode As System.UInt32, ByVal lpContext As IntPtr)
        'Counter
        If ((StTrg.ERR_EXPOSURE_END_DROPPED = dwErrorCode) Or (StTrg.ERR_IMAGE_DATA_DROPPED = dwErrorCode)) Then
            m_dwDroppedFrameCount += 1
        End If

        'Access Denied
        If (Native.ERROR_ACCESS_DENIED = dwErrorCode) Then

        End If

        m_ErrorRcvedMutex.WaitOne()
        RaiseEvent ErrorRcved(dwErrorCode)
        m_ErrorRcvedMutex.ReleaseMutex()
    End Sub
    Public Function GetFPS() As Double
        Return (m_FramePerSec.GetFPS())
    End Function
    'Dropped frame count
    Public Function GetDroppedFrameCount() As Integer
        Return (m_dwDroppedFrameCount)
    End Function

    Public ReadOnly Property USBVID() As System.UInt16
        Get
            Return (m_wUSBVenderID)
        End Get
    End Property
    Public ReadOnly Property USBPID() As System.UInt16
        Get
            Return (m_wUSBProductID)
        End Get
    End Property
    Public ReadOnly Property CameraType() As String
        Get
            Dim sb As New System.Text.StringBuilder(1024)
            StTrg.GetProductName(m_hCamera, sb, Convert.ToUInt32(sb.Capacity))
            Return (sb.ToString())
        End Get
    End Property
    Public ReadOnly Property FPGAVersion() As System.UInt16
        Get
            Return (m_wFPGAVersion)
        End Get
    End Property
    Public ReadOnly Property FirmVersion() As System.UInt16
        Get
            Return (m_wFirmVersion)
        End Get
    End Property
    Public ReadOnly Property SDKVersion() As String
        Get
            Return ((m_dwFileVersionMS >> 16).ToString("D") + "." + (m_dwFileVersionMS And &HFFFF).ToString("D") + "." + _
             (m_dwFileVersionLS >> 16).ToString("D") + "." + (m_dwFileVersionLS And &HFFFF).ToString("D"))
        End Get
    End Property
    Public ReadOnly Property ColorArray() As System.UInt16
        Get
            Return (m_wColorArray)
        End Get
    End Property
    Public Function HasDisplayImage() As Boolean
        Dim result As Boolean = False
        m_hDisplayBGRMutex.WaitOne()
        result = Not IsNothing(m_DisplayBGRImage.PixelData)
        m_hDisplayBGRMutex.ReleaseMutex()
        Return (result)
    End Function
    Public Function HasTriggerFunction() As Boolean
        Dim result As Boolean = True
        Select Case (m_wUSBProductID)
            Case StTrg.STCAM_USBPID_STC_B33USB, StTrg.STCAM_USBPID_STC_C33USB, StTrg.STCAM_USBPID_STC_B83USB, StTrg.STCAM_USBPID_STC_C83USB
                result = False
        End Select
        Return (result)
    End Function
    Public Function HasDigitalGainFunction() As Boolean
        Return (HasTriggerFunction())
    End Function
    Public Function HasAnalogGainFucntion() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DISABLED_ANALOG_GAIN, nHasFunction)
        Return (nHasFunction = 0)
    End Function
    Public Function IsDigitalGainCtrl() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_AGC_GAIN_TYPE, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasBinningPartialFunction() As Boolean
        Return (HasTriggerFunction())
    End Function
    Public Function HasExposureModeTriggerControlled() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_EXPOSURE_MODE_TRIGGER_CONTROLLED, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasExposureEndHardwareTrigger() As Boolean
        Dim nHasFunction As Integer = 0
        If HasExposureModeTriggerControlled() Then
            StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_EXPOSURE_END_TRIGGER_SOURCE, nHasFunction)
        End If
        Return (nHasFunction = 0)
    End Function
    Public Function HasExposureModeTriggerWidth() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_EXPOSURE_MODE_TRIGGER_WIDTH_DISABLE, nHasFunction)
        Return (nHasFunction = 0)
    End Function
    Public Function HasCameraMemoryFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_MEMORY, nHasFunction)
        If nHasFunction <> 0 Then
            Dim nHasFunction2 As Integer = 0
            StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DISABLE_MEMORY_TYPE_SELECTION, nHasFunction2)
            If nHasFunction2 <> 0 Then
                nHasFunction = 0
            End If
        End If
        Return (nHasFunction <> 0)
    End Function
    Public Function HasTriggerOverlapFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_TRIGGER_OVERLAP, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasTriggerOverlapValue(ByVal value As System.UInt32) As Boolean
        Dim nHasFunction As Integer = 0
        Dim pnIndex() As UInteger = {StTrg.STCAM_CAMERA_FUNCTION_TRIGGER_OVERLAP_OFF, StTrg.STCAM_CAMERA_FUNCTION_TRIGGER_OVERLAP_READ_OUT, StTrg.STCAM_CAMERA_FUNCTION_TRIGGER_OVERLAP_PREVIOUS_FRAME}

        If value < pnIndex.Length Then
            StTrg.HasFunction(m_hCamera, pnIndex(CType(value, Integer)), nHasFunction)
        End If
        Return (nHasFunction <> 0)

    End Function
    Public Function HasTriggerThroughFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_PHOTOCOUPLER, nHasFunction)
        Return (Not (nHasFunction <> 0))
    End Function
    Public Function HasChangeIOFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_IO_CHANGE_DIRECTION, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasLEDFunction(ByVal nIndex As Integer) As Boolean
        Dim dwExistence As UInteger
        Dim dwMask As UInteger = 1
        StTrg.GetLEDExistence(m_hCamera, dwExistence)
        dwMask <<= nIndex
        Return ((dwExistence And dwMask) <> 0)
    End Function
    Public Function HasVGA90FPSFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_VGA90FPS, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasMirrorHorizontal() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_MIRROR_HORIZONTAL, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasMirrorVertical() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_MIRROR_VERTICAL, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasVBlankForFPS() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_V_BLANK_FOR_FPS, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasReadOut() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DISABLED_READOUT, nHasFunction)
        Return (nHasFunction = 0)   'Disabled->Enabled
    End Function
    Public Function HasLineDebounceTime() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_LINE_DEBOUNCE_TIME, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function GetSupportedSensorShutterMode() As UInteger
        Dim nHasFunction As Integer = 0
        GetSupportedSensorShutterMode = 0

        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_0, nHasFunction)
        If nHasFunction <> 0 Then GetSupportedSensorShutterMode = CUInt(GetSupportedSensorShutterMode + 1)
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_CMOS_RESET_TYPE_1, nHasFunction)
        If nHasFunction <> 0 Then GetSupportedSensorShutterMode = CUInt(GetSupportedSensorShutterMode + 2)

        Return (GetSupportedSensorShutterMode)
    End Function
    Public Function HasTriggerValidOutput() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_TRIGGER_VALID_OUT, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasAE() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_AE, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasAGC() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_AGC, nHasFunction)
        Return (nHasFunction <> 0)
    End Function

    Public Function HasCameraGamma() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_CAMERA_GAMMA, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasDigitalClamp() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DIGITAL_CLAMP, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasAnalogBlackLevel() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_ANALOG_BLACK_LEVEL, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasResetSwitchDisabledFunction() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_IO_RESET_SW_DISABLED, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasTransferEndOutput() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_TRANSFER_END_OUT, nHasFunction)
        Return (nHasFunction <> 0)
    End Function


    Public Function HasStoreCameraSetting() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_STORE_CAMERA_SETTING, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasHBinningSum() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_H_BINNING_SUM, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasVBinningSum() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_V_BINNING_SUM, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasExposureStartWaitHD() As Boolean
        Dim nHasFunction As Integer = 0
        If HasTriggerFunction() Then
            Dim nHasFunction2 As Integer = 0
            StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_HD, nHasFunction2)
            If nHasFunction2 = 0 Then
                nHasFunction = -1
            End If
        End If
        Return (nHasFunction <> 0)
    End Function
    Public Function HasExposureStartWaitReadOut() As Boolean
        Dim nHasFunction As Integer = 0
        If HasTriggerFunction() Then
            Dim nHasFunction2 As Integer = 0
            StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DISABLE_EXPOSURE_START_WAIT_READ_OUT, nHasFunction2)
            If nHasFunction2 = 0 Then
                nHasFunction = -1
            End If
        End If
        Return (nHasFunction <> 0)
    End Function
    Public Function HasAdjustmentModeDigitalGain() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_ADJUSTMENT_MODE_DIGITAL_GAIN, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function HasDeviceTemperatureMainBoard() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_DEVICE_TEMPERATURE_MAINBOARD, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function IsIOUnitUs() As Boolean
        Dim nHasFunction As Integer = 0
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_IO_UNIT_US, nHasFunction)
        Return (nHasFunction <> 0)
    End Function
    Public Function IsOpened() As Boolean
        Return (Not m_hCamera.Equals(IntPtr.Zero))
    End Function
    Public Function SaveImage(ByVal fileName As String) As Boolean
        Dim result As Boolean = False
        If HasDisplayImage() Then
            m_hDisplayBGRMutex.WaitOne()
            result = m_DisplayBGRImage.SaveImageFile(fileName)
            m_hDisplayBGRMutex.ReleaseMutex()
        End If
        Return (result)
    End Function
    Public Function Draw(ByVal hWnd As IntPtr, ByRef frameNo As System.UInt32) As Boolean
        Dim result As Boolean = False
        frameNo = 0
        If IsOpened() Then
            m_hDisplayBGRMutex.WaitOne()
            result = m_DisplayBGRImage.Draw(m_hCamera, hWnd)
            frameNo = m_DisplayBGRImage.FrameNo
            m_hDisplayBGRMutex.ReleaseMutex()
        End If
        Return (result)
    End Function
    Public Function DelayedInvalidateRequest(ByVal hWnd As IntPtr) As Boolean
        Dim result As Boolean = False
        If IsOpened() Then
            StTrg.SetDelayedInvalidateRequest(m_hCamera, hWnd)
        End If
        Return (result)
    End Function
    Public Sub ShowSettingDlg()
        If IsOpened() Then
            If IsNothing(m_frmSetting) Then
                m_frmSetting = New FormSetting(Me)
                AddHandler m_frmSetting.FormClosed, AddressOf FormSetting_FormClosed
            End If
            m_frmSetting.Show()
            m_frmSetting.Activate()
        End If
    End Sub
    Public Sub FormSetting_FormClosed(ByVal sender As Object, ByVal e As FormClosedEventArgs)
        m_frmSetting = Nothing
    End Sub

    Public Sub ShowCameraIDDlg()
        If IsOpened() Then
            Using dlg As New FormSetCameraID()
                dlg.CameraName = CameraUserName
                dlg.CameraNo = CameraUserNo
                If DialogResult.OK = dlg.ShowDialog Then
                    CameraUserName = dlg.CameraName
                    CameraUserNo = dlg.CameraNo
                End If

            End Using
        End If
    End Sub

#Region "Transfer"
    Public Function StartTransfer() As Boolean
        Dim result As Boolean = False
        If IsOpened() Then
            result = StTrg.StartTransfer(m_hCamera) <> 0
        End If
        Return (result)
    End Function
    Public Function StopTransfer() As Boolean
        Dim result As Boolean = False
        If IsOpened() Then
            result = StTrg.StopTransfer(m_hCamera) <> 0
        End If
        Return (result)
    End Function
#End Region
#Region "ScanMode"
    Private m_dwMaxROICount As System.UInt32 = 0
    Private m_nCurrentRegion As Integer = 0
    Private m_wEnableScanMode As System.UInt16 = 0
    Private m_wScanMode As System.UInt16 = 0
    Private m_pdwRegionMode() As Integer
    Private m_pdwOffsetX() As System.UInt32
    Private m_pdwOffsetY() As System.UInt32
    Private m_pdwWidth() As System.UInt32
    Private m_pdwHeight() As System.UInt32

    Public ReadOnly Property EnableScanMode() As System.UInt16
        Get
            If IsOpened() Then
                If m_wEnableScanMode = 0 Then
                    StTrg.GetEnableScanMode(m_hCamera, m_wEnableScanMode)
                End If
            End If
            Return (m_wEnableScanMode)
        End Get
    End Property

    Private m_dwMaximumImageWidth As System.UInt32 = 0
    Private m_dwMaximumImageHeight As System.UInt32 = 0

    Public ReadOnly Property MaximumImageWidth() As System.UInt32
        Get
            If IsOpened() Then
                If m_dwMaximumImageWidth = 0 Then
                    StTrg.GetMaximumImageSize(m_hCamera, m_dwMaximumImageWidth, m_dwMaximumImageHeight)
                End If
            End If
            Return (m_dwMaximumImageWidth)
        End Get
    End Property
    Public ReadOnly Property MaximumImageHeight() As System.UInt32
        Get
            If IsOpened() Then
                If m_dwMaximumImageWidth = 0 Then
                    StTrg.GetMaximumImageSize(m_hCamera, m_dwMaximumImageWidth, m_dwMaximumImageHeight)
                End If
            End If
            Return (m_dwMaximumImageHeight)
        End Get
    End Property
    Public Property CurrentRegion() As Integer
        Get
            Dim value As Integer = m_nCurrentRegion
            If m_wScanMode <> StTrg.STCAM_SCAN_MODE_ROI Then
                value = 0
            End If
            Return (value)
        End Get
        Set(ByVal value As Integer)
            If CType(m_dwMaxROICount, Integer) <= value Then
                value = CType(m_dwMaxROICount, Integer) - 1
            End If
            m_nCurrentRegion = value
        End Set
    End Property
    Public ReadOnly Property MaxRegionCount() As Integer
        Get
            Return (CType(m_dwMaxROICount, Integer))
        End Get
    End Property
    Public Function GetScanMode() As Boolean
        Dim bReval As Boolean = True
        If IsOpened() Then
            If m_dwMaxROICount < 1 Then
                bReval = StTrg.GetMaxROICount(m_hCamera, m_dwMaxROICount) <> 0
                If m_dwMaxROICount < 1 Then
                    m_dwMaxROICount = 1
                End If
                Dim nROICount As Integer = CType(m_dwMaxROICount, Integer)
                ReDim m_pdwRegionMode(nROICount - 1)
                ReDim m_pdwOffsetX(nROICount - 1)
                ReDim m_pdwOffsetY(nROICount - 1)
                ReDim m_pdwWidth(nROICount - 1)
                ReDim m_pdwHeight(nROICount - 1)
            End If
            bReval = StTrg.GetScanMode(m_hCamera, m_wScanMode, m_pdwOffsetX(0), m_pdwOffsetY(0), m_pdwWidth(0), m_pdwHeight(0)) <> 0
            m_pdwRegionMode(0) = 1
            For nRegionIndex As Integer = 1 To CType(m_dwMaxROICount, Integer) - 1
                bReval = StTrg.GetROI(m_hCamera, CType(nRegionIndex, UInteger), m_pdwRegionMode(nRegionIndex), m_pdwOffsetX(nRegionIndex), m_pdwOffsetY(nRegionIndex), m_pdwWidth(nRegionIndex), m_pdwHeight(nRegionIndex)) <> 0
            Next
        End If
        Return (bReval)
    End Function
    Public Function SetScanMode(ByVal nRegionIndex As Integer) As Boolean
        Dim bReval As Boolean = True
        If IsOpened() Then
            If nRegionIndex = 0 Then
                bReval = StTrg.SetScanMode(m_hCamera, m_wScanMode, m_pdwOffsetX(nRegionIndex), m_pdwOffsetY(nRegionIndex), m_pdwWidth(nRegionIndex), m_pdwHeight(nRegionIndex)) <> 0
            Else
                bReval = StTrg.SetROI(m_hCamera, CType(nRegionIndex, UInteger), m_pdwRegionMode(nRegionIndex), m_pdwOffsetX(nRegionIndex), m_pdwOffsetY(nRegionIndex), m_pdwWidth(nRegionIndex), m_pdwHeight(nRegionIndex)) <> 0
            End If
        End If
        Return (bReval)
    End Function

    Public Property ScanMode() As System.UInt16
        Get
            Return (m_wScanMode)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StopTransfer()
                m_wScanMode = value
                SetScanMode(0)
                GetScanMode()
                GetSkippingBinning()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property RegionMode() As Boolean
        Get
            Return (m_pdwRegionMode(CurrentRegion()) <> 0)
        End Get
        Set(ByVal value As Boolean)
            If IsOpened() Then
                StopTransfer()
                If value Then
                    m_pdwRegionMode(CurrentRegion()) = 1
                Else
                    m_pdwRegionMode(CurrentRegion()) = 0
                End If
                SetScanMode(CurrentRegion())
                GetScanMode()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ImageOffsetX() As System.UInt32
        Get
            Return (m_pdwOffsetX(CurrentRegion()))
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                m_pdwOffsetX(CurrentRegion()) = value
                SetScanMode(CurrentRegion())
                GetScanMode()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ImageOffsetY() As System.UInt32
        Get
            Return (m_pdwOffsetY(CurrentRegion()))
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                m_pdwOffsetY(CurrentRegion()) = value
                SetScanMode(CurrentRegion())
                GetScanMode()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ImageWidth() As System.UInt32
        Get
            Return (m_pdwWidth(CurrentRegion()))
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                m_pdwWidth(CurrentRegion()) = value
                SetScanMode(CurrentRegion())
                GetScanMode()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ImageHeight() As System.UInt32
        Get
            Return (m_pdwHeight(CurrentRegion()))
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                m_pdwHeight(CurrentRegion()) = value
                SetScanMode(CurrentRegion())
                GetScanMode()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property EnableImageOffsetX() As Boolean
        Get
            Return (m_wScanMode = StTrg.STCAM_SCAN_MODE_ROI)
        End Get
    End Property
    Public ReadOnly Property EnableImageWidth() As Boolean
        Get
            Return (m_wScanMode = StTrg.STCAM_SCAN_MODE_ROI)
        End Get
    End Property
    Public ReadOnly Property EnableImageOffsetY() As Boolean
        Get
            Dim enabled As Boolean = False
            Select Case (m_wScanMode)
                Case StTrg.STCAM_SCAN_MODE_ROI, StTrg.STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL, StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL
                    enabled = True
            End Select
            Return (enabled)
        End Get
    End Property
    Public ReadOnly Property EnableImageHeight() As Boolean
        Get
            Dim enabled As Boolean = False
            Select Case (m_wScanMode)
                Case StTrg.STCAM_SCAN_MODE_ROI, StTrg.STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL, StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL
                    enabled = True
            End Select
            Return (enabled)
        End Get
    End Property

    Dim m_byteHSkipping As Byte = 0
    Dim m_byteVSkipping As Byte = 0
    Dim m_byteHBinning As Byte = 0
    Dim m_byteVBinning As Byte = 0

    Public Function GetSkippingBinning() As Boolean
        Dim bReval As Boolean = False
        If IsOpened() Then
            bReval = StTrg.GetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning) <> 0
        End If
        Return (bReval)
    End Function
    Public Property HBinningSkipping() As System.UInt16
        Get
            Return ((Convert.ToUInt16(m_byteHBinning) << 8) Or m_byteHSkipping)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StopTransfer()
                m_byteHBinning = Convert.ToByte(value >> 8)
                m_byteHSkipping = Convert.ToByte(value And &HFF)
                StTrg.SetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning)
                GetScanMode()
                GetSkippingBinning()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property VBinningSkipping() As System.UInt16
        Get
            Return ((Convert.ToUInt16(m_byteVBinning) << 8) Or m_byteVSkipping)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StopTransfer()
                m_byteVBinning = Convert.ToByte(value >> 8)
                m_byteVSkipping = Convert.ToByte(value And &HFF)
                StTrg.SetSkippingAndBinning(m_hCamera, m_byteHSkipping, m_byteVSkipping, m_byteHBinning, m_byteVBinning)
                GetScanMode()
                GetSkippingBinning()
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property BinningSumMode() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetBinningSumMode(m_hCamera, value)
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetBinningSumMode(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region

#Region "TransferBitsPerPixel"
    Private m_dwTransferBitsPerPixel As System.UInt32 = 0
    Private m_dwEnableTransferBitsPerPixel As System.UInt32 = 0
    Public Property TransferBitsPerPixel() As System.UInt32
        Get
            If IsOpened() Then
                If (m_dwTransferBitsPerPixel = 0) Then
                    StTrg.GetTransferBitsPerPixel(m_hCamera, m_dwTransferBitsPerPixel)
                End If
            End If
            Return (m_dwTransferBitsPerPixel)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetTransferBitsPerPixel(m_hCamera, value)
                m_dwTransferBitsPerPixel = value
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property EnableTransferBitsPerPixel() As System.UInt32
        Get
            If (IsOpened()) Then
                If (m_dwEnableTransferBitsPerPixel = 0) Then
                    StTrg.GetEnableTransferBitsPerPixel(m_hCamera, m_dwEnableTransferBitsPerPixel)
                End If
            End If
            Return (m_dwEnableTransferBitsPerPixel)
        End Get
    End Property
#End Region

#Region "PriorityMode"
    Private m_dwPriorityMode As System.UInt32 = 0
    Private m_bEnablePriorityMode As Integer = 0
    Public Property PriorityMode() As System.UInt32
        Get
            If IsOpened() Then
                StTrg.GetPriorityMode(m_hCamera, m_dwPriorityMode)
            End If
            Return (m_dwPriorityMode)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetPriorityMode(m_hCamera, value)
                m_dwPriorityMode = value
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property EnablePriorityMode() As Integer
        Get
            If (IsOpened()) Then
                StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_PRIORITY_MODE, m_bEnablePriorityMode)
            End If
            Return (m_bEnablePriorityMode)
        End Get
    End Property
#End Region

#Region "EEPROM"
    Public Property CameraUserNo() As UInteger
        Get
            Dim cameraNo As UInteger = 0
            If (IsOpened()) Then
                Dim sb As New System.Text.StringBuilder(125)
                StTrg.ReadCameraUserID(m_hCamera, cameraNo, sb, 250)


            End If
            Return (cameraNo)
        End Get
        Set(ByVal value As UInteger)
            If IsOpened() Then
                Dim cameraNo As UInteger = 0
                Dim sb As New System.Text.StringBuilder(125)
                StTrg.ReadCameraUserID(m_hCamera, cameraNo, sb, 250)

                Dim cameraName As String = sb.ToString()
                cameraNo = value
                StTrg.WriteCameraUserID(m_hCamera, cameraNo, cameraName, 250)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property CameraUserName() As String
        Get
            Dim cameraName As String = ""
            If (IsOpened()) Then
                Dim cameraNo As UInteger = 0
                Dim sb As New System.Text.StringBuilder(125)
                StTrg.ReadCameraUserID(m_hCamera, cameraNo, sb, 250)
                cameraName = sb.ToString()
            End If
            Return (cameraName)
        End Get
        Set(ByVal value As String)
            If IsOpened() Then
                Dim cameraNo As UInteger = 0
                Dim sb As New System.Text.StringBuilder(125)
                StTrg.ReadCameraUserID(m_hCamera, cameraNo, sb, 250)

                Dim cameraName As String = value
                StTrg.WriteCameraUserID(m_hCamera, cameraNo, cameraName, 250)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region
#Region "Clock"
    Public ReadOnly Property EnableClockMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetEnableClockMode(m_hCamera, value)
            End If
            Return (value)
        End Get
    End Property
    Public Property ClockMode() As System.UInt32
        Get
            Dim dwClockMode As System.UInt32 = 0
            Dim dwClock As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetClock(m_hCamera, dwClockMode, dwClock)
            End If
            Return (dwClockMode)
        End Get
        Set(ByVal value As System.UInt32)
            Dim dwClockMode As System.UInt32 = value
            Dim dwClock As System.UInt32 = 0
            If IsOpened() Then
                StopTransfer()
                StTrg.SetClock(m_hCamera, dwClockMode, dwClock)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property PixelClock() As System.UInt32
        Get
            Dim dwClockMode As System.UInt32 = 0
            Dim dwClock As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetClock(m_hCamera, dwClockMode, dwClock)
            End If
            Return (dwClock)
        End Get
    End Property
    Public ReadOnly Property ClocksPerFrame() As System.UInt32
        Get
            Dim totalVLine As System.UInt16 = 0
            Dim totalHClock As System.UInt16 = 0

            If IsOpened() Then
                StTrg.GetFrameClock(m_hCamera, totalVLine, totalHClock)
            End If
            Return (CUInt(totalVLine) * CUInt(totalHClock))
        End Get
    End Property

    Public Property VBlankForFPS() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetVBlankForFPS(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetVBlankForFPS(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property MaxVBlankForFPS() As System.UInt32
        Get
            Return (m_dwMaxVBlankForFPS)
        End Get
    End Property
    Public ReadOnly Property OutputFPS() As System.Single
        Get
            Dim value As System.Single = 0
            If IsOpened() Then
                StTrg.GetOutputFPS(m_hCamera, value)
            End If
            Return (value)
        End Get
    End Property

#End Region

#Region "Shutter Gain Control"
    Public Property ExposureClock() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetExposureClock(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetExposureClock(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property MaxExposureClock() As System.UInt32
        Get
            Dim value As UInt32 = 0

            If IsOpened() Then
                Select Case ScanMode
                    Case StTrg.STCAM_SCAN_MODE_ROI, StTrg.STCAM_SCAN_MODE_PARTIAL_1, StTrg.STCAM_SCAN_MODE_PARTIAL_2, StTrg.STCAM_SCAN_MODE_PARTIAL_4, StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_1, StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_2, StTrg.STCAM_SCAN_MODE_BINNING_PARTIAL_4
                        StTrg.GetMaxLongExposureClock(m_hCamera, value)
                    Case Else
                        StTrg.GetMaxShortExposureClock(m_hCamera, value)
                End Select
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property ExposureTimeText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fExpTime As Single = 0
                StTrg.GetExposureTimeFromClock(m_hCamera, ExposureClock(), fExpTime)
                If fExpTime <> 0 Then
                    Dim dblRevS As Double = 1.0 / fExpTime
                    value = "1/" + dblRevS.ToString("N2") + " s"
                End If
            End If
            Return (value)
        End Get
    End Property
    Public Property Gain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetGain(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetGain(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property GainText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                If HasAnalogGainFucntion() Then
                    Dim fdB As Single = 0
                    StTrg.GetGainDBFromSettingValue(m_hCamera, Gain(), fdB)
                    value = fdB.ToString("N2") + " dB"
                End If
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property MaxGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetMaxGain(m_hCamera, value)
            End If
            Return (value)
        End Get
    End Property
    Public Property DigitalGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetDigitalGain(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetDigitalGain(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property DigitalGainText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fTimes As Single = 0
                StTrg.GetDigitalGainTimesFromSettingValue(m_hCamera, DigitalGain(), fTimes)
                value = "x " + fTimes.ToString("N2")
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property MaxDigitalGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetMaxDigitalGain(m_hCamera, value)
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property DigitalGainOffValue() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetDigitalGainSettingValueFromGainTimes(m_hCamera, 1.0, value)
            End If
            Return (value)
        End Get
    End Property



    Public Property ALCMode() As System.Byte
        Get
            Dim value As System.Byte = 0
            If IsOpened() Then
                StTrg.GetALCMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.Byte)
            If IsOpened() Then
                StTrg.SetALCMode(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property IsAGCOn() As Boolean
        Get
            Dim value As Boolean = True
            Select Case ALCMode
                Case StTrg.STCAM_ALCMODE_CAMERA_AE_AGC_ON, StTrg.STCAM_ALCMODE_CAMERA_AGC_ON, StTrg.STCAM_ALCMODE_PC_AE_AGC_ON, StTrg.STCAM_ALCMODE_PC_AE_AGC_ONESHOT, StTrg.STCAM_ALCMODE_PC_AGC_ON, StTrg.STCAM_ALCMODE_PC_AGC_ONESHOT
                    value = True
                Case Else
                    value = False
            End Select
            Return (value)
        End Get
    End Property
    Public ReadOnly Property IsAEOn() As Boolean
        Get
            Dim value As Boolean = True
            Select Case ALCMode
                Case StTrg.STCAM_ALCMODE_CAMERA_AE_AGC_ON, StTrg.STCAM_ALCMODE_CAMERA_AE_ON, StTrg.STCAM_ALCMODE_PC_AE_AGC_ON, StTrg.STCAM_ALCMODE_PC_AE_AGC_ONESHOT, StTrg.STCAM_ALCMODE_PC_AE_ON, StTrg.STCAM_ALCMODE_PC_AE_ONESHOT
                    value = True
                Case Else
                    value = False
            End Select
            Return (value)
        End Get
    End Property
    Public Property ALCTargetLevel() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetALCTargetLevel(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetALCTargetLevel(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property AGCMaxGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetAGCMaxGain(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetAGCMaxGain(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property AGCMinGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetAGCMinGain(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetAGCMinGain(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property AGCMaxGainText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fValue As Single = 0
                If IsDigitalGainCtrl() Then
                    StTrg.GetDigitalGainTimesFromSettingValue(m_hCamera, AGCMaxGain, fValue)
                    value = "x " + fValue.ToString("N2")
                Else
                    StTrg.GetGainDBFromSettingValue(m_hCamera, AGCMaxGain, fValue)
                    value = fValue.ToString("N2") + "dB"
                End If
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property AGCMinGainText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fValue As Single = 0
                If IsDigitalGainCtrl() Then
                    StTrg.GetDigitalGainTimesFromSettingValue(m_hCamera, AGCMinGain, fValue)
                    value = "x " + fValue.ToString("N2")
                Else
                    StTrg.GetGainDBFromSettingValue(m_hCamera, AGCMinGain, fValue)
                    value = fValue.ToString("N2") + "dB"
                End If
            End If
            Return (value)
        End Get
    End Property
    Public Property AEMaxExposureClock() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetAEMaxExposureClock(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetAEMaxExposureClock(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property AEMinExposureClock() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetAEMinExposureClock(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetAEMinExposureClock(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property AEMaxExposureTimeText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fExpTime As Single = 0
                StTrg.GetExposureTimeFromClock(m_hCamera, AEMaxExposureClock(), fExpTime)
                If fExpTime <> 0 Then
                    Dim dblRevS As Double = 1.0 / fExpTime
                    value = "1/" + dblRevS.ToString("N2") + " s"
                End If
            End If
            Return (value)
        End Get
    End Property
    Public ReadOnly Property AEMinExposureTimeText() As String
        Get
            Dim value As String = ""
            If IsOpened() Then
                Dim fExpTime As Single = 0
                StTrg.GetExposureTimeFromClock(m_hCamera, AEMinExposureClock(), fExpTime)
                If fExpTime <> 0 Then
                    Dim dblRevS As Double = 1.0 / fExpTime
                    value = "1/" + dblRevS.ToString("N2") + " s"
                End If
            End If
            Return (value)
        End Get
    End Property

#End Region

#Region "AdjustmentMode"
    Protected Property AdjustmentMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetAdjustmentMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetAdjustmentMode(m_hCamera, value)
            End If
        End Set
    End Property
    Public Property EnableAdjustmentDigitalGain() As Boolean
        Get
            Dim value As Boolean = False
            If HasAdjustmentModeDigitalGain() Then
                value = ((AdjustmentMode() And StTrg.STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN) <> 0)
            End If
            Return (value)
        End Get
        Set(ByVal value As Boolean)
            If HasAdjustmentModeDigitalGain() Then
                Dim dwValue As System.UInt32 = AdjustmentMode()
                If value Then
                    dwValue = (dwValue Or StTrg.STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN)
                Else
                    dwValue = (dwValue And (Not StTrg.STCAM_ADJUSTMENT_MODE_DIGITAL_GAIN))
                End If
                AdjustmentMode = dwValue
            End If
        End Set
    End Property
#End Region
#Region "Trigger"
    Private Property TriggerMode(ByVal mask As System.UInt32) As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                Dim dwTriggerMode As System.UInt32 = 0
                StTrg.GetTriggerMode(m_hCamera, dwTriggerMode)
                value = dwTriggerMode And mask
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                Dim dwTriggerMode As System.UInt32 = 0
                StTrg.GetTriggerMode(m_hCamera, dwTriggerMode)

                dwTriggerMode = dwTriggerMode And (Not mask)
                dwTriggerMode = dwTriggerMode Or (value And mask)
                StTrg.SetTriggerMode(m_hCamera, dwTriggerMode)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

    Public Property ExposureEnd() As System.UInt32
        Get
            Return (TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPEND_MASK))
        End Get
        Set(ByVal value As System.UInt32)
            TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPEND_MASK) = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property CameraMemory() As System.UInt32
        Get
            Return (TriggerMode(StTrg.STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK))
        End Get
        Set(ByVal value As System.UInt32)
            TriggerMode(StTrg.STCAM_TRIGGER_MODE_CAMERA_MEMORY_MASK) = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property SensorShutterMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetSensorShutterMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetSensorShutterMode(m_hCamera, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ExposureMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetExposureMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetExposureMode(m_hCamera, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Protected m_nTriggerSelector As UInt32 = 0
    Public Property TriggerSelector() As UInt32
        Get
            Return (m_nTriggerSelector)
        End Get
        Set(ByVal value As UInt32)
            m_nTriggerSelector = value
        End Set
    End Property
    Public Property TriggerMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetTriggerMode2(m_hCamera, m_nTriggerSelector, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetTriggerMode2(m_hCamera, m_nTriggerSelector, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property


    Public Property TriggerSource() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetTriggerSource(m_hCamera, m_nTriggerSelector, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetTriggerSource(m_hCamera, m_nTriggerSelector, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Function HasGenICamIO() As Boolean
        Dim result As Integer
        StTrg.HasFunction(m_hCamera, StTrg.STCAM_CAMERA_FUNCTION_GENICAM_IO, result)
        Return (result <> 0)
    End Function

    Public Property TriggerDelay() As UInt32
        Get
            Dim nValue As UInt32 = 0
            If IsOpened() Then
                StTrg.GetTriggerDelay(m_hCamera, m_nTriggerSelector, nValue)
            End If
            Return (nValue)
        End Get
        Set(ByVal value As UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetTriggerDelay(m_hCamera, m_nTriggerSelector, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

    Public ReadOnly Property TriggerDelayText() As String
        Get
            Dim text As String = ""

            Dim value As System.UInt32 = TriggerDelay

            If IsIOUnitUs() Then
                text = value.ToString() & "us"
            Else
                Dim clockMode As System.UInt32 = 0
                Dim pixelClock As System.UInt32 = 0
                StTrg.GetClock(m_hCamera, clockMode, pixelClock)

                Dim time As Double = 0.0
                If (pixelClock <> 0) Then
                    time = value / CDbl(pixelClock)
                End If

                If 1.0 <= time Then
                    text = String.Format("{0:N1}s", time)
                Else
                    time *= 1000.0
                    If 1.0 <= time Then
                        text = String.Format("{0:N1}ms", time)
                    Else
                        time *= 1000.0
                        If 1.0 <= time Then
                            text = String.Format("{0:N1}us", time)
                        Else
                            time *= 1000.0
                            text = String.Format("{0:N1}ns", time)
                        End If
                    End If
                End If
            End If
            Return (text)
        End Get
    End Property
    Public Property TriggerOverlap() As System.UInt32
        Get
            Dim nValue As UInt32 = 0
            If IsOpened() Then
                StTrg.GetTriggerOverlap(m_hCamera, m_nTriggerSelector, nValue)
            End If
            Return (nValue)
        End Get
        Set(ByVal value As UInt32)
            If IsOpened() Then
                StopTransfer()
                StTrg.SetTriggerOverlap(m_hCamera, m_nTriggerSelector, value)
                StartTransfer()
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

    Public Function IsAnyTriggerModeON() As Boolean
        If Not HasTriggerFunction() Then
            Return (False)
        End If

        Dim aSelector() As UInt32 = New UInt32() { _
                                    StTrg.STCAM_TRIGGER_SELECTOR_FRAME_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_FRAME_BURST_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_START, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_END, _
                                    StTrg.STCAM_TRIGGER_SELECTOR_SENSOR_READ_OUT_START}

        For i As Integer = 0 To aSelector.GetLength(0) - 1
            Dim isSupported As Integer = 0
            StTrg.IsTriggerSelectorSupported(m_hCamera, aSelector(i), isSupported)
            If isSupported <> 0 Then
                Dim dwTriggerMode As UInt32 = 0
                StTrg.GetTriggerMode2(m_hCamera, aSelector(i), dwTriggerMode)
                If dwTriggerMode = StTrg.STCAM_TRIGGER_MODE_ON Then
                    Return (True)
                End If
            End If
        Next
        Return (False)
    End Function



    Public Property ExposureWaitHD() As System.UInt32
        Get
            Return (TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK))
        End Get
        Set(ByVal value As System.UInt32)
            TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_HD_MASK) = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property ExposureWaitReadOut() As System.UInt32
        Get
            Return (TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK))
        End Get
        Set(ByVal value As System.UInt32)
            TriggerMode(StTrg.STCAM_TRIGGER_MODE_EXPOSURE_WAIT_READOUT_MASK) = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property AutoTriggerDueTime() As Integer
        Get
            Return (m_AutoTriggerDueTime)
        End Get
        Set(ByVal value As Integer)
            m_AutoTriggerDueTime = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public ReadOnly Property AutoTriggerDueTimeText() As String
        Get
            Dim text As New System.Text.StringBuilder
            Dim ms As Integer = AutoTriggerDueTime
            If ms = 0 Then
                text.Append("0ms")
            Else
                Dim min As Integer = CInt(ms / 60000)
                If 0 < min Then
                    ms = ms Mod 60000
                    text.Append(min.ToString() & "min ")
                End If

                Dim s As Integer = CInt(ms / 1000)
                If 0 < s Then
                    ms = ms Mod 1000
                    text.Append(s.ToString() & "s ")
                End If

                If 0 < ms Then
                    text.Append(ms.ToString() & "ms")
                End If
            End If
            Return (text.ToString())
        End Get
    End Property
    Public Property IsAutoTriggerMode() As Boolean
        Get
            Return (m_isAutoTriggerMode)
        End Get
        Set(ByVal value As Boolean)
            m_isAutoTriggerMode = value
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property


    Public Function TriggerSoftware(ByVal dwTriggerSelector As UInt32) As Boolean
        Dim result As Integer = 0
        If IsOpened() Then
            result = StTrg.TriggerSoftware(m_hCamera, dwTriggerSelector)
            If m_isAutoTriggerMode Then
                m_AutoTriggerTimer.Change(m_AutoTriggerDueTime, System.Threading.Timeout.Infinite)
            End If
        End If
        Return (result <> 0)
    End Function

    Public Function IsEnableTriggerSoftware(ByVal dwTriggerSelector As UInt32) As Boolean
        If Not Me.HasTriggerFunction() Then
            Return (False)
        End If

        Dim triggerMode As UInt32
        StTrg.GetTriggerMode2(m_hCamera, dwTriggerSelector, triggerMode)
        If triggerMode = StTrg.STCAM_TRIGGER_MODE_OFF Then
            Return (False)
        End If

        Dim triggerSource As UInt32
        StTrg.GetTriggerSource(m_hCamera, dwTriggerSelector, triggerSource)
        If triggerSource <> StTrg.STCAM_TRIGGER_SOURCE_SOFTWARE Then
            Return (False)
        End If

        If (dwTriggerSelector = StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_START) Or (dwTriggerSelector = StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_END) Then
            If dwTriggerSelector = StTrg.STCAM_TRIGGER_SELECTOR_EXPOSURE_END Then
                If Me.IsAutoTriggerMode Then
                    Return (False)
                End If

                Dim exposureMode As UInt32
                StTrg.GetExposureMode(m_hCamera, exposureMode)
                If exposureMode <> StTrg.STCAM_EXPOSURE_MODE_TRIGGER_CONTROLLED Then
                    Return (False)
                End If
            End If
        End If
        Return (True)
    End Function

    Public Function IsTriggerSelectorSupported(ByVal dwTriggerSelector As UInt32) As Boolean
        If Not IsOpened() Then
            Return (False)
        End If
        If Not Me.HasTriggerFunction() Then
            Return (False)
        End If

        Dim value As Integer
        StTrg.IsTriggerSelectorSupported(m_hCamera, dwTriggerSelector, value)

        Return (value <> 0)
    End Function
    Public Function ClearBuffer() As Boolean
        Dim result As Integer = 0
        If IsOpened() Then
            StopTransfer()
            result = StTrg.ClearBuffer(m_hCamera)
            StartTransfer()
        End If
        Return (result <> 0)
    End Function
    Public Function ResetCounter() As Boolean
        Dim result As Integer = 0
        If IsOpened() Then
            result = StTrg.ResetCounter(m_hCamera)
        End If
        Return (result <> 0)
    End Function
#End Region

#Region "LED/ResetSwitch"
    Public Property LEDGreen() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                Dim ledStatus As System.UInt32 = 0
                StTrg.GetLEDStatus(m_hCamera, ledStatus)
                value = ledStatus And StTrg.STCAM_LED_GREEN_ON
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                Dim ledStatus As System.UInt32 = 0
                StTrg.GetLEDStatus(m_hCamera, ledStatus)
                ledStatus = ledStatus And (Not StTrg.STCAM_LED_GREEN_ON)
                ledStatus = ledStatus Or (value And StTrg.STCAM_LED_GREEN_ON)
                StTrg.SetLEDStatus(m_hCamera, ledStatus)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property LEDRed() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                Dim ledStatus As System.UInt32 = 0
                StTrg.GetLEDStatus(m_hCamera, ledStatus)
                value = ledStatus And StTrg.STCAM_LED_RED_ON
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                Dim ledStatus As System.UInt32 = 0
                StTrg.GetLEDStatus(m_hCamera, ledStatus)
                ledStatus = ledStatus And (Not StTrg.STCAM_LED_RED_ON)
                ledStatus = ledStatus Or (value And StTrg.STCAM_LED_RED_ON)
                StTrg.SetLEDStatus(m_hCamera, ledStatus)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ResetSwitchEnabled() As Boolean
        Get
            Dim nValue As Integer = 0
            If IsOpened() Then
                StTrg.GetResetSwitchEnabled(m_hCamera, nValue)
            End If
            Return (nValue <> 0)
        End Get
        Set(ByVal value As Boolean)
            If IsOpened() Then
                StTrg.SetResetSwitchEnabled(m_hCamera, CInt(IIf(value, -1, 0)))
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region
#Region "Device Temperature"
    Public ReadOnly Property DeviceTemperatureMainBoard() As System.Int32
        Get
            Dim value As System.Int32 = 0
            If HasDeviceTemperatureMainBoard() Then
                StTrg.GetDeviceTemperature(m_hCamera, StTrg.STCAM_DEVICE_TEMPERATURE_MAINBOARD, value)
            End If
            Return (value)
        End Get
    End Property
#End Region
#Region "White Balance Control"
    Public Property WBRGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                value = gainR
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                gainR = value
                StTrg.SetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property WBGrGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                value = gainGr
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                gainGr = value
                StTrg.SetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property WBGbGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                value = gainGb
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                gainGb = value
                StTrg.SetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property WBBGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                value = gainB
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim gainR As System.UInt16 = 0
                Dim gainGr As System.UInt16 = 0
                Dim gainGb As System.UInt16 = 0
                Dim gainB As System.UInt16 = 0
                StTrg.GetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                gainB = value
                StTrg.SetWhiteBalanceGain(m_hCamera, gainR, gainGr, gainGb, gainB)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property WhiteBalanceMode() As Byte
        Get
            Dim value As Byte = 0
            If IsOpened() Then
                StTrg.GetWhiteBalanceMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If IsOpened() Then
                StTrg.SetWhiteBalanceMode(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region

#Region "Hue Saturation Control"
    Public Property Hue() As Short
        Get
            Dim byteHueSaturationMode As Byte = 0
            Dim shtHue As Short = 0
            Dim wSaturation As System.UInt16 = 100
            If IsOpened() Then
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
            End If
            Return (shtHue)
        End Get
        Set(ByVal value As Short)
            If IsOpened() Then
                Dim byteHueSaturationMode As Byte = 0
                Dim shtHue As Short = 0
                Dim wSaturation As System.UInt16 = 100
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                shtHue = value
                StTrg.SetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property Saturation() As System.UInt16
        Get
            Dim byteHueSaturationMode As Byte = 0
            Dim shtHue As Short = 0
            Dim wSaturation As System.UInt16 = 100
            If IsOpened() Then
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
            End If
            Return (wSaturation)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim byteHueSaturationMode As Byte = 0
                Dim shtHue As Short = 0
                Dim wSaturation As System.UInt16 = 100
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                wSaturation = value
                StTrg.SetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property HueSaturationMode() As Byte
        Get
            Dim byteHueSaturationMode As Byte = 0
            Dim shtHue As Short = 0
            Dim wSaturation As System.UInt16 = 100
            If IsOpened() Then
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
            End If
            Return (byteHueSaturationMode)
        End Get
        Set(ByVal value As Byte)
            If IsOpened() Then
                Dim byteHueSaturationMode As Byte = 0
                Dim shtHue As Short = 0
                Dim wSaturation As System.UInt16 = 100
                StTrg.GetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                byteHueSaturationMode = value
                StTrg.SetHueSaturationMode(m_hCamera, byteHueSaturationMode, shtHue, wSaturation)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property HighChromaSuppressionStartLevel() As System.UInt16
        Get
            Dim wStartLevel As System.UInt16 = 255
            Dim wSuppression As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetChromaSuppression(m_hCamera, wStartLevel, wSuppression)
            End If
            Return (wStartLevel)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetChromaSuppression(m_hCamera, value, HighChromaSuppressionSuppressionLevel)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property HighChromaSuppressionSuppressionLevel() As System.UInt16
        Get
            Dim wStartLevel As System.UInt16 = 255
            Dim wSuppression As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetChromaSuppression(m_hCamera, wStartLevel, wSuppression)
            End If
            Return (wSuppression)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetChromaSuppression(m_hCamera, HighChromaSuppressionStartLevel, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property LowChromaSuppressionStartLevel() As System.UInt16
        Get
            Dim wStartLevel As System.UInt16 = 255
            Dim wSuppression As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetLowChromaSuppression(m_hCamera, wStartLevel, wSuppression)
            End If
            Return (wStartLevel)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetLowChromaSuppression(m_hCamera, value, LowChromaSuppressionSuppressionLevel)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property LowChromaSuppressionSuppressionLevel() As System.UInt16
        Get
            Dim wStartLevel As System.UInt16 = 255
            Dim wSuppression As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetLowChromaSuppression(m_hCamera, wStartLevel, wSuppression)
            End If
            Return (wSuppression)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetLowChromaSuppression(m_hCamera, LowChromaSuppressionStartLevel, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

#End Region

#Region "HDR"
    Protected m_dwHDRType As System.UInt32 = 0
    Protected m_dwHDRParameterSize As System.UInt32 = 0
    Protected m_pdwHDRParameterBuffer() As System.UInt32 = Nothing
    Protected Function ReadHDRSetting() As Boolean
        Dim result As Boolean = False
        Do
            If Not IsOpened() Then
                Exit Do
            End If

            result = (StTrg.GetHDRType(m_hCamera, m_dwHDRType) <> 0)
            If Not result Then Exit Do
            If (m_dwHDRType = 0) Then Exit Do

            result = (StTrg.GetHDRParameter(m_hCamera, IntPtr.Zero, m_dwHDRParameterSize) <> 0)
            If Not result Then Exit Do

            ReDim m_pdwHDRParameterBuffer(CType(m_dwHDRParameterSize / 4, Integer) - 1)
            Dim gch As GCHandle = GCHandle.Alloc(m_pdwHDRParameterBuffer, GCHandleType.Pinned)
            Dim pvBuffer As IntPtr = gch.AddrOfPinnedObject()
            result = (StTrg.GetHDRParameter(m_hCamera, pvBuffer, m_dwHDRParameterSize) <> 0)
            gch.Free()
        Loop While (False)
        Return (result)
    End Function
    Protected Function WriteHDRSetting() As Boolean
        Dim result As Boolean = False
        Do
            If Not IsOpened() Then
                Exit Do
            End If
            If (m_dwHDRType = 0) Then Exit Do

            Dim gch As GCHandle = GCHandle.Alloc(m_pdwHDRParameterBuffer, GCHandleType.Pinned)
            Dim pvBuffer As IntPtr = gch.AddrOfPinnedObject()
            result = (StTrg.SetHDRParameter(m_hCamera, pvBuffer, m_dwHDRParameterSize) <> 0)
            gch.Free()
        Loop While (False)
        Return (result)
    End Function
    Public ReadOnly Property HDRType() As System.UInt32
        Get
            Return (m_dwHDRType)
        End Get
    End Property
    Public Property HDR_CMOSIS4M_Mode() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (1 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType(m_pdwHDRParameterBuffer(0) And 1, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (1 <= m_pdwHDRParameterBuffer.Length) Then
                If 0 < value Then
                    m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) Or CType(1, UInt32))
                Else
                    m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) And (Not CType(1, UInt32)))
                End If
                WriteHDRSetting()
            End If
        End Set
    End Property
    Public Property HDR_CMOSIS4M_SlopeNum() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (1 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType((m_pdwHDRParameterBuffer(0) >> 8) And 3, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (1 <= m_pdwHDRParameterBuffer.Length) Then
                m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) And (Not CType(&H300, UInt32)))
                m_pdwHDRParameterBuffer(0) = (m_pdwHDRParameterBuffer(0) Or (CType(value, UInt32) << 8))
                WriteHDRSetting()
            End If
        End Set
    End Property
    Public Property HDR_CMOSIS4M_Vlow3() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType((m_pdwHDRParameterBuffer(1)) And &HFF, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not CType(&HFF, UInt32)))
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or CType(value, UInt32))
                WriteHDRSetting()
            End If
        End Set
    End Property
    Public Property HDR_CMOSIS4M_Vlow2() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType((m_pdwHDRParameterBuffer(1) >> 8) And &HFF, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not CType(&HFF00, UInt32)))
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or (CType(value, UInt32) << 8))
                WriteHDRSetting()
            End If
        End Set
    End Property
    Public Property HDR_CMOSIS4M_Knee2() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType((m_pdwHDRParameterBuffer(1) >> 16) And &HFF, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not CType(&HFF0000, UInt32)))
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or (CType(value, UInt32) << 16))
                WriteHDRSetting()
            End If
        End Set
    End Property
    Public Property HDR_CMOSIS4M_Knee1() As Byte
        Get
            Dim value As Byte = 0
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                value = CType((m_pdwHDRParameterBuffer(1) >> 24) And &HFF, Byte)
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If (Not IsNothing(m_pdwHDRParameterBuffer)) And (2 <= m_pdwHDRParameterBuffer.Length) Then
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) And (Not CType(&HFF000000L, UInt32)))
                m_pdwHDRParameterBuffer(1) = (m_pdwHDRParameterBuffer(1) Or (CType(value, UInt32) << 24))
                WriteHDRSetting()
            End If
        End Set
    End Property
#End Region

#Region "Save Image"
    Public Function SaveImage(ByVal dwWidth As System.UInt32, ByVal dwHeight As System.UInt32, ByVal dwPreviewPixelFormat As System.UInt32, ByVal pbyteData As IntPtr, ByVal szFileName As String, ByVal dwParam As System.UInt32) As Boolean
        Dim result As Integer
        If IsOpened() Then
            result = StTrg.SaveImage(dwWidth, dwHeight, dwPreviewPixelFormat, pbyteData, szFileName, dwParam)
        End If
        Return (result <> 0)
    End Function
#End Region
#Region "Setting"
    Private Function SettingFilePlus(ByVal fileName As String, ByVal isRead As Boolean) As Boolean
        Dim result As Boolean = True

        Dim appName As String = String.Format("Other-{0:X4}", m_wUSBProductID)
        Dim keyName As String = "ColorInterpolationMethod"
        If (isRead) Then
            m_byteColorInterpolationMode = CByte(Native.GetPrivateProfileInt(appName, keyName, m_byteColorInterpolationMode, fileName))
        Else
            Dim value As String = m_byteColorInterpolationMode.ToString()
            Native.WritePrivateProfileString(appName, keyName, value, fileName)
        End If

        keyName = "MirrorMode"
        If (isRead) Then
            m_byteMirrorMode = CByte(Native.GetPrivateProfileInt(appName, keyName, m_byteMirrorMode, fileName))
        Else
            Dim value As String = m_byteMirrorMode.ToString()
            Native.WritePrivateProfileString(appName, keyName, value, fileName)
        End If

        keyName = "RotationMode"
        If (isRead) Then
            m_byteRotationMode = CByte(Native.GetPrivateProfileInt(appName, keyName, m_byteRotationMode, fileName))
        Else
            Dim value As String = m_byteRotationMode.ToString()
            Native.WritePrivateProfileString(appName, keyName, value, fileName)
        End If

        'appName = String.Format("Trigger-{0:X4}", m_wUSBProductID)
        'keyName = "AutoTriggerMode"
        'keyName = "AutoTriggerDelay"
        'keyName = "AutoTriggerResolution"
        Return (result)
    End Function
    Public Function WriteSettingFile(ByVal fileName As String) As Boolean
        Dim result As Boolean = False
        If (IsOpened()) Then
            StopTransfer()
            Do
                result = StTrg.WriteSettingFile(m_hCamera, fileName) <> 0
                If Not result Then
                    Exit Do
                End If

                result = SettingFilePlus(fileName, False)
                StartTransfer()
            Loop While (False)
        End If
        Return (result)
    End Function
    Public Function ReadSettingFile(ByVal fileName As String) As Boolean
        Dim result As Boolean = False
        If IsOpened() Then
            StopTransfer()
            Do
                result = StTrg.ReadSettingFile(m_hCamera, fileName) <> 0
                If Not result Then
                    Exit Do
                End If

                result = SettingFilePlus(fileName, True)

                ReadCurrentSetting()

                StartTransfer()
            Loop While (False)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End If
        Return (result)
    End Function
    Public Function CameraSetting(ByVal wMode As UShort) As Boolean
        Dim result As Boolean = False
        If IsOpened() Then
            StopTransfer()
            Do
                result = StTrg.CameraSetting(m_hCamera, wMode) <> 0
                If Not result Then
                    Exit Do
                End If

                ReadCurrentSetting()

                StartTransfer()
            Loop While (False)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End If
        Return (result)
    End Function
    Protected Function ReadCurrentSetting() As Boolean
        Dim result As Boolean = True
        Do

            'ScanMode
            result = GetScanMode()
            If Not result Then Exit Do

            'Skipping & Binning
            result = GetSkippingBinning()
            If Not result Then Exit Do

            result = (StTrg.GetTransferBitsPerPixel(m_hCamera, Me.m_dwTransferBitsPerPixel) <> 0)
            If Not result Then Exit Do

            result = ReadHDRSetting()
            If Not result Then Exit Do

        Loop While (False)
        Return (result)
    End Function
#End Region


#Region "ShadingCorrection"
    Public Property ShadingCorrectionMode() As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetShadingCorrectionMode(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetShadingCorrectionMode(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public Property ShadingCorrectionTarget() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                StTrg.GetShadingCorrectionTarget(m_hCamera, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetShadingCorrectionTarget(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region

#Region "Sharpness"
    Public Property SharpnessMode() As Byte
        Get
            Dim value As Byte = 0
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                value = byteSharpnessMode
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)

                byteSharpnessMode = value
                StTrg.SetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

    Public Property SharpnessGain() As System.UInt16
        Get
            Dim value As System.UInt16 = 0
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                value = wSharpnessGain
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)

                wSharpnessGain = value
                StTrg.SetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property

    Public Property SharpnessCoring() As Byte
        Get
            Dim value As Byte = 0
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                value = byteSharpnessCoring
            End If
            Return (value)
        End Get
        Set(ByVal value As Byte)
            If IsOpened() Then
                Dim byteSharpnessMode As Byte = 0
                Dim wSharpnessGain As System.UInt16 = 0
                Dim byteSharpnessCoring As Byte = 0
                StTrg.GetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)

                byteSharpnessCoring = value
                StTrg.SetSharpnessMode(m_hCamera, byteSharpnessMode, wSharpnessGain, byteSharpnessCoring)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region
#Region "IOPin"
    Public Property IOPinInOut(ByVal pinNo As Byte) As System.UInt32
        Get
            Dim direction As System.UInt32 = 0
            StTrg.GetIOPinDirection(m_hCamera, direction)
            Return (CUInt((direction >> pinNo) And 1))
        End Get
        Set(ByVal value As System.UInt32)
            Dim direction As System.UInt32 = 0
            StTrg.GetIOPinDirection(m_hCamera, direction)
            If (value <> 0) Then
                direction = CUInt(direction Or (1 << pinNo))
            Else
                direction = CUInt(direction And (Not (1 << pinNo)))
            End If
            StTrg.SetIOPinDirection(m_hCamera, direction)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property IOPinMode(ByVal pinNo As Byte) As System.UInt32
        Get
            Dim mode As System.UInt32
            StTrg.GetIOPinMode(m_hCamera, pinNo, mode)
            Return (mode)
        End Get
        Set(ByVal value As System.UInt32)
            StTrg.SetIOPinMode(m_hCamera, pinNo, value)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property IOPinPolarity(ByVal pinNo As Byte) As System.UInt32
        Get
            Dim polarity As System.UInt32 = 0
            StTrg.GetIOPinPolarity(m_hCamera, polarity)
            Return (CUInt((polarity >> pinNo) And 1))
        End Get
        Set(ByVal value As System.UInt32)
            Dim polarity As System.UInt32 = 0
            StTrg.GetIOPinPolarity(m_hCamera, polarity)

            If value <> 0 Then
                polarity = CUInt(polarity Or (1 << pinNo))
            Else
                polarity = CUInt(polarity And (Not (1 << pinNo)))
            End If
            StTrg.SetIOPinPolarity(m_hCamera, polarity)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property IOPinStatus(ByVal pinNo As Byte) As System.UInt32
        Get
            Dim status As System.UInt32 = 0
            StTrg.GetIOPinStatus(m_hCamera, status)
            Return (CUInt((status >> pinNo) And 1))
        End Get
        Set(ByVal value As System.UInt32)
            Dim status As System.UInt32 = 0
            StTrg.GetIOPinStatus(m_hCamera, status)
            If value <> 0 Then
                status = CUInt(status Or (1 << pinNo))
            Else
                status = CUInt(status And (Not (1 << pinNo)))
            End If
            StTrg.SetIOPinStatus(m_hCamera, status)
            RaiseEvent SettingUpdated(Me, New EventArgs())

        End Set
    End Property
    Public ReadOnly Property IOExistence(ByVal pinNo As Byte) As Boolean
        Get
            IOExistence = (((1 << pinNo) And m_dwIOExistence) <> 0)
        End Get
    End Property
    Public ReadOnly Property SwStatus(ByVal pinNo As Byte) As System.UInt32
        Get
            Dim status As System.UInt32 = 0
            StTrg.GetSwStatus(m_hCamera, status)
            Return (CUInt((status >> pinNo) And 1))
        End Get
    End Property
#End Region
#Region "TimeOut"
    Public Property TimeOut(ByVal timeOutType As System.UInt32) As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            If IsOpened() Then
                StTrg.GetTimeOut(m_hCamera, timeOutType, value)
            End If
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            If IsOpened() Then
                StTrg.SetTimeOut(m_hCamera, timeOutType, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region
#Region "Timing"
    Public Property TriggerTiming(ByVal type As System.UInt32) As System.UInt32
        Get
            Dim value As System.UInt32 = 0
            StTrg.GetTriggerTiming(m_hCamera, type, value)
            Return (value)
        End Get
        Set(ByVal value As System.UInt32)
            StTrg.SetTriggerTiming(m_hCamera, type, value)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public ReadOnly Property TriggerTimingText(ByVal type As System.UInt32) As String
        Get
            Dim text As String = ""

            Dim value As System.UInt32 = 0
            StTrg.GetTriggerTiming(m_hCamera, type, value)

            If IsIOUnitUs() Then
                text = value.ToString() & "us"
            Else
                Dim clockMode As System.UInt32 = 0
                Dim pixelClock As System.UInt32 = 0
                StTrg.GetClock(m_hCamera, clockMode, pixelClock)

                Dim time As Double = 0.0
                If (pixelClock <> 0) Then
                    If (StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY = type) Then
                        Dim totalVLine As System.UInt16 = 0
                        Dim totalHClock As System.UInt16 = 0
                        StTrg.GetFrameClock(m_hCamera, totalVLine, totalHClock)
                        time = value * totalHClock / CDbl(pixelClock)
                    Else
                        time = value / CDbl(pixelClock)
                    End If
                End If

                If 1.0 <= time Then
                    text = String.Format("{0:N1}s", time)
                Else
                    time *= 1000.0
                    If 1.0 <= time Then
                        text = String.Format("{0:N1}ms", time)
                    Else
                        time *= 1000.0
                        If 1.0 <= time Then
                            text = String.Format("{0:N1}us", time)
                        Else
                            time *= 1000.0
                            text = String.Format("{0:N1}ns", time)
                        End If
                    End If
                End If
            End If
            Return (text)
        End Get
    End Property
#End Region
#Region "Gamma"
    Public Property GammaValue(ByVal target As Byte) As System.UInt16
        Get
            Dim byteGammaMode As Byte = 0
            Dim wGammaValue As System.UInt16 = 0
            Dim shtBrightness As Short = 0
            Dim byteContrast As Byte = 0
            StTrg.GetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            Return (wGammaValue)
        End Get
        Set(ByVal value As System.UInt16)
            Dim byteGammaMode As Byte = 0
            Dim wGammaValue As System.UInt16 = 0
            Dim shtBrightness As Short = 0
            Dim byteContrast As Byte = 0
            StTrg.GetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            wGammaValue = value
            StTrg.SetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property GammaMode(ByVal target As Byte) As Byte
        Get
            Dim byteGammaMode As Byte = 0
            Dim wGammaValue As System.UInt16 = 0
            Dim shtBrightness As Short = 0
            Dim byteContrast As Byte = 0
            StTrg.GetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            Return (byteGammaMode)
        End Get
        Set(ByVal value As Byte)
            Dim byteGammaMode As Byte = 0
            Dim wGammaValue As System.UInt16 = 0
            Dim shtBrightness As Short = 0
            Dim byteContrast As Byte = 0
            StTrg.GetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            byteGammaMode = value
            StTrg.SetGammaModeEx(m_hCamera, target, byteGammaMode, wGammaValue, shtBrightness, byteContrast, IntPtr.Zero)
            RaiseEvent SettingUpdated(Me, New EventArgs())
        End Set
    End Property
    Public Property CameraGamma() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetCameraGammaValue(m_hCamera, value)
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetCameraGammaValue(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
#End Region
#Region "Clamp/AnalogBlackLevel"
    Public Property DigitalClamp() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetDigitalClamp(m_hCamera, value)
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetDigitalClamp(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property MaxDigitalClamp() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetMaxDigitalClamp(m_hCamera, value)
            Return (value)
        End Get
    End Property
    Public Property AnalogBlackLevel() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetAnalogBlackLevel(m_hCamera, value)
            Return (value)
        End Get
        Set(ByVal value As System.UInt16)
            If IsOpened() Then
                StTrg.SetAnalogBlackLevel(m_hCamera, value)
                RaiseEvent SettingUpdated(Me, New EventArgs())
            End If
        End Set
    End Property
    Public ReadOnly Property MaxAnalogBlackLevel() As System.UInt16
        Get
            Dim value As UInt16 = 0
            StTrg.GetMaxAnalogBlackLevel(m_hCamera, value)
            Return (value)
        End Get
    End Property
#End Region
End Class
Public Enum Fields
	'selection
	WBMode	'Byte
    HueSaturationMode   'Byte
    ExposureMode    'Dword
    TriggerSelector 'Dword
    TriggerMode 'Dword
    TriggerSource   'Dword
    TriggerOverlap  'Dword
    ExposureWaitHD  'Dword
    ExposureWaitReadOut 'Dword
    ExposureEnd 'Dword
    CameraMemory    'Dword
	NoiseReduction	'Dword
	ScanMode	'Word
	ClockMode	'Dword
	SharpnessMode	'Byte
	YGammaMode	'Byte
	RGammaMode	'Byte
	GRGammaMode	'Byte
	GBGammaMode	'Byte
	BGammaMode	'Byte
	ColorInterpolation	'Byte
	Mirror	'Byte
	Rotation	'Byte
	IOInOut0	'Dword
	IOInOut1	'Dword
	IOInOut2	'Dword
	IOInOut3	'Dword
	IOMode0	'Dword
	IOMode1	'Dword
	IOMode2	'Dword
	IOMode3	'Dword
	IOPolarity0	'Dword
	IOPolarity1	'Dword
	IOPolarity2	'Dword
	IOPolarity3	'Dword
	IOStatus0	'Dword
	IOStatus1	'Dword
	IOStatus2	'Dword
	IOStatus3	'Dword
	LEDGreen	'Dword
	LEDRed	'Dword
    TransferBitsPerPixel    'Dword
    PriorityMode    'Dword
    DisplayPixelFormat  'Dword
	HBinningSkipping	'Word
	VBinningSkipping	'Word
	VBlankForFPS	'Dword
    SensorShutterMode   'Dword
	ALCMode	'Byte
	HBinningSumMode	'Word
	VBinningSumMode	'Word
    CurrentRegion   'Integer
    RegionMode      'Boolean
    ShadingCorrectionMode   'Dword
    ResetSwitch      'Boolean
    AdjustmentDigitalGain   'Boolean
    HDR_CMOSIS4M_Mode   'Byte
    HDR_CMOSIS4M_SlopeNum   'Byte

	'numeric
	Exposure	'Dword
	Gain	'Word
	DigitalGain	'Word
	SharpnessGain	'Word
	SharpnessCoring	'Byte
	YGamma	'Word
	RGamma	'Word
	GRGamma	'Word
	GBGamma	'Word
	BGamma	'Word
	WBRGain	'Word
	WBGRGain	'Word
	WBGBGain	'Word
	WBBGain	'Word
	Hue	'Short
	Saturation	'Word
	AutoTriggerTime	'Integer
    TriggerDelay    'Dword
	StrobeStartDelay	'Dword
	StrobeEndDelay	'Dword
	OutputPulseDelay	'Dword
	OutputPulseDuration	'Dword
    ReadOutDelay    'Dword
    LineDebounceTime 'Dword
	ImageOffsetX	'Dword
	ImageOffsetY	'Dword
	ImageWidth		'Dword
	ImageHeight		'Dword
	ALCTarget	'Word
	AEMinExposure	'Dword
	AEMaxExposure	'Dword
	AGCMinGain		'Word
	AGCMaxGain		'Word
	CameraGamma		'Word
    DigitalClamp    'Word
    AnalogBlackLevel    'Word
    HighChromaSuppressionStartLevel     'Word
    HighChromaSuppressionSuppressionLevel   'Word
    LowChromaSuppressionStartLevel     'Word
    LowChromaSuppressionSuppressionLevel   'Word
    ShadingCorrectionTarget 'Word
    HDR_CMOSIS4M_Vlow2  'Byte
    HDR_CMOSIS4M_Vlow3  'Byte
    HDR_CMOSIS4M_Knee1  'Byte
    HDR_CMOSIS4M_Knee2  'Byte

    'button
    TriggerSoftware_FrameStart
    TriggerSoftware_ExposureStart
    TriggerSoftware_ExposureEnd
    TriggerSoftware_SensorReadOutStart
	ResetFrameNo

	'check
	IsAutoTrigger

	'text
	CameraType
	FPGAVersion
	FirmVersion
	SDKVersion
	SwStatus0
	SwStatus1
	SwStatus2
    SwStatus3
    Temperature


End Enum
