Public Class StComboBox
	Implements IField
	Implements IValue
	Implements ISelection
	Implements IChanged
	Dim m_Field As Fields
	Public Property Field() As Fields Implements IField.Field
		Get
			Return (m_Field)
		End Get
		Set(ByVal value As Fields)
			m_Field = value
		End Set
	End Property

	Public Function GetValue(Of t)() As t Implements IValue.GetValue
		Dim value As t
		If (0 < Items.Count) Then
			If 0 <= SelectedIndex Then
				value = CType(Items(SelectedIndex), CStComboBoxItem(Of t)).Value
			End If
		End If
		Return (value)
	End Function
	Public Sub SetValue(Of t)(ByVal value As t) Implements IValue.SetValue
		If (0 < Items.Count) Then
			For i As Integer = 0 To Items.Count - 1
				If (value.Equals(CType(Items(i), CStComboBoxItem(Of t)).Value)) Then
					SelectedIndex = i
					Exit For
				End If
			Next
		End If

	End Sub


	Public Sub InitList(Of t)(ByVal aStItem() As CStComboBoxItem(Of t), ByVal value As t, Optional ByVal forceDisabled As Boolean = False) Implements ISelection.InitList
        If IsNothing(aStItem) Then
            Enabled = False
        ElseIf (aStItem.GetLength(0) <= 0) Then
            Enabled = False
        Else
            Items.Clear()
            Items.AddRange(aStItem)
            SetValue(Of t)(value)
            Enabled = Not forceDisabled
        End If
    End Sub
	Public Event Changed(ByVal sender As Object, ByVal e As EventArgs) Implements IChanged.Changed

	Private Sub StComboBox_SelectionChangeCommitted(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.SelectionChangeCommitted
		RaiseEvent Changed(sender, e)
	End Sub
End Class