using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace StCtlLib
{
	public partial class DefectPixelSetting : UserControl
	{
		public DefectPixelSetting()
		{
			InitializeComponent();
			InitializePositionCtrl();
		}
		protected int m_Count = 64;
        protected int m_nPageSize = 16;
        protected int m_nPageNo;

		protected PixelPosition[] m_aPixelPosition = null;



		public int Count
		{
			get { return (m_Count); }
			set
			{
				m_Count = value;
				InitializePositionCtrl();
			}
		}
        public int PageNo
        {
            get { return (m_nPageNo); }
            set
            {
                m_nPageNo = value;
                for (int i = 0; i < m_aPixelPosition.Length; i++)
                {
                    m_aPixelPosition[i].Index = i + m_Count * m_nPageNo;
                }
            }
        }
		protected void InitializePositionCtrl()
		{
			DisposePositionCtrl();

			this.SuspendLayout();


            m_aPixelPosition = new PixelPosition[m_Count];
			for (int i = 0; i < m_aPixelPosition.Length; i++)
			{
				PixelPosition pp = new PixelPosition();
				pp.Parent = this;
				pp.Location = new System.Drawing.Point(4, i * pp.Height);
                pp.Index = i + m_Count * m_nPageNo;
				pp.TextEntered += new TextEnteredEventHandler(pp_TextEntered);
				pp.TrackBarScroll += new EventHandler(pp_TrackBarScroll);
				this.Controls.Add(pp);
				m_aPixelPosition[i] = pp;
			}
			this.ResumeLayout(false);
		}
		protected void DisposePositionCtrl()
		{
			if (m_aPixelPosition != null)
			{
				this.SuspendLayout();
				for (int i = 0; i < m_aPixelPosition.Length; i++)
				{
					if (m_aPixelPosition[i] != null)
					{
						m_aPixelPosition[i].Dispose();
						m_aPixelPosition[i] = null;
					}
				}
				m_aPixelPosition = null;
				this.ResumeLayout(false);
			}
		}
		public void GetTrackBarCtrl(ref TrackBar[] atrackBar)
		{
			atrackBar = null;
			if (m_aPixelPosition != null)
			{
				atrackBar = new TrackBar[m_aPixelPosition.Length * 2];
				for (int i = 0; i < m_aPixelPosition.Length; i++)
				{
					if (m_aPixelPosition[i] != null)
					{

						TrackBar[] aCurTrackBar = null;
						m_aPixelPosition[i].GetTrackBarCtrl(ref aCurTrackBar);
						atrackBar[i * 2] = aCurTrackBar[0];
						atrackBar[i * 2 + 1] = aCurTrackBar[1];
					}
					else
					{
						atrackBar[i * 2] = null;
						atrackBar[i * 2 + 1] = null;
					}
				}
			}

		}
		public void GetTextBoxCtrl(ref TextBox[] astTextBox)
		{
			astTextBox = null;
			if (m_aPixelPosition != null)
			{
				astTextBox = new TextBox[m_aPixelPosition.Length * 2];
				for (int i = 0; i < m_aPixelPosition.Length; i++)
				{
					if (m_aPixelPosition[i] != null)
					{

						TextBox[] aCurTextBox = null;
						m_aPixelPosition[i].GetTextBoxCtrl(ref aCurTextBox);
						astTextBox[i * 2] = aCurTextBox[0];
						astTextBox[i * 2 + 1] = aCurTextBox[1];
					}
					else
					{
						astTextBox[i * 2] = null;
						astTextBox[i * 2 + 1] = null;
					}
				}
			}

		}
		public event EventHandler TrackBarScroll = null;
		void pp_TrackBarScroll(object sender, EventArgs e)
		{
			if (TrackBarScroll != null)
			{
				TrackBarScroll(sender, e);
			}
		}
		public event TextEnteredEventHandler TextEntered = null;
		void pp_TextEntered(object sender, TextEnteredEventArgs e)
		{
			if (TextEntered != null)
			{
				TextEntered(sender, e);
			}
		}



	}
}
