using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace StCtlLib
{
	public partial class PixelPosition : UserControl
	{
		public PixelPosition()
		{
			InitializeComponent();
			UpdateLabel();
		}
		public void GetTrackBarCtrl(ref TrackBar[] atrackBar)
		{
			atrackBar = new TrackBar[] { trackBarX, trackBarY };
		}
		public void GetTextBoxCtrl(ref TextBox[] atextBox)
		{
			atextBox = new TextBox[] { txtX, txtY };
		}
		protected int m_Index = 0;
		public int Index
		{
			get { return (m_Index); }
			set
			{
				m_Index = value;
				UpdateLabel();
			}
		}
		public void UpdateLabel()
		{
			labelX.Text = "Defect pixel[" + m_Index.ToString() + "] X";
			labelY.Text = "Defect pixel[" + m_Index.ToString() + "] Y";
		}
		public event EventHandler TrackBarScroll = null;
		public event TextEnteredEventHandler TextEntered = null;

		private void txt_TextEntered(object sender, TextEnteredEventArgs e)
		{
			if (TextEntered != null)
			{
				TextEntered(sender, e);
			}
		}

		private void trackBar_Scroll(object sender, EventArgs e)
		{
			if (TrackBarScroll != null)
			{
				TrackBarScroll(sender, e);
			}
		}
	}
}
