using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace StCtlLib
{
	/// <summary>
	/// StComboBox
	/// </summary>
	public class StComboBox : ComboBox
	{
		/// <summary>
		/// </summary>
		private System.ComponentModel.Container components = null;

		public StComboBox()
		{
			InitializeComponent();

			DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;

		}

		/// <summary>
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region 
		/// <summary>
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion
		[Browsable(false)]
		public Int64 StValue
		{
			get
			{	
				Int64 Value = 0;
				if(null != Items)
				{
					if(0 <= SelectedIndex)
					{
						Value = ((StComboBoxItem)Items[SelectedIndex]).Value;
					}

				}
				return(Value);
			}
			set
			{
				//StComboBoxItem[] list = (StComboBoxItem[])Items;

				if(null != Items)
				{
					int sel = -1;
					for(int i = 0; i < Items.Count; i++)
					{
						if(value == ((StComboBoxItem)Items[i]).Value)
						{
							sel = i;
							break;
						}
					}
					SelectedIndex = sel;
				}

			}
		}
	}
	public class StComboBoxItem
	{
		private string ItemName;
		private Int64 ItemValue;
		public StComboBoxItem(string ItemName, Int64 Value)
		{
			this.ItemName = ItemName;
			this.ItemValue = Value;
		}
		public override string ToString()
		{
			return(ItemName);
		}
		public Int64 Value
		{
			get
			{
				return(ItemValue);
			}
		}

	}
}
