using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using SensorTechnology;
using System.Drawing.Imaging;
namespace StTrgDisplayCS
{
	/// <summary>
	/// DisplayForm
	/// </summary>
	public class DisplayForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.Panel panelClient;
		private System.Windows.Forms.StatusBarPanel statusBarPanelBlank;
		private System.Windows.Forms.StatusBarPanel statusBarPanelFPS;
		private System.Windows.Forms.StatusBarPanel statusBarPanelFrameNo;
		private System.Windows.Forms.StatusBarPanel statusBarPanelRcvCount;
		private System.Windows.Forms.StatusBarPanel statusBarPanelDrop;
		private System.ComponentModel.IContainer components;

		private StCamera m_Camera;
        private uint m_DispFrameNo;
		private StCtlLib.StPanel panelDisplay;
		private MenuStrip menuStrip;
		private ToolStripMenuItem fileToolStripMenuItem;
		private ToolStripMenuItem exitToolStripMenuItem;
		private ToolStripMenuItem modeToolStripMenuItem;
		private ToolStripMenuItem menuItemModeTrigger_FrameStart;
		private ToolStripMenuItem menuItemModeTrigger_ExposureEnd;
		private ToolStripMenuItem menuItemModeTrigger_SensorReadOutStart;
		private ToolStripSeparator toolStripMenuItem1;
		private ToolStripMenuItem settingToolStripMenuItem;
		private ToolStripMenuItem cameraIDToolStripMenuItem;
		private ToolStrip toolStrip;
		private ToolStripMenuItem viewToolStripMenuItem;
		private ToolStripMenuItem toolBarToolStripMenuItem;
		private ToolStripMenuItem statusBarToolStripMenuItem;
		private ToolStripMenuItem helpToolStripMenuItem;
		private ToolStripMenuItem aboutStTrgDisplayCSToolStripMenuItem;
		private ToolStripMenuItem saveBitmapToolStripMenuItem;
		private ToolStripButton toolStripButtonSaveImage;
		private ToolStripButton toolBarButtonTrigger_FrameStart;
		private ToolStripButton toolBarButtonTrigger_ExposureEnd;
		private ToolStripButton toolBarButtonTrigger_SensorReadOutStart;
        private Timer timerReOpen;
		private uint RcvCount;
        private ToolStripButton toolBarButtonTrigger_ExposureStart;
        private ToolStripMenuItem menuItemModeTrigger_ExposureStart;
        private IntPtr m_hDisplayWnd;
		public DisplayForm()
		{
			//
			// Required for Windows Form Designer support.
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			m_Camera = null;
			m_DispFrameNo = 0;
			RcvCount = 0;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows
		/// <summary>
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            this.statusBar = new System.Windows.Forms.StatusBar();
            this.statusBarPanelBlank = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelFPS = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelFrameNo = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelRcvCount = new System.Windows.Forms.StatusBarPanel();
            this.statusBarPanelDrop = new System.Windows.Forms.StatusBarPanel();
            this.panelClient = new System.Windows.Forms.Panel();
            this.panelDisplay = new StCtlLib.StPanel();
            this.menuStrip = new System.Windows.Forms.MenuStrip();
            this.fileToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.saveBitmapToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.modeToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.menuItemModeTrigger_FrameStart = new System.Windows.Forms.ToolStripMenuItem();
            this.menuItemModeTrigger_ExposureStart = new System.Windows.Forms.ToolStripMenuItem();
            this.menuItemModeTrigger_ExposureEnd = new System.Windows.Forms.ToolStripMenuItem();
            this.menuItemModeTrigger_SensorReadOutStart = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
            this.settingToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.cameraIDToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.viewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolBarToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.statusBarToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.helpToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.aboutStTrgDisplayCSToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
            this.toolStrip = new System.Windows.Forms.ToolStrip();
            this.toolStripButtonSaveImage = new System.Windows.Forms.ToolStripButton();
            this.toolBarButtonTrigger_FrameStart = new System.Windows.Forms.ToolStripButton();
            this.toolBarButtonTrigger_ExposureStart = new System.Windows.Forms.ToolStripButton();
            this.toolBarButtonTrigger_ExposureEnd = new System.Windows.Forms.ToolStripButton();
            this.toolBarButtonTrigger_SensorReadOutStart = new System.Windows.Forms.ToolStripButton();
            this.timerReOpen = new System.Windows.Forms.Timer(this.components);
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelBlank)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFPS)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFrameNo)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelRcvCount)).BeginInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDrop)).BeginInit();
            this.panelClient.SuspendLayout();
            this.menuStrip.SuspendLayout();
            this.toolStrip.SuspendLayout();
            this.SuspendLayout();
            // 
            // statusBar
            // 
            this.statusBar.Location = new System.Drawing.Point(0, 452);
            this.statusBar.Name = "statusBar";
            this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this.statusBarPanelBlank,
            this.statusBarPanelFPS,
            this.statusBarPanelFrameNo,
            this.statusBarPanelRcvCount,
            this.statusBarPanelDrop});
            this.statusBar.ShowPanels = true;
            this.statusBar.Size = new System.Drawing.Size(632, 24);
            this.statusBar.TabIndex = 0;
            this.statusBar.Text = "statusBar";
            // 
            // statusBarPanelBlank
            // 
            this.statusBarPanelBlank.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
            this.statusBarPanelBlank.BorderStyle = System.Windows.Forms.StatusBarPanelBorderStyle.None;
            this.statusBarPanelBlank.Name = "statusBarPanelBlank";
            this.statusBarPanelBlank.Width = 355;
            // 
            // statusBarPanelFPS
            // 
            this.statusBarPanelFPS.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.statusBarPanelFPS.Name = "statusBarPanelFPS";
            this.statusBarPanelFPS.Text = "xxx FPS";
            this.statusBarPanelFPS.Width = 57;
            // 
            // statusBarPanelFrameNo
            // 
            this.statusBarPanelFrameNo.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.statusBarPanelFrameNo.Name = "statusBarPanelFrameNo";
            this.statusBarPanelFrameNo.Text = "No.xxx";
            this.statusBarPanelFrameNo.Width = 48;
            // 
            // statusBarPanelRcvCount
            // 
            this.statusBarPanelRcvCount.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.statusBarPanelRcvCount.Name = "statusBarPanelRcvCount";
            this.statusBarPanelRcvCount.Text = "Receive xxx";
            this.statusBarPanelRcvCount.Width = 76;
            // 
            // statusBarPanelDrop
            // 
            this.statusBarPanelDrop.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
            this.statusBarPanelDrop.Name = "statusBarPanelDrop";
            this.statusBarPanelDrop.Text = "Dropped xxx";
            this.statusBarPanelDrop.Width = 79;
            // 
            // panelClient
            // 
            this.panelClient.AutoScroll = true;
            this.panelClient.BackColor = System.Drawing.SystemColors.Window;
            this.panelClient.Controls.Add(this.panelDisplay);
            this.panelClient.Dock = System.Windows.Forms.DockStyle.Fill;
            this.panelClient.Location = new System.Drawing.Point(0, 51);
            this.panelClient.Name = "panelClient";
            this.panelClient.Size = new System.Drawing.Size(632, 401);
            this.panelClient.TabIndex = 0;
            // 
            // panelDisplay
            // 
            this.panelDisplay.EraseBackGround = true;
            this.panelDisplay.Location = new System.Drawing.Point(0, 0);
            this.panelDisplay.Name = "panelDisplay";
            this.panelDisplay.Size = new System.Drawing.Size(200, 100);
            this.panelDisplay.TabIndex = 0;
            this.panelDisplay.Paint += new System.Windows.Forms.PaintEventHandler(this.panelDisplay_Paint);
            // 
            // menuStrip
            // 
            this.menuStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.fileToolStripMenuItem,
            this.modeToolStripMenuItem,
            this.viewToolStripMenuItem,
            this.helpToolStripMenuItem});
            this.menuStrip.Location = new System.Drawing.Point(0, 0);
            this.menuStrip.Name = "menuStrip";
            this.menuStrip.Size = new System.Drawing.Size(632, 26);
            this.menuStrip.TabIndex = 2;
            this.menuStrip.Text = "menuStrip1";
            // 
            // fileToolStripMenuItem
            // 
            this.fileToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.saveBitmapToolStripMenuItem,
            this.exitToolStripMenuItem});
            this.fileToolStripMenuItem.Name = "fileToolStripMenuItem";
            this.fileToolStripMenuItem.Size = new System.Drawing.Size(40, 22);
            this.fileToolStripMenuItem.Text = "&File";
            // 
            // saveBitmapToolStripMenuItem
            // 
            this.saveBitmapToolStripMenuItem.Enabled = false;
            this.saveBitmapToolStripMenuItem.Name = "saveBitmapToolStripMenuItem";
            this.saveBitmapToolStripMenuItem.Size = new System.Drawing.Size(163, 22);
            this.saveBitmapToolStripMenuItem.Text = "&Save Bitmap...";
            this.saveBitmapToolStripMenuItem.Click += new System.EventHandler(this.saveBitmapToolStripMenuItem_Click);
            // 
            // exitToolStripMenuItem
            // 
            this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
            this.exitToolStripMenuItem.Size = new System.Drawing.Size(163, 22);
            this.exitToolStripMenuItem.Text = "E&xit";
            this.exitToolStripMenuItem.Click += new System.EventHandler(this.exitToolStripMenuItem_Click);
            // 
            // modeToolStripMenuItem
            // 
            this.modeToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.menuItemModeTrigger_FrameStart,
            this.menuItemModeTrigger_ExposureStart,
            this.menuItemModeTrigger_ExposureEnd,
            this.menuItemModeTrigger_SensorReadOutStart,
            this.toolStripMenuItem1,
            this.settingToolStripMenuItem,
            this.cameraIDToolStripMenuItem});
            this.modeToolStripMenuItem.Name = "modeToolStripMenuItem";
            this.modeToolStripMenuItem.Size = new System.Drawing.Size(51, 22);
            this.modeToolStripMenuItem.Text = "&Mode";
            // 
            // menuItemModeTrigger_FrameStart
            // 
            this.menuItemModeTrigger_FrameStart.Enabled = false;
            this.menuItemModeTrigger_FrameStart.Name = "menuItemModeTrigger_FrameStart";
            this.menuItemModeTrigger_FrameStart.Size = new System.Drawing.Size(241, 22);
            this.menuItemModeTrigger_FrameStart.Tag = "0";
            this.menuItemModeTrigger_FrameStart.Text = "&FrameStart Trigger";
            this.menuItemModeTrigger_FrameStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // menuItemModeTrigger_ExposureStart
            // 
            this.menuItemModeTrigger_ExposureStart.Enabled = false;
            this.menuItemModeTrigger_ExposureStart.Name = "menuItemModeTrigger_ExposureStart";
            this.menuItemModeTrigger_ExposureStart.Size = new System.Drawing.Size(241, 22);
            this.menuItemModeTrigger_ExposureStart.Tag = "2";
            this.menuItemModeTrigger_ExposureStart.Text = "Exposure&Start Trigger";
            this.menuItemModeTrigger_ExposureStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // menuItemModeTrigger_ExposureEnd
            // 
            this.menuItemModeTrigger_ExposureEnd.Enabled = false;
            this.menuItemModeTrigger_ExposureEnd.Name = "menuItemModeTrigger_ExposureEnd";
            this.menuItemModeTrigger_ExposureEnd.Size = new System.Drawing.Size(241, 22);
            this.menuItemModeTrigger_ExposureEnd.Tag = "3";
            this.menuItemModeTrigger_ExposureEnd.Text = "&ExposureEnd Trigger";
            this.menuItemModeTrigger_ExposureEnd.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // menuItemModeTrigger_SensorReadOutStart
            // 
            this.menuItemModeTrigger_SensorReadOutStart.Enabled = false;
            this.menuItemModeTrigger_SensorReadOutStart.Name = "menuItemModeTrigger_SensorReadOutStart";
            this.menuItemModeTrigger_SensorReadOutStart.Size = new System.Drawing.Size(241, 22);
            this.menuItemModeTrigger_SensorReadOutStart.Tag = "4";
            this.menuItemModeTrigger_SensorReadOutStart.Text = "&SensorReadOutStart Trigger";
            this.menuItemModeTrigger_SensorReadOutStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // toolStripMenuItem1
            // 
            this.toolStripMenuItem1.Name = "toolStripMenuItem1";
            this.toolStripMenuItem1.Size = new System.Drawing.Size(238, 6);
            // 
            // settingToolStripMenuItem
            // 
            this.settingToolStripMenuItem.Name = "settingToolStripMenuItem";
            this.settingToolStripMenuItem.Size = new System.Drawing.Size(241, 22);
            this.settingToolStripMenuItem.Text = "Setting...";
            this.settingToolStripMenuItem.Click += new System.EventHandler(this.settingToolStripMenuItem_Click);
            // 
            // cameraIDToolStripMenuItem
            // 
            this.cameraIDToolStripMenuItem.Name = "cameraIDToolStripMenuItem";
            this.cameraIDToolStripMenuItem.Size = new System.Drawing.Size(241, 22);
            this.cameraIDToolStripMenuItem.Text = "Camera ID...";
            this.cameraIDToolStripMenuItem.Click += new System.EventHandler(this.cameraIDToolStripMenuItem_Click);
            // 
            // viewToolStripMenuItem
            // 
            this.viewToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolBarToolStripMenuItem,
            this.statusBarToolStripMenuItem});
            this.viewToolStripMenuItem.Name = "viewToolStripMenuItem";
            this.viewToolStripMenuItem.Size = new System.Drawing.Size(48, 22);
            this.viewToolStripMenuItem.Text = "&View";
            this.viewToolStripMenuItem.DropDownOpening += new System.EventHandler(this.viewToolStripMenuItem_DropDownOpening);
            // 
            // toolBarToolStripMenuItem
            // 
            this.toolBarToolStripMenuItem.Name = "toolBarToolStripMenuItem";
            this.toolBarToolStripMenuItem.Size = new System.Drawing.Size(138, 22);
            this.toolBarToolStripMenuItem.Text = "&Tool Bar";
            this.toolBarToolStripMenuItem.Click += new System.EventHandler(this.toolBarToolStripMenuItem_Click);
            // 
            // statusBarToolStripMenuItem
            // 
            this.statusBarToolStripMenuItem.Name = "statusBarToolStripMenuItem";
            this.statusBarToolStripMenuItem.Size = new System.Drawing.Size(138, 22);
            this.statusBarToolStripMenuItem.Text = "&Status Bar";
            this.statusBarToolStripMenuItem.Click += new System.EventHandler(this.statusBarToolStripMenuItem_Click);
            // 
            // helpToolStripMenuItem
            // 
            this.helpToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.aboutStTrgDisplayCSToolStripMenuItem});
            this.helpToolStripMenuItem.Name = "helpToolStripMenuItem";
            this.helpToolStripMenuItem.Size = new System.Drawing.Size(46, 22);
            this.helpToolStripMenuItem.Text = "&Help";
            // 
            // aboutStTrgDisplayCSToolStripMenuItem
            // 
            this.aboutStTrgDisplayCSToolStripMenuItem.Name = "aboutStTrgDisplayCSToolStripMenuItem";
            this.aboutStTrgDisplayCSToolStripMenuItem.Size = new System.Drawing.Size(204, 22);
            this.aboutStTrgDisplayCSToolStripMenuItem.Text = "&About StTrgDisplayCS";
            this.aboutStTrgDisplayCSToolStripMenuItem.Click += new System.EventHandler(this.aboutStTrgDisplayCSToolStripMenuItem_Click);
            // 
            // toolStrip
            // 
            this.toolStrip.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripButtonSaveImage,
            this.toolBarButtonTrigger_FrameStart,
            this.toolBarButtonTrigger_ExposureStart,
            this.toolBarButtonTrigger_ExposureEnd,
            this.toolBarButtonTrigger_SensorReadOutStart});
            this.toolStrip.Location = new System.Drawing.Point(0, 26);
            this.toolStrip.Name = "toolStrip";
            this.toolStrip.Size = new System.Drawing.Size(632, 25);
            this.toolStrip.TabIndex = 3;
            this.toolStrip.Text = "toolStrip1";
            // 
            // toolStripButtonSaveImage
            // 
            this.toolStripButtonSaveImage.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolStripButtonSaveImage.Enabled = false;
            this.toolStripButtonSaveImage.Image = global::StTrgDisplayVCS2005.Properties.Resources.SaveFile;
            this.toolStripButtonSaveImage.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolStripButtonSaveImage.Name = "toolStripButtonSaveImage";
            this.toolStripButtonSaveImage.Size = new System.Drawing.Size(23, 22);
            this.toolStripButtonSaveImage.Text = "toolStripButton1";
            this.toolStripButtonSaveImage.ToolTipText = "Save bitmap file";
            this.toolStripButtonSaveImage.Click += new System.EventHandler(this.saveBitmapToolStripMenuItem_Click);
            // 
            // toolBarButtonTrigger_FrameStart
            // 
            this.toolBarButtonTrigger_FrameStart.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolBarButtonTrigger_FrameStart.Enabled = false;
            this.toolBarButtonTrigger_FrameStart.Image = global::StTrgDisplayVCS2005.Properties.Resources.Trigger_FrameStart;
            this.toolBarButtonTrigger_FrameStart.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolBarButtonTrigger_FrameStart.Name = "toolBarButtonTrigger_FrameStart";
            this.toolBarButtonTrigger_FrameStart.Size = new System.Drawing.Size(23, 22);
            this.toolBarButtonTrigger_FrameStart.Tag = "0";
            this.toolBarButtonTrigger_FrameStart.Text = "toolStripButton2";
            this.toolBarButtonTrigger_FrameStart.ToolTipText = "FrameStart TriggerSoftware";
            this.toolBarButtonTrigger_FrameStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // toolBarButtonTrigger_ExposureStart
            // 
            this.toolBarButtonTrigger_ExposureStart.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolBarButtonTrigger_ExposureStart.Enabled = false;
            this.toolBarButtonTrigger_ExposureStart.Image = global::StTrgDisplayVCS2005.Properties.Resources.Trigger_ExposureStart;
            this.toolBarButtonTrigger_ExposureStart.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolBarButtonTrigger_ExposureStart.Name = "toolBarButtonTrigger_ExposureStart";
            this.toolBarButtonTrigger_ExposureStart.Size = new System.Drawing.Size(23, 22);
            this.toolBarButtonTrigger_ExposureStart.Tag = "2";
            this.toolBarButtonTrigger_ExposureStart.Text = "toolStripButton1";
            this.toolBarButtonTrigger_ExposureStart.ToolTipText = "ExposureStart TriggerSoftware";
            this.toolBarButtonTrigger_ExposureStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // toolBarButtonTrigger_ExposureEnd
            // 
            this.toolBarButtonTrigger_ExposureEnd.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolBarButtonTrigger_ExposureEnd.Enabled = false;
            this.toolBarButtonTrigger_ExposureEnd.Image = global::StTrgDisplayVCS2005.Properties.Resources.Trigger_ExposureEnd;
            this.toolBarButtonTrigger_ExposureEnd.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolBarButtonTrigger_ExposureEnd.Name = "toolBarButtonTrigger_ExposureEnd";
            this.toolBarButtonTrigger_ExposureEnd.Size = new System.Drawing.Size(23, 22);
            this.toolBarButtonTrigger_ExposureEnd.Tag = "3";
            this.toolBarButtonTrigger_ExposureEnd.Text = "toolStripButton3";
            this.toolBarButtonTrigger_ExposureEnd.ToolTipText = "ExposureEnd TriggerSoftware";
            this.toolBarButtonTrigger_ExposureEnd.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // toolBarButtonTrigger_SensorReadOutStart
            // 
            this.toolBarButtonTrigger_SensorReadOutStart.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
            this.toolBarButtonTrigger_SensorReadOutStart.Enabled = false;
            this.toolBarButtonTrigger_SensorReadOutStart.Image = global::StTrgDisplayVCS2005.Properties.Resources.Trigger_SensorReadOutStart;
            this.toolBarButtonTrigger_SensorReadOutStart.ImageTransparentColor = System.Drawing.Color.Magenta;
            this.toolBarButtonTrigger_SensorReadOutStart.Name = "toolBarButtonTrigger_SensorReadOutStart";
            this.toolBarButtonTrigger_SensorReadOutStart.Size = new System.Drawing.Size(23, 22);
            this.toolBarButtonTrigger_SensorReadOutStart.Tag = "4";
            this.toolBarButtonTrigger_SensorReadOutStart.Text = "toolStripButton4";
            this.toolBarButtonTrigger_SensorReadOutStart.ToolTipText = "SensorReadOutStart TriggerSoftware";
            this.toolBarButtonTrigger_SensorReadOutStart.Click += new System.EventHandler(this.menuItemModeTriggerSoftware_Click);
            // 
            // timerReOpen
            // 
            this.timerReOpen.Tick += new System.EventHandler(this.timerReOpen_Tick);
            // 
            // DisplayForm
            // 
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
            this.ClientSize = new System.Drawing.Size(632, 476);
            this.Controls.Add(this.panelClient);
            this.Controls.Add(this.statusBar);
            this.Controls.Add(this.toolStrip);
            this.Controls.Add(this.menuStrip);
            this.MainMenuStrip = this.menuStrip;
            this.Name = "DisplayForm";
            this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
            this.Text = "DisplayForm";
            this.Load += new System.EventHandler(this.DisplayForm_Load);
            this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.DisplayForm_FormClosing);
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelBlank)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFPS)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFrameNo)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelRcvCount)).EndInit();
            ((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDrop)).EndInit();
            this.panelClient.ResumeLayout(false);
            this.menuStrip.ResumeLayout(false);
            this.menuStrip.PerformLayout();
            this.toolStrip.ResumeLayout(false);
            this.toolStrip.PerformLayout();
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			//
			Application.EnableVisualStyles();

			//
			Application.DoEvents();

			Application.Run(new DisplayForm());
		}

		private void panelDisplay_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			if(null != m_Camera)
			{
				if(panelDisplay.EraseBackGround)
				{
					if(m_Camera.HasDisplayImage())
					{
						panelDisplay.EraseBackGround = false;
						saveBitmapToolStripMenuItem.Enabled = true;
						toolStripButtonSaveImage.Enabled = saveBitmapToolStripMenuItem.Enabled;
					}
				}
				m_Camera.Draw(panelDisplay.Handle, out m_DispFrameNo);
				statusBarPanelFPS.Text = String.Format("{0:N1}", m_Camera.GetFPS()) + " FPS";
				statusBarPanelFrameNo.Text = "No." + m_DispFrameNo;
				statusBarPanelRcvCount.Text = "Receive " + RcvCount;
				statusBarPanelDrop.Text = "Dropped " + m_Camera.GetDroppedFrameCount();
			}
		}

		private void DisplayForm_Load(object sender, System.EventArgs e)
		{
            m_hDisplayWnd = panelDisplay.Handle;
            OpenCamera();
		}

        private void OpenCamera()
        {

			m_Camera = StCamera.Open();
			if(null != m_Camera)
			{
				StCamera.DisplayImageCallback del = new StCamera.DisplayImageCallback(OnBGRImage);
				m_Camera.SetDisplayImageCallback(del);

                StCamera.RcvErrorCallback del2 = new StCamera.RcvErrorCallback(OnRcvError);
                m_Camera.SetRcvErrorCallback(del2);


				m_Camera.SettingUpdated += new MethodInvoker(this.OnSettingUpdate);
				this.OnSettingUpdate();

				//ushort scanMode = 0;
				//uint offsetX = 0;
				//uint offsetY = 0;
				uint width = m_Camera.ImageWidth;
				uint height = m_Camera.ImageHeight;
				//m_Camera.GetScanMode(out scanMode, out offsetX, out offsetY, out width, out height);
				panelDisplay.Width = (int)width;
				panelDisplay.Height = (int)height;

				Size clientSize = new Size((int)width, (int)height);
				if(statusBar.Visible)
				{
					clientSize.Height += statusBar.Height;
				}
				if (menuStrip.Visible)
				{
					clientSize.Height += menuStrip.Height;
				}
				if (toolStrip.Visible)
				{
					clientSize.Height += toolStrip.Height;
				}
				this.ClientSize = clientSize;


				Rectangle workingArea = Screen.GetWorkingArea(this);
				if(workingArea.Width < Width)
				{
					Width = workingArea.Width;
				}

				if(workingArea.Height < Height)
				{
					Height = workingArea.Height;
				}
			}
        }
        private void CloseCamera()
        {
            if (m_Camera != null)
            {
                m_Camera.Dispose();
                m_Camera = null;
            }
        }
        

		public void OnBGRImage(uint dwFrameNo, uint Width, uint Height, uint StPixelFormat, byte[] BGRImage)
		{
			RcvCount++;
            m_Camera.DelayedInvalidateRequest(m_hDisplayWnd);
            //panelDisplay.Invalidate();
		}

        public void OnRcvError(uint dwErrorCode)
        {
            if (Native.ERROR_ACCESS_DENIED == dwErrorCode)
            {
                this.Invoke((MethodInvoker)delegate {timerReOpen.Enabled = true;});
            }
        }


		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			ToolBarButton tbb = e.Button;
			MenuItem mi = (MenuItem)tbb.Tag;
			mi.PerformClick();
		}

		public void OnSettingUpdate()
		{
            menuItemModeTrigger_FrameStart.Enabled = false;
            menuItemModeTrigger_ExposureStart.Enabled = false;
			menuItemModeTrigger_ExposureEnd.Enabled = false;
			menuItemModeTrigger_SensorReadOutStart.Enabled = false;

			if(null != m_Camera)
			{
				saveBitmapToolStripMenuItem.Enabled = m_Camera.HasDisplayImage();
				toolStripButtonSaveImage.Enabled = saveBitmapToolStripMenuItem.Enabled;
				if(m_Camera.HasTriggerFunction())
                {
                    menuItemModeTrigger_FrameStart.Enabled = m_Camera.IsEnableTriggerSoftware(uint.Parse(menuItemModeTrigger_FrameStart.Tag.ToString()));
                    menuItemModeTrigger_ExposureStart.Enabled = m_Camera.IsEnableTriggerSoftware(uint.Parse(menuItemModeTrigger_ExposureStart.Tag.ToString()));
                    menuItemModeTrigger_ExposureEnd.Enabled = m_Camera.IsEnableTriggerSoftware(uint.Parse(menuItemModeTrigger_ExposureEnd.Tag.ToString()));
                    menuItemModeTrigger_SensorReadOutStart.Enabled = m_Camera.IsEnableTriggerSoftware(uint.Parse(menuItemModeTrigger_SensorReadOutStart.Tag.ToString()));
				}
            }
            toolBarButtonTrigger_FrameStart.Enabled = menuItemModeTrigger_FrameStart.Enabled;
            toolBarButtonTrigger_ExposureStart.Enabled = menuItemModeTrigger_ExposureStart.Enabled;
            toolBarButtonTrigger_ExposureEnd.Enabled = menuItemModeTrigger_ExposureEnd.Enabled;
            toolBarButtonTrigger_SensorReadOutStart.Enabled = menuItemModeTrigger_SensorReadOutStart.Enabled;

		}



		private void DisplayForm_FormClosing(object sender, FormClosingEventArgs e)
		{
            CloseCamera();

		}

		private void aboutStTrgDisplayCSToolStripMenuItem_Click(object sender, EventArgs e)
		{
			VersionForm dlg = new VersionForm();
			dlg.ShowDialog();

		}

		private void toolBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			toolStrip.Visible = !toolStrip.Visible;

		}

		private void statusBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			statusBar.Visible = !statusBar.Visible;

		}

		private void viewToolStripMenuItem_DropDownOpening(object sender, EventArgs e)
		{
			statusBarToolStripMenuItem.Checked = statusBar.Visible;
			toolBarToolStripMenuItem.Checked = toolStrip.Visible;

		}


		private void settingToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (null != m_Camera)
			{
				m_Camera.ShowSettingDlg();
			}
		}

		private void cameraIDToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (null != m_Camera)
			{
				m_Camera.ShowCameraIDDlg();
			}
		}
		private void saveBitmapToolStripMenuItem_Click(object sender, EventArgs e)
		{

			if (null != m_Camera)
			{
				using (SaveFileDialog dlg = new SaveFileDialog())
				{
					dlg.Filter = "Bitmap(*.bmp)|*.bmp|" +
						"Tiff(*.tif)|*.tif|" +
						"JPEG(*.jpg)|*.jpg|" +
						"All Files(*.*)|*.*";
					dlg.DefaultExt = "bmp";

					if (DialogResult.OK == dlg.ShowDialog())
					{
						m_Camera.SaveImage(dlg.FileName);
					}
				}
			}
		}
		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{
			Close();

		}

        private void timerReOpen_Tick(object sender, EventArgs e)
        {
            timerReOpen.Enabled = false;
            CloseCamera();
            OpenCamera();
            if (m_Camera == null)
            {
                Close();
            }
        }



        private void menuItemModeTriggerSoftware_Click(object sender, EventArgs e)
        {

            if (null != m_Camera)
            {
                uint dwTriggerSelector = 0;
                MenuItem mi = sender as MenuItem;
                if (mi != null)
                {
                    dwTriggerSelector = uint.Parse(mi.Tag.ToString());
                }
                else
                {
                    ToolStripItem tsi = sender as ToolStripItem;
                    if (tsi != null)
                    {
                        dwTriggerSelector = uint.Parse(tsi.Tag.ToString());
                    }
                }


                m_Camera.TriggerSoftware(dwTriggerSelector);
            }
        }




	}
}
