using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Drawing.Imaging;
using SensorTechnology;
namespace miniMMLSampleViewer
{
	/// <summary>
	/// DisplayForm
	/// </summary>
	public class DisplayForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.StatusBar statusBar;
		private System.Windows.Forms.Panel panelClient;
		private System.Windows.Forms.StatusBarPanel statusBarPanelBlank;
		private System.Windows.Forms.StatusBarPanel statusBarPanelFPS;
		private System.Windows.Forms.StatusBarPanel statusBarPanelFrameNo;
		private System.Windows.Forms.StatusBarPanel statusBarPanelRcvCount;
		private System.Windows.Forms.StatusBarPanel statusBarPanelDrop;
		private System.ComponentModel.IContainer components;

		private StCamera m_Camera;
		private uint m_DispFrameNo;
		private System.Windows.Forms.ImageList imageListToolBar;
		private StCtlLib.StPanel panelDisplay;
		private uint RcvCount;
		private ToolStrip toolStrip1;
		private ToolStripButton toolStripButtonSaveBitmap;
		private ToolStripButton toolStripButtonSoftTrigger;
		private MenuStrip menuStrip1;
		private ToolStripMenuItem fileToolStripMenuItem;
		private ToolStripMenuItem saveBitmapToolStripMenuItem;
		private ToolStripMenuItem exitToolStripMenuItem;
		private ToolStripMenuItem modeToolStripMenuItem;
		private ToolStripMenuItem viewToolStripMenuItem;
		private ToolStripMenuItem helpToolStripMenuItem;
		private ToolStripMenuItem aboutMtTrgDisplayToolStripMenuItem;
		private ToolStripMenuItem toolBarToolStripMenuItem;
		private ToolStripMenuItem statusBarToolStripMenuItem;
		private ToolStripMenuItem softTriggerToolStripMenuItem;
		private ToolStripSeparator toolStripMenuItem1;
		private ToolStripMenuItem settingToolStripMenuItem;
		private ToolStripMenuItem cameraIDToolStripMenuItem;
		public DisplayForm()
		{
			//
			// Required for Windows Form Designer support.
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
			m_Camera = null;
			m_DispFrameNo = 0;
			RcvCount = 0;
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows
		/// <summary>
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(DisplayForm));
			this.statusBar = new System.Windows.Forms.StatusBar();
			this.statusBarPanelBlank = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelFPS = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelFrameNo = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelRcvCount = new System.Windows.Forms.StatusBarPanel();
			this.statusBarPanelDrop = new System.Windows.Forms.StatusBarPanel();
			this.panelClient = new System.Windows.Forms.Panel();
			this.panelDisplay = new StCtlLib.StPanel();
			this.imageListToolBar = new System.Windows.Forms.ImageList(this.components);
			this.toolStrip1 = new System.Windows.Forms.ToolStrip();
			this.toolStripButtonSaveBitmap = new System.Windows.Forms.ToolStripButton();
			this.toolStripButtonSoftTrigger = new System.Windows.Forms.ToolStripButton();
			this.menuStrip1 = new System.Windows.Forms.MenuStrip();
			this.fileToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.saveBitmapToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.exitToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.modeToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.softTriggerToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.toolStripMenuItem1 = new System.Windows.Forms.ToolStripSeparator();
			this.settingToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.cameraIDToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.viewToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.toolBarToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.statusBarToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.helpToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			this.aboutMtTrgDisplayToolStripMenuItem = new System.Windows.Forms.ToolStripMenuItem();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelBlank)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFPS)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFrameNo)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelRcvCount)).BeginInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDrop)).BeginInit();
			this.panelClient.SuspendLayout();
			this.toolStrip1.SuspendLayout();
			this.menuStrip1.SuspendLayout();
			this.SuspendLayout();
			// 
			// statusBar
			// 
			this.statusBar.Location = new System.Drawing.Point(0, 368);
			this.statusBar.Name = "statusBar";
			this.statusBar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
            this.statusBarPanelBlank,
            this.statusBarPanelFPS,
            this.statusBarPanelFrameNo,
            this.statusBarPanelRcvCount,
            this.statusBarPanelDrop});
			this.statusBar.ShowPanels = true;
			this.statusBar.Size = new System.Drawing.Size(632, 24);
			this.statusBar.TabIndex = 0;
			this.statusBar.Text = "statusBar";
			// 
			// statusBarPanelBlank
			// 
			this.statusBarPanelBlank.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanelBlank.BorderStyle = System.Windows.Forms.StatusBarPanelBorderStyle.None;
			this.statusBarPanelBlank.Name = "statusBarPanelBlank";
			this.statusBarPanelBlank.Width = 355;
			// 
			// statusBarPanelFPS
			// 
			this.statusBarPanelFPS.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelFPS.Name = "statusBarPanelFPS";
			this.statusBarPanelFPS.Text = "xxx FPS";
			this.statusBarPanelFPS.Width = 57;
			// 
			// statusBarPanelFrameNo
			// 
			this.statusBarPanelFrameNo.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelFrameNo.Name = "statusBarPanelFrameNo";
			this.statusBarPanelFrameNo.Text = "No.xxx";
			this.statusBarPanelFrameNo.Width = 48;
			// 
			// statusBarPanelRcvCount
			// 
			this.statusBarPanelRcvCount.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelRcvCount.Name = "statusBarPanelRcvCount";
			this.statusBarPanelRcvCount.Text = "Receive xxx";
			this.statusBarPanelRcvCount.Width = 76;
			// 
			// statusBarPanelDrop
			// 
			this.statusBarPanelDrop.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Contents;
			this.statusBarPanelDrop.Name = "statusBarPanelDrop";
			this.statusBarPanelDrop.Text = "Dropped xxx";
			this.statusBarPanelDrop.Width = 79;
			// 
			// panelClient
			// 
			this.panelClient.AutoScroll = true;
			this.panelClient.BackColor = System.Drawing.SystemColors.Window;
			this.panelClient.Controls.Add(this.panelDisplay);
			this.panelClient.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panelClient.Location = new System.Drawing.Point(0, 49);
			this.panelClient.Name = "panelClient";
			this.panelClient.Size = new System.Drawing.Size(632, 319);
			this.panelClient.TabIndex = 0;
			// 
			// panelDisplay
			// 
			this.panelDisplay.EraseBackGround = true;
			this.panelDisplay.Location = new System.Drawing.Point(0, 0);
			this.panelDisplay.Name = "panelDisplay";
			this.panelDisplay.Size = new System.Drawing.Size(200, 100);
			this.panelDisplay.TabIndex = 0;
			this.panelDisplay.Paint += new System.Windows.Forms.PaintEventHandler(this.panelDisplay_Paint);
			// 
			// imageListToolBar
			// 
			this.imageListToolBar.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageListToolBar.ImageStream")));
			this.imageListToolBar.TransparentColor = System.Drawing.Color.Black;
			this.imageListToolBar.Images.SetKeyName(0, "SaveFile.bmp");
			this.imageListToolBar.Images.SetKeyName(1, "SoftTrigger.bmp");
			this.imageListToolBar.Images.SetKeyName(2, "SoftSubTrigger.bmp");
			this.imageListToolBar.Images.SetKeyName(3, "ReadOutTrigger.bmp");
			// 
			// toolStrip1
			// 
			this.toolStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolStripButtonSaveBitmap,
            this.toolStripButtonSoftTrigger});
			this.toolStrip1.Location = new System.Drawing.Point(0, 24);
			this.toolStrip1.Name = "toolStrip1";
			this.toolStrip1.Size = new System.Drawing.Size(632, 25);
			this.toolStrip1.TabIndex = 2;
			this.toolStrip1.Text = "toolStrip1";
			// 
			// toolStripButtonSaveBitmap
			// 
			this.toolStripButtonSaveBitmap.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
			this.toolStripButtonSaveBitmap.Image = global::miniMMLSampleViewer.res.miniMMLSampleViewer.SaveFile;
			this.toolStripButtonSaveBitmap.ImageTransparentColor = System.Drawing.Color.Magenta;
			this.toolStripButtonSaveBitmap.Name = "toolStripButtonSaveBitmap";
			this.toolStripButtonSaveBitmap.Size = new System.Drawing.Size(23, 22);
			this.toolStripButtonSaveBitmap.Text = "&Save Bitmap...";
			this.toolStripButtonSaveBitmap.Click += new System.EventHandler(this.toolStripButtonSaveBitmap_Click);
			// 
			// toolStripButtonSoftTrigger
			// 
			this.toolStripButtonSoftTrigger.DisplayStyle = System.Windows.Forms.ToolStripItemDisplayStyle.Image;
			this.toolStripButtonSoftTrigger.Image = global::miniMMLSampleViewer.res.miniMMLSampleViewer.SoftTrigger;
			this.toolStripButtonSoftTrigger.ImageTransparentColor = System.Drawing.Color.Magenta;
			this.toolStripButtonSoftTrigger.Name = "toolStripButtonSoftTrigger";
			this.toolStripButtonSoftTrigger.Size = new System.Drawing.Size(23, 22);
			this.toolStripButtonSoftTrigger.Text = "&Soft Trigger";
			this.toolStripButtonSoftTrigger.Click += new System.EventHandler(this.toolStripButtonSoftTrigger_Click);
			// 
			// menuStrip1
			// 
			this.menuStrip1.Items.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.fileToolStripMenuItem,
            this.modeToolStripMenuItem,
            this.viewToolStripMenuItem,
            this.helpToolStripMenuItem});
			this.menuStrip1.Location = new System.Drawing.Point(0, 0);
			this.menuStrip1.Name = "menuStrip1";
			this.menuStrip1.Size = new System.Drawing.Size(632, 24);
			this.menuStrip1.TabIndex = 3;
			this.menuStrip1.Text = "menuStrip1";
			// 
			// fileToolStripMenuItem
			// 
			this.fileToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.saveBitmapToolStripMenuItem,
            this.exitToolStripMenuItem});
			this.fileToolStripMenuItem.Name = "fileToolStripMenuItem";
			this.fileToolStripMenuItem.Size = new System.Drawing.Size(36, 20);
			this.fileToolStripMenuItem.Text = "&File";
			// 
			// saveBitmapToolStripMenuItem
			// 
			this.saveBitmapToolStripMenuItem.Enabled = false;
			this.saveBitmapToolStripMenuItem.Name = "saveBitmapToolStripMenuItem";
			this.saveBitmapToolStripMenuItem.Size = new System.Drawing.Size(141, 22);
			this.saveBitmapToolStripMenuItem.Text = "&Save Bitmap...";
			this.saveBitmapToolStripMenuItem.Click += new System.EventHandler(this.saveBitmapToolStripMenuItem_Click);
			// 
			// exitToolStripMenuItem
			// 
			this.exitToolStripMenuItem.Name = "exitToolStripMenuItem";
			this.exitToolStripMenuItem.Size = new System.Drawing.Size(141, 22);
			this.exitToolStripMenuItem.Text = "E&xit";
			this.exitToolStripMenuItem.Click += new System.EventHandler(this.exitToolStripMenuItem_Click);
			// 
			// modeToolStripMenuItem
			// 
			this.modeToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.softTriggerToolStripMenuItem,
            this.toolStripMenuItem1,
            this.settingToolStripMenuItem,
            this.cameraIDToolStripMenuItem});
			this.modeToolStripMenuItem.Name = "modeToolStripMenuItem";
			this.modeToolStripMenuItem.Size = new System.Drawing.Size(44, 20);
			this.modeToolStripMenuItem.Text = "&Mode";
			// 
			// softTriggerToolStripMenuItem
			// 
			this.softTriggerToolStripMenuItem.Name = "softTriggerToolStripMenuItem";
			this.softTriggerToolStripMenuItem.Size = new System.Drawing.Size(131, 22);
			this.softTriggerToolStripMenuItem.Text = "&Soft Trigger";
			this.softTriggerToolStripMenuItem.Click += new System.EventHandler(this.softTriggerToolStripMenuItem_Click);
			// 
			// toolStripMenuItem1
			// 
			this.toolStripMenuItem1.Name = "toolStripMenuItem1";
			this.toolStripMenuItem1.Size = new System.Drawing.Size(128, 6);
			// 
			// settingToolStripMenuItem
			// 
			this.settingToolStripMenuItem.Name = "settingToolStripMenuItem";
			this.settingToolStripMenuItem.Size = new System.Drawing.Size(131, 22);
			this.settingToolStripMenuItem.Text = "Setting...";
			this.settingToolStripMenuItem.Click += new System.EventHandler(this.settingToolStripMenuItem_Click);
			// 
			// cameraIDToolStripMenuItem
			// 
			this.cameraIDToolStripMenuItem.Name = "cameraIDToolStripMenuItem";
			this.cameraIDToolStripMenuItem.Size = new System.Drawing.Size(131, 22);
			this.cameraIDToolStripMenuItem.Text = "Camera ID...";
			this.cameraIDToolStripMenuItem.Click += new System.EventHandler(this.cameraIDToolStripMenuItem_Click);
			// 
			// viewToolStripMenuItem
			// 
			this.viewToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.toolBarToolStripMenuItem,
            this.statusBarToolStripMenuItem});
			this.viewToolStripMenuItem.Name = "viewToolStripMenuItem";
			this.viewToolStripMenuItem.Size = new System.Drawing.Size(42, 20);
			this.viewToolStripMenuItem.Text = "&View";
			this.viewToolStripMenuItem.DropDownOpening += new System.EventHandler(this.viewToolStripMenuItem_DropDownOpening);
			// 
			// toolBarToolStripMenuItem
			// 
			this.toolBarToolStripMenuItem.Name = "toolBarToolStripMenuItem";
			this.toolBarToolStripMenuItem.Size = new System.Drawing.Size(125, 22);
			this.toolBarToolStripMenuItem.Text = "&Tool Bar";
			this.toolBarToolStripMenuItem.Click += new System.EventHandler(this.toolBarToolStripMenuItem_Click);
			// 
			// statusBarToolStripMenuItem
			// 
			this.statusBarToolStripMenuItem.Name = "statusBarToolStripMenuItem";
			this.statusBarToolStripMenuItem.Size = new System.Drawing.Size(125, 22);
			this.statusBarToolStripMenuItem.Text = "&Status Bar";
			this.statusBarToolStripMenuItem.Click += new System.EventHandler(this.statusBarToolStripMenuItem_Click);
			// 
			// helpToolStripMenuItem
			// 
			this.helpToolStripMenuItem.DropDownItems.AddRange(new System.Windows.Forms.ToolStripItem[] {
            this.aboutMtTrgDisplayToolStripMenuItem});
			this.helpToolStripMenuItem.Name = "helpToolStripMenuItem";
			this.helpToolStripMenuItem.Size = new System.Drawing.Size(40, 20);
			this.helpToolStripMenuItem.Text = "&Help";
			// 
			// aboutMtTrgDisplayToolStripMenuItem
			// 
			this.aboutMtTrgDisplayToolStripMenuItem.Name = "aboutMtTrgDisplayToolStripMenuItem";
			this.aboutMtTrgDisplayToolStripMenuItem.Size = new System.Drawing.Size(172, 22);
			this.aboutMtTrgDisplayToolStripMenuItem.Text = "&About MtTrgDisplay";
			this.aboutMtTrgDisplayToolStripMenuItem.Click += new System.EventHandler(this.aboutMtTrgDisplayToolStripMenuItem_Click);
			// 
			// DisplayForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(632, 392);
			this.Controls.Add(this.panelClient);
			this.Controls.Add(this.statusBar);
			this.Controls.Add(this.toolStrip1);
			this.Controls.Add(this.menuStrip1);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "DisplayForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.Manual;
			this.Text = "miniMML Sample Viewer";
			this.Load += new System.EventHandler(this.DisplayForm_Load);
			this.FormClosing += new System.Windows.Forms.FormClosingEventHandler(this.DisplayForm_FormClosing);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelBlank)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFPS)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelFrameNo)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelRcvCount)).EndInit();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanelDrop)).EndInit();
			this.panelClient.ResumeLayout(false);
			this.toolStrip1.ResumeLayout(false);
			this.toolStrip1.PerformLayout();
			this.menuStrip1.ResumeLayout(false);
			this.menuStrip1.PerformLayout();
			this.ResumeLayout(false);
			this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{    
			//
			Application.EnableVisualStyles();

			//
			Application.DoEvents();

			Application.Run(new DisplayForm());
		}
		private void menuItem1_Click(object sender, System.EventArgs e)
		{
		
		}

		private void panelDisplay_Paint(object sender, System.Windows.Forms.PaintEventArgs e)
		{
			if(null != m_Camera)
			{
				if(panelDisplay.EraseBackGround)
				{
					if(m_Camera.HasDisplayImage())
					{
						panelDisplay.EraseBackGround = false;
						saveBitmapToolStripMenuItem.Enabled = true;
						toolStripButtonSaveBitmap.Enabled = saveBitmapToolStripMenuItem.Enabled;
					}
				}
				m_Camera.Draw(panelDisplay.Handle, out m_DispFrameNo);
				statusBarPanelFPS.Text = String.Format("{0:N1}", m_Camera.GetFPS()) + " FPS";
				statusBarPanelFrameNo.Text = "No." + m_DispFrameNo;
				statusBarPanelRcvCount.Text = "Receive " + RcvCount;
				statusBarPanelDrop.Text = "Dropped " + m_Camera.GetDroppedFrameCount();
			}
		}

		private void DisplayForm_Load(object sender, System.EventArgs e)
		{
			m_Camera = StCamera.Open();
			if(null != m_Camera)
			{
				StCamera.DisplayImageCallback del = new StCamera.DisplayImageCallback(OnBGRImage);
				m_Camera.SetDisplayImageCallback(del);
				
				m_Camera.OnSettingUpdate += new StCamera.SettingUpdateCallback(this.OnSettingUpdate);
				this.OnSettingUpdate();

				ushort scanMode = 0;
				uint offsetX = 0;
				uint offsetY = 0;
				uint width = 0;
				uint height = 0;
				m_Camera.GetScanMode(out scanMode, out offsetX, out offsetY, out width, out height);
				panelDisplay.Width = (int)width;
				panelDisplay.Height = (int)height;

				Size clientSize = new Size((int)width, (int)height);
				if(statusBar.Visible)
				{
					clientSize.Height += statusBar.Height;
				}
				if (menuStrip1.Visible)
				{
					clientSize.Height += menuStrip1.Height;
				}
				if (toolStrip1.Visible)
				{
					clientSize.Height += toolStrip1.Height;
				}
				this.ClientSize = clientSize;


				Rectangle workingArea = Screen.GetWorkingArea(this);
				if(workingArea.Width < Width)
				{
					Width = workingArea.Width;
				}

				if(workingArea.Height < Height)
				{
					Height = workingArea.Height;
				}
			}
		}



		public void OnBGRImage(uint dwFrameNo, uint Width, uint Height, uint StPixelFormat, byte[] BGRImage)
		{
			RcvCount++;
			panelDisplay.Invalidate();
		}

		private void menuItemFile_Popup(object sender, System.EventArgs e)
		{
		}



		

		private void toolBar_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			ToolBarButton tbb = e.Button;
			MenuItem mi = (MenuItem)tbb.Tag;
			mi.PerformClick();
		}

		public void OnSettingUpdate()
		{
			softTriggerToolStripMenuItem.Enabled = false;

			if(null != m_Camera)
			{
				saveBitmapToolStripMenuItem.Enabled = m_Camera.HasDisplayImage();
				if(m_Camera.HasTriggerFunction())
				{
					
					uint triggerType = m_Camera.TriggerType;
					if(StTrg.STCAM_TRIGGER_MODE_TYPE_FREE_RUN != triggerType)
					{
						if(StTrg.STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == m_Camera.TriggerSource)
						{
							softTriggerToolStripMenuItem.Enabled = true;
						}

					}
				}
			}
			toolStripButtonSoftTrigger.Enabled = softTriggerToolStripMenuItem.Enabled;

		}


		private void menuItemModeSoftSubTrigger_Click(object sender, System.EventArgs e)
		{
			if(null != m_Camera)
			{
				m_Camera.SoftSubTrigger();
			}
		}

		private void menuItemModeReadOut_Click(object sender, System.EventArgs e)
		{
			if(null != m_Camera)
			{
				m_Camera.TriggerReadOut();
			}
		}




		private void toolStripButtonSaveBitmap_Click(object sender, EventArgs e)
		{
			saveBitmapToolStripMenuItem.PerformClick();
		}

		private void toolStripButtonSoftTrigger_Click(object sender, EventArgs e)
		{
			softTriggerToolStripMenuItem.PerformClick();
		}

		private void aboutMtTrgDisplayToolStripMenuItem_Click(object sender, EventArgs e)
		{
			VersionForm dlg = new VersionForm();
			dlg.ShowDialog();

		}

		private void viewToolStripMenuItem_DropDownOpening(object sender, EventArgs e)
		{
			statusBarToolStripMenuItem.Checked = statusBar.Visible;
			toolBarToolStripMenuItem.Checked = toolStrip1.Visible;
		}

		private void toolBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			toolStrip1.Visible = !toolStrip1.Visible;
		}

		private void statusBarToolStripMenuItem_Click(object sender, EventArgs e)
		{
			statusBar.Visible = !statusBar.Visible;
		}

		private void saveBitmapToolStripMenuItem_Click(object sender, EventArgs e)
		{
			if (null != m_Camera)
			{
				SaveFileDialog dlg = new SaveFileDialog();
				dlg.Filter = "Windows Bitmap(*.bmp)|*.bmp|" +
					"All Files(*.*)|*.*";
				dlg.DefaultExt = "bmp";

				if (DialogResult.OK == dlg.ShowDialog())
				{
					m_Camera.SaveImage(dlg.FileName);
				}
			}

		}

		private void menuItemFile_Click(object sender, EventArgs e)
		{

		}

		private void exitToolStripMenuItem_Click(object sender, EventArgs e)
		{

			Close();
		}

		private void softTriggerToolStripMenuItem_Click(object sender, EventArgs e)
		{

			if (null != m_Camera)
			{
				m_Camera.SoftTrigger();
			}
		}

		private void settingToolStripMenuItem_Click(object sender, EventArgs e)
		{

			if (null != m_Camera)
			{
				m_Camera.ShowSettingDlg();
			}
		}

		private void cameraIDToolStripMenuItem_Click(object sender, EventArgs e)
		{

			if (null != m_Camera)
			{
				m_Camera.ShowCameraIDDlg();
			}
		}


		private void DisplayForm_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (null != m_Camera)
			{
				m_Camera.LED1_ON = 0;
				m_Camera.LED2_ON = 0;
				m_Camera.Close();
				m_Camera = null;
			}
		}

	}
}
