using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;

namespace miniMMLSampleViewer
{
	/// <summary>
	/// Summary description for SelectCameraForm.
	/// </summary>
	public class SelectCameraForm : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ComboBox cmbCamera;
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.Button btnOK;
		private System.Windows.Forms.Timer timerUpdateCameraList;


		#region Camera Information List
		const int MaxCameraCount = 127;
		private System.IntPtr[] ahCameras = new System.IntPtr[MaxCameraCount];
		private uint[] aCameraID = new uint[MaxCameraCount];
		private string[] astrCameraName = new string[MaxCameraCount];
		private int CameraCount = 0;
		#endregion
		private System.Windows.Forms.Button btnCancel;

		#region Select Camera Handle
		private System.IntPtr selectCameraHandle = IntPtr.Zero;
		#endregion

		public SelectCameraForm()
		{
			//
			// Required for Windows Form Designer support.
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.cmbCamera = new System.Windows.Forms.ComboBox();
			this.btnOK = new System.Windows.Forms.Button();
			this.timerUpdateCameraList = new System.Windows.Forms.Timer(this.components);
			this.btnCancel = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// cmbCamera
			// 
			this.cmbCamera.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			this.cmbCamera.Location = new System.Drawing.Point(8, 16);
			this.cmbCamera.Name = "cmbCamera";
			this.cmbCamera.Size = new System.Drawing.Size(248, 20);
			this.cmbCamera.TabIndex = 0;
			// 
			// btnOK
			// 
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(88, 48);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(80, 24);
			this.btnOK.TabIndex = 1;
			this.btnOK.Text = "OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// timerUpdateCameraList
			// 
			this.timerUpdateCameraList.Interval = 500;
			this.timerUpdateCameraList.Tick += new System.EventHandler(this.timerUpdateCameraList_Tick);
			// 
			// btnCancel
			// 
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(176, 48);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.Size = new System.Drawing.Size(72, 24);
			this.btnCancel.TabIndex = 2;
			this.btnCancel.Text = "Cancel";
			// 
			// SelectCameraForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 12);
			this.ClientSize = new System.Drawing.Size(266, 80);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.cmbCamera);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
			this.MaximizeBox = false;
			this.Name = "SelectCameraForm";
			this.Text = "Camera Select";
			this.Load += new System.EventHandler(this.SelectCamera_Load);
			this.Closing += new System.ComponentModel.CancelEventHandler(this.SelectCamera_Closing);
			this.ResumeLayout(false);

		}
		#endregion

		private void SelectCamera_Closing(object sender, System.ComponentModel.CancelEventArgs e)
		{
			StCamera.CloseCameraList(CameraCount, ahCameras, selectCameraHandle);
		}

		private void SelectCamera_Load(object sender, System.EventArgs e)
		{
			UpdateCameraList();	
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			SetOKValue();
		}

		private void timerUpdateCameraList_Tick(object sender, System.EventArgs e)
		{
			UpdateCameraList();
		}

		private void UpdateCameraList()
		{
			CameraCount = StCamera.OpenCameraList(MaxCameraCount, ahCameras, aCameraID, astrCameraName);

			for(int i = 0; i < CameraCount; i++)
			{
				cmbCamera.Items.Add(astrCameraName[i]);
			}
			if(0 < CameraCount)
			{
				cmbCamera.SelectedIndex = 0;
				cmbCamera.Enabled = btnOK.Enabled = true;
				timerUpdateCameraList.Enabled = false;

			}
			else
			{
				cmbCamera.Enabled = btnOK.Enabled = false;
				timerUpdateCameraList.Enabled = true;
			}

			if(1 == CameraCount)
			{
				SetOKValue();
				DialogResult = DialogResult.OK;
			}
		}
		private void SetOKValue()
		{
			System.IntPtr ptrReval = IntPtr.Zero;

			int index = cmbCamera.SelectedIndex;
			if(0 <= index)
			{
				selectCameraHandle = ahCameras[index];
			}
			System.Console.WriteLine("btnOK_Click");
		}
		public System.IntPtr SelectCameraHandle
		{
			get
			{
				return(selectCameraHandle);
			}
		}
	}
}
