using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using StCtlLib;
using SensorTechnology;
namespace miniMMLSampleViewer
{
	/// <summary>
	/// SettingForm
	/// </summary>
	public partial class SettingForm : System.Windows.Forms.Form
	{
		private StCamera m_objStCamera = null;
		public SettingForm(StCamera sc)
		{
			//
			// Windows
			//
			InitializeComponent();

			//
			// TODO: InitializeComponent
			//
			m_objStCamera = sc;
			SetEvents(this.Controls);
		}

		/// <summary>
		/// Rg[ɃCxg蓖Ă
		/// </summary>
		/// <param name="ctls"></param>
		protected void SetEvents(Control.ControlCollection ctls)
		{
			foreach (Control ctl in ctls)
			{
				//ݒXVɌĂяoCxg蓖Ă
				IStField_Updatable sfu = ctl as IStField_Updatable;
				if (sfu != null)
				{
					sfu.Updated += new StFieldUpdateDelegate(OnSettingUpdated);
				}

				//qRg[ɑ΂čċAIɏ
				if (ctl.HasChildren)
				{
					SetEvents(ctl.Controls);
				}
			}
		}


		#region sfu_Update:ݒ̍XV
		protected void  OnSettingUpdated(object sender, EventArgsStUpdate e)
		{
			switch (e.StField)
			{

				//Shutter Gain
				case (eStField.Exposure):
					m_objStCamera.ExposureClock = (uint)e.Value;
					break;
				case (eStField.AnalogGain):
					m_objStCamera.Gain = (ushort)e.Value;
					break;
				case (eStField.DigitalGain):
					m_objStCamera.DigitalGain = (ushort)e.Value;
					break;
				//WB
				case (eStField.WBMode):
					m_objStCamera.WhiteBalanceMode = (byte)e.Value;
					break;
				case (eStField.WBRGain):
					m_objStCamera.WBRGain = (ushort)e.Value;
					break;
				case (eStField.WBGrGain):
					m_objStCamera.WBGrGain = (ushort)e.Value;
					break;
				case (eStField.WBGbGain):
					m_objStCamera.WBGbGain = (ushort)e.Value;
					break;
				case (eStField.WBBGain):
					m_objStCamera.WBBGain = (ushort)e.Value;
					break;
				case (eStField.HueSaturationMode):
					m_objStCamera.HueSaturationMode = (byte)e.Value;
					break;
				case (eStField.Hue):
					m_objStCamera.Hue = (short)e.Value;
					break;
				case (eStField.Saturation):
					m_objStCamera.Saturation = (ushort)e.Value;
					break;
				//TriggerMode
				case (eStField.TriggerType):
					m_objStCamera.TriggerType = (uint)e.Value;
					break;
				case (eStField.TriggerSource):
					m_objStCamera.TriggerSource = (uint)e.Value;
					break;
				case (eStField.ExposureTimeType):
					m_objStCamera.ExposureTimeType = (uint)e.Value;
					break;
				case (eStField.RunTrigger):
					m_objStCamera.SoftTrigger();
					break;
				case (eStField.RunResetFrameNo):
					m_objStCamera.ResetCounter();
					break;
				//TriggerTiming
				case (eStField.ExposureDelay):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_EXPOSURE_DELAY] = (uint)e.Value;
					break;
				case (eStField.StrobeStartDelay):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY] = (uint)e.Value;
					break;
				case (eStField.StrobeEndDelay):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY] = (uint)e.Value;
					break;
				case (eStField.OutputPulseDelay):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY] = (uint)e.Value;
					break;
				case (eStField.OutputPulseDuration):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION] = (uint)e.Value;
					break;
				case (eStField.ReadOutDelay):
					m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY] = (uint)e.Value;
					break;
				//IO
				case (eStField.IOInOut0):
					m_objStCamera.IOPinInOut[0] = (uint)e.Value;
					break;
				case (eStField.IOInOut1):
					m_objStCamera.IOPinInOut[1] = (uint)e.Value;
					break;
				case (eStField.IOInOut2):
					m_objStCamera.IOPinInOut[2] = (uint)e.Value;
					break;
				case (eStField.IOInOut3):
					m_objStCamera.IOPinInOut[3] = (uint)e.Value;
					break;
				case (eStField.IOMode0):
					m_objStCamera.IOPinMode[0] = (uint)e.Value;
					break;
				case (eStField.IOMode1):
					m_objStCamera.IOPinMode[1] = (uint)e.Value;
					break;
				case (eStField.IOMode2):
					m_objStCamera.IOPinMode[2] = (uint)e.Value;
					break;
				case (eStField.IOMode3):
					m_objStCamera.IOPinMode[3] = (uint)e.Value;
					break;
				case (eStField.IOPolarity0):
					m_objStCamera.IOPinPolarity[0] = (uint)e.Value;
					break;
				case (eStField.IOPolarity1):
					m_objStCamera.IOPinPolarity[1] = (uint)e.Value;
					break;
				case (eStField.IOPolarity2):
					m_objStCamera.IOPinPolarity[2] = (uint)e.Value;
					break;
				case (eStField.IOPolarity3):
					m_objStCamera.IOPinPolarity[3] = (uint)e.Value;
					break;
				case (eStField.IOStatus0):
					m_objStCamera.IOPinStatus[0] = (uint)e.Value;
					break;
				case (eStField.IOStatus1):
					m_objStCamera.IOPinStatus[1] = (uint)e.Value;
					break;
				case (eStField.IOStatus2):
					m_objStCamera.IOPinStatus[2] = (uint)e.Value;
					break;
				case (eStField.IOStatus3):
					m_objStCamera.IOPinStatus[3] = (uint)e.Value;
					break;
				case (eStField.LED1_ONOFF):
					m_objStCamera.LED1_ON = (ushort)e.Value;
					break;
				case (eStField.LED2_ONOFF):
					m_objStCamera.LED2_ON = (ushort)e.Value;
					break;
				case (eStField.LED1_POWER):
					m_objStCamera.LED1_Power = (ushort)e.Value;
					break;
				case (eStField.LED2_POWER):
					m_objStCamera.LED2_Power = (ushort)e.Value;
					break;
				case (eStField.SWStatus0):
				case (eStField.SWStatus1):
				case (eStField.SWStatus2):
				case (eStField.SWStatus3):
				case (eStField.CameraType):
				case (eStField.FPGAVersion):
				case (eStField.FirmVersion):
				case (eStField.SDKVersion):
				//HDR
				case (eStField.HDRMode):
					m_objStCamera.HDRMode = (ushort)e.Value;
					break;
				case (eStField.T2Ratio):
				m_objStCamera.T2Ratio = (ushort)e.Value;
					break;
				case (eStField.T3Ratio):
				m_objStCamera.T3Ratio = (ushort)e.Value;
					break;
				case (eStField.V1Step):
				m_objStCamera.V1Step = (ushort)e.Value;
					break;
				case (eStField.V2Step):
				m_objStCamera.V2Step = (ushort)e.Value;
					break;
				case (eStField.V3Step):
					m_objStCamera.V3Step = (ushort)e.Value;
					break;
				case (eStField.ADCMode):
					m_objStCamera.ADCMode = (ushort)e.Value;
					break;
				//Other
				case (eStField.ScanMode):
					m_objStCamera.ScanMode = (ushort)e.Value;
					break;
				case (eStField.ColorInterpolation):
					m_objStCamera.ColorInterpolationMode = (byte)e.Value;
					break;
				case (eStField.SharpnessMode):
					m_objStCamera.SharpnessMode = (byte)e.Value;
					break;
				case (eStField.SharpnessGain):
					m_objStCamera.SharpnessGain = (ushort)e.Value;
					break;
				case (eStField.SharpnessCoring):
					m_objStCamera.SharpnessCoring = (byte)e.Value;
					break;
				case (eStField.Mirror):
					m_objStCamera.MirrorMode = (byte)e.Value;
					break;
				case (eStField.Rotation):
					m_objStCamera.RotationMode = (byte)e.Value;
					break;
				case (eStField.YGammaMode):
					m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_Y] = (byte)e.Value;
					break;
				case (eStField.YGamma):
					m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_Y] = (ushort)e.Value;
					break;
				case (eStField.TarnsferBitsPerPixel):
					m_objStCamera.TransferBitsPerPixel = (uint)e.Value;
					break;
				//ColorGamma
				case (eStField.RGammaMode):
					m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_R] = (byte)e.Value;
					break;
				case (eStField.RGamma):
					m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_R] = (ushort)e.Value;
					break;
				case (eStField.GrGammaMode):
					m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GR] = (byte)e.Value;
					break;
				case (eStField.GrGamma):
					m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_GR] = (ushort)e.Value;
					break;
				case (eStField.GbGammaMode):
					m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GB] = (byte)e.Value;
					break;
				case (eStField.GbGamma):
					m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_GB] = (ushort)e.Value;
					break;
				case (eStField.BGammaMode):
					m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_B] = (byte)e.Value;
					break;
				case (eStField.BGamma):
					m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_B] = (ushort)e.Value;
					break;
				//AOI
				case (eStField.AOIOffsetY):
					m_objStCamera.AOIOffsetY = (uint)e.Value;
					break;
				case (eStField.AOIHeight):
					m_objStCamera.AOIHeight = (uint)e.Value;
					break;


			}
			if (null != m_objStCamera.OnSettingUpdate)
			{
				m_objStCamera.OnSettingUpdate();
			}

			UpdateDisplay();
		}
		#endregion
		#region UpdateDisplay:\̍XV
		private void UpdateDisplay()
		{
			#region ComboBox, Button, TrackBar, NumeridUpDown, ReadOnlyTextBox
			UpdateDisplay(this.tabControl.SelectedTab.Controls);
			#endregion
		}
		protected void UpdateDisplay(Control.ControlCollection ctls)
		{
			foreach (Control ctl in ctls)
			{
				StComboBox stcb = ctl as StComboBox;
				if (stcb != null)
				{
					UpdateDisplay(stcb);
				}

				StButton stb = ctl as StButton;
				if (stb != null)
				{
					UpdateDisplay(stb);
				}

				IStRange sr = ctl as IStRange;
				if (sr != null)
				{
					IStField sf = ctl as IStField;
					UpdateDisplay(sf, sr);
				}

				StROTextBox srotb = ctl as StROTextBox;
				if (srotb != null)
				{
					UpdateDisplay(srotb);
				}
				if (ctl.HasChildren)
				{
					UpdateDisplay(ctl.Controls);
				}
			}
		}
		protected void UpdateDisplay(StROTextBox srotb)
		{
			string strValue = "";
			int CurValue = 0;
			switch (srotb.StField)
			{

				//Shutter Gain
				case (eStField.Exposure):
					strValue = m_objStCamera.ExposureClockText;
					break;
				case (eStField.AnalogGain):
					CurValue = (int)m_objStCamera.Gain;
					switch (m_objStCamera.CDSGainType())
					{
						case (1):
							strValue = String.Format("{0:N2} db", 2.00 + 0.07038 * (CurValue + 128));
							break;
						case(9):
							strValue = String.Format("x {0:N2}", (CurValue <= 16)?1.00:((64 <= CurValue)?4.00:(CurValue / 16.0)));
							break;
						default:
							strValue = String.Format("{0:N2} db", -2.36 + 0.132 * CurValue);
							break;
					}
					break;
				case (eStField.DigitalGain):

					if (m_objStCamera.HasDigitalGainFunction())
					{
						CurValue = (int)m_objStCamera.DigitalGain;
						strValue = String.Format("x {0:N2}", CurValue / 64.0);
					}
					break;
				//WB
				//case (eStField.WBMode):
				case (eStField.WBRGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						CurValue = (int)m_objStCamera.WBRGain;
						strValue = String.Format("x {0:N2}", CurValue / 128.0);
					}
					break;
				case (eStField.WBGrGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						CurValue = (int)m_objStCamera.WBGrGain;
						strValue = String.Format("x {0:N2}", CurValue / 128.0);
					}
					break;
				case (eStField.WBGbGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						CurValue = (int)m_objStCamera.WBGbGain;
						strValue = String.Format("x {0:N2}", CurValue / 128.0);
					}
					break;
				case (eStField.WBBGain):

					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						CurValue = (int)m_objStCamera.WBBGain;
						strValue = String.Format("x {0:N2}", CurValue / 128.0);
					}
					break;
				//case (eStField.HueSaturationMode):
				case (eStField.Hue):
					if (
						(StTrg.STCAM_COLOR_ARRAY_MONO != m_objStCamera.ColorArray) &&
						(StTrg.STCAM_HUE_SATURATION_OFF != m_objStCamera.HueSaturationMode)
						)
					{
						CurValue = (int)m_objStCamera.Hue;
						strValue = String.Format("{0:N1}", CurValue / 10.0);
					}
					break;
				case (eStField.Saturation):
					if (
						(StTrg.STCAM_COLOR_ARRAY_MONO != m_objStCamera.ColorArray) &&
						(StTrg.STCAM_HUE_SATURATION_OFF != m_objStCamera.HueSaturationMode)
						)
					{
						CurValue = (int)m_objStCamera.Saturation;
						strValue = String.Format("{0:N2}", CurValue / 100.0);
					}
					break;
				//TriggerMode
				//TriggerTiming
				case (eStField.ExposureDelay):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_EXPOSURE_DELAY];
					break;
				case (eStField.StrobeStartDelay):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY];
					break;
				case (eStField.StrobeEndDelay):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY];
					break;
				case (eStField.OutputPulseDelay):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY];
					break;
				case (eStField.OutputPulseDuration):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION];
					break;
				case (eStField.ReadOutDelay):
					strValue = m_objStCamera.TriggerTimingText[StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY];
					break;
				//IO
				case (eStField.SWStatus0):
				case (eStField.SWStatus1):
				case (eStField.SWStatus2):
				case (eStField.SWStatus3):
					byte swNo = (byte)((int)srotb.StField - (int)eStField.SWStatus0);
					if (m_objStCamera.SwStatus[swNo] == 1)
					{
						strValue = "ON";
					}
					else
					{
						strValue = "OFF";
					}
					break;
				case (eStField.CameraType):
					strValue = m_objStCamera.CameraType;
					break;
				case (eStField.FPGAVersion):
					strValue = string.Format("{0:X4}", m_objStCamera.FPGAVersion);
					break;
				case (eStField.FirmVersion):
					strValue = string.Format("{0:X4}", m_objStCamera.FirmwareVersion);
					break;
				case (eStField.SDKVersion):
					strValue = m_objStCamera.SDKVersion;
					break;

			}
			srotb.Text = strValue;
			
		}
		protected void UpdateDisplay(IStField sf, IStRange sr)
		{

			int MinValue = 0;
			int MaxValue = 0;
			int CurValue = 0;
			int SmallChange = 1;
			int LargeChange = 10;
			bool enabled = true;
			switch (sf.StField)
			{

				//Shutter Gain
				case (eStField.Exposure):
					MaxValue = (int)m_objStCamera.MaxExposureClock;
					LargeChange = MaxValue / 10;
					CurValue = (int)m_objStCamera.ExposureClock;
					break;
				case (eStField.AnalogGain):
					if (m_objStCamera.IsJBA)
					{
						MinValue = 16;
						MaxValue = 64;
						LargeChange = 4;
					}
					else
					{
						MaxValue = 255;
						LargeChange = 16;
					}
					CurValue = (int)m_objStCamera.Gain;
					break;
				case (eStField.DigitalGain):
					if(m_objStCamera.HasDigitalGainFunction())
					{
						MinValue = 64;
						MaxValue = 256;
						LargeChange = 16;
						CurValue = (int)m_objStCamera.DigitalGain;
					}
					else
					{
						enabled = false;
					}
					break;
				//WB
				case (eStField.WBRGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						MaxValue = 512;
						LargeChange = 16;
						CurValue = (int)m_objStCamera.WBRGain;
					}
					else
					{
						enabled = false;
					}
					break;
				case (eStField.WBGrGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						MaxValue = 512;
						LargeChange = 16;
						CurValue = (int)m_objStCamera.WBGrGain;
					}
					else
					{
						enabled = false;
					}
					break;
				case (eStField.WBGbGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						MaxValue = 512;
						LargeChange = 16;
						CurValue = (int)m_objStCamera.WBGbGain;
					}
					else
					{
						enabled = false;
					}
					break;
				case (eStField.WBBGain):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						MaxValue = 512;
						LargeChange = 16;
						CurValue = (int)m_objStCamera.WBBGain;
					}
					else
					{
						enabled = false;
					}
					break;
				case (eStField.Hue):
					if (
						(StTrg.STCAM_COLOR_ARRAY_MONO != m_objStCamera.ColorArray) &&
						(StTrg.STCAM_HUE_SATURATION_OFF != m_objStCamera.HueSaturationMode)
						)
					{
						MinValue = -1800;
						MaxValue = 1800;
						LargeChange = 10;
						CurValue = (int)m_objStCamera.Hue;
					}
					else
					{
						enabled = false;
					}
					break;
				case (eStField.Saturation):
					if (
						(StTrg.STCAM_COLOR_ARRAY_MONO != m_objStCamera.ColorArray) &&
						(StTrg.STCAM_HUE_SATURATION_OFF != m_objStCamera.HueSaturationMode)
						)
					{
						MaxValue = 200;
						LargeChange = 10;
						CurValue = (int)m_objStCamera.Saturation;
					}
					else
					{
						enabled = false;
					}
					break;
				//TriggerMode	
				//TriggerTiming
				case (eStField.ExposureDelay):
					MaxValue = 4094;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_EXPOSURE_DELAY];
					break;
				case (eStField.StrobeStartDelay):
					MaxValue = 4094;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_STROBE_START_DELAY];
					break;
				case (eStField.StrobeEndDelay):
					MaxValue = 4094;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_STROBE_END_DELAY];
					break;
				case (eStField.OutputPulseDelay):
					MaxValue = 4094;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DELAY];
					break;
				case (eStField.OutputPulseDuration):
					MaxValue = 4094;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_OUTPUT_PULSE_DURATION];
					break;
				case (eStField.ReadOutDelay):
					MaxValue = 65535;
					LargeChange = 256;
					CurValue = (int)m_objStCamera.TriggerTiming[StTrg.STCAM_TRIGGER_TIMING_READOUT_DELAY];
					break;
				//IO
				case (eStField.LED1_POWER):
					MinValue = 0;
					MaxValue = 127;
					LargeChange = 10;
					CurValue = m_objStCamera.LED1_Power;
					if (0 == m_objStCamera.LED1_ON)
					{
						enabled = false;
					}
					break;
				case (eStField.LED2_POWER):
					MinValue = 0;
					MaxValue = 127;
					LargeChange = 10;
					CurValue = m_objStCamera.LED2_Power;
					if (0 == m_objStCamera.LED2_ON)
					{
						enabled = false;
					}
					break;
				//HDR
				case (eStField.T2Ratio):
					MinValue = 0;
					MaxValue = 15;
					LargeChange = 3;
					CurValue = m_objStCamera.T2Ratio;
					if (0 == m_objStCamera.HDRMode)
					{
						enabled = false;
					}
					break;
				case (eStField.T3Ratio):
					MinValue = 0;
					MaxValue = 15;
					LargeChange = 3;
					CurValue = m_objStCamera.T3Ratio;
					if (0 == m_objStCamera.HDRMode)
					{
						enabled = false;
					}
					break;
				case (eStField.V1Step):
					MinValue = 0;
					MaxValue = 63;
					LargeChange = 5;
					CurValue = m_objStCamera.V1Step;
					if (0 == m_objStCamera.HDRMode)
					{
						enabled = false;
					}
					break;
				case (eStField.V2Step):
					MinValue = 0;
					MaxValue = 63;
					LargeChange = 5;
					CurValue = m_objStCamera.V2Step;
					if (0 == m_objStCamera.HDRMode)
					{
						enabled = false;
					}
					break;
				case (eStField.V3Step):
					MinValue = 0;
					MaxValue = 63;
					LargeChange = 5;
					CurValue = m_objStCamera.V3Step;
					if (0 == m_objStCamera.HDRMode)
					{
						enabled = false;
					}
					break;
				//Other
				case (eStField.SharpnessGain):
					MinValue = 0;
					MaxValue = 500;
					LargeChange = 50;
					CurValue = (int)m_objStCamera.SharpnessGain;
					if (StTrg.STCAM_SHARPNESS_OFF == m_objStCamera.SharpnessMode)
					{
						enabled = false;
					}
					break;
				case (eStField.SharpnessCoring):
					MinValue = 0;
					MaxValue = 255;
					LargeChange = 16;
					CurValue = (int)m_objStCamera.SharpnessCoring;
					if (StTrg.STCAM_SHARPNESS_OFF == m_objStCamera.SharpnessMode)
					{
						enabled = false;
					}
					break;
				case (eStField.YGamma):
					MinValue = 1;
					MaxValue = 500;
					LargeChange = 10;
					CurValue = (int)m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_Y];
					if (StTrg.STCAM_GAMMA_OFF == m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_Y])
					{
						enabled = false;
					}
					break;
				//ColorGamma
				case (eStField.RGamma):
					MinValue = 1;
					MaxValue = 500;
					LargeChange = 10;
					CurValue = (int)m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_R];
					if (StTrg.STCAM_GAMMA_OFF == m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_R])
					{
						enabled = false;
					}
					break;
				case (eStField.GrGamma):
					MinValue = 1;
					MaxValue = 500;
					LargeChange = 10;
					CurValue = (int)m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_GR];
					if (StTrg.STCAM_GAMMA_OFF == m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GR])
					{
						enabled = false;
					}
					break;
				case (eStField.GbGamma):
					MinValue = 1;
					MaxValue = 500;
					LargeChange = 10;
					CurValue = (int)m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_GB];
					if (StTrg.STCAM_GAMMA_OFF == m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GB])
					{
						enabled = false;
					}
					break;
				case (eStField.BGamma):
					MinValue = 1;
					MaxValue = 500;
					LargeChange = 10;
					CurValue = (int)m_objStCamera.GammaValue[StTrg.STCAM_GAMMA_TARGET_B];
					if (StTrg.STCAM_GAMMA_OFF == m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_B])
					{
						enabled = false;
					}
					break;
				//AOI
				case (eStField.AOIOffsetY):
					MinValue = 0;
					MaxValue = 476;
					SmallChange = 4;
					LargeChange = 20;
					CurValue = (int)m_objStCamera.AOIOffsetY;
					switch (m_objStCamera.ScanMode)
					{
						case (StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL):
						case (StTrg.STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL):
							break;
						default:
							enabled = false;
							break;
					}
					break;
				case (eStField.AOIHeight):
					MinValue = 0;
					MaxValue = 480;
					SmallChange = 4;
					LargeChange = 20;
					CurValue = (int)m_objStCamera.AOIHeight;
					switch (m_objStCamera.ScanMode)
					{
						case (StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL):
						case (StTrg.STCAM_SCAN_MODE_BINNING_VARIABLE_PARTIAL):
							break;
						default:
							enabled = false;
							break;
					}
					break;

			}
			if (CurValue < MinValue) MinValue = CurValue;
			if (MaxValue < CurValue) MaxValue = CurValue;
			sr.SetRange(MinValue, MaxValue, CurValue, SmallChange, LargeChange, enabled);
			
		}
		protected void UpdateDisplay(StButton stb)
		{
			bool enabled = false;
			switch (stb.StField)
			{
				case (eStField.RunTrigger):
					if (m_objStCamera.HasTriggerFunction())
					{
						if (
							(StTrg.STCAM_TRIGGER_MODE_TYPE_FREE_RUN != m_objStCamera.TriggerType) &&
							(StTrg.STCAM_TRIGGER_MODE_SOURCE_SOFTWARE == m_objStCamera.TriggerSource)
							)
						{
							enabled = true;
						}
					}
					break;
				case (eStField.RunResetFrameNo):
					enabled = true;
					break;
			}
			stb.Enabled = enabled;
		}
		protected void UpdateDisplay(StComboBox stcb)
		{
			stcb.Items.Clear();


			StComboBoxItem[] list = null;
			uint Value = 0;
			bool forceDisabled = false;
			switch (stcb.StField)
			{

				//Shutter Gain
				//WB
				case (eStField.WBMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_WB_OFF),
												   new StComboBoxItem("Manual", StTrg.STCAM_WB_MANUAL),
												   new StComboBoxItem("One Short", StTrg.STCAM_WB_ONESHOT),
												   new StComboBoxItem("Full Auto", StTrg.STCAM_WB_FULLAUTO)
											   };
					Value = m_objStCamera.WhiteBalanceMode;
					break;
				case (eStField.HueSaturationMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_HUE_SATURATION_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_HUE_SATURATION_ON)
											   };
					Value = m_objStCamera.HueSaturationMode;
					break;
				//TriggerMode
				case (eStField.TriggerType):
					if (m_objStCamera.HasTriggerFunction())
					{
						list = new StComboBoxItem[]{
													   new StComboBoxItem("Free Run", StTrg.STCAM_TRIGGER_MODE_TYPE_FREE_RUN),
													   new StComboBoxItem("Trigger", StTrg.STCAM_TRIGGER_MODE_TYPE_TRIGGER),
													   //new StComboBoxItem("Trigger Read Out", StTrg.STCAM_TRIGGER_MODE_TYPE_TRIGGER_RO)
												   };
						Value = m_objStCamera.TriggerType;
					}
					break;
				case (eStField.TriggerSource):
					if (m_objStCamera.HasTriggerFunction())
					{
						if (StTrg.STCAM_TRIGGER_MODE_TYPE_FREE_RUN != m_objStCamera.TriggerType)
						{
							list = new StComboBoxItem[]{
														   new StComboBoxItem("Disable", StTrg.STCAM_TRIGGER_MODE_SOURCE_NONE),
														   new StComboBoxItem("Software", StTrg.STCAM_TRIGGER_MODE_SOURCE_SOFTWARE),
														   //new StComboBoxItem("Hardware", StTrg.STCAM_TRIGGER_MODE_SOURCE_HARDWARE)
													   };
							Value = m_objStCamera.TriggerSource;
						}
						else
						{
							forceDisabled = true;
						}
					}
					break;
				case (eStField.ExposureTimeType):
					if (m_objStCamera.HasTriggerFunction())
					{
						if (StTrg.STCAM_TRIGGER_MODE_TYPE_FREE_RUN != m_objStCamera.TriggerType)
						{
							if (m_objStCamera.HasStartStopExposureFunction())
							{
								list = new StComboBoxItem[]{
															   new StComboBoxItem("Edge Preset", StTrg.STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET),
															   //new StComboBoxItem("Pulse Width", StTrg.STCAM_TRIGGER_MODE_EXPTIME_PULSE_WIDTH),
															   //new StComboBoxItem("Start/Stop", StTrg.STCAM_TRIGGER_MODE_EXPTIME_START_STOP)
														   };
							}
							else
							{

								list = new StComboBoxItem[]{
															   new StComboBoxItem("Edge Preset", StTrg.STCAM_TRIGGER_MODE_EXPTIME_EDGE_PRESET),
															   //new StComboBoxItem("Pulse Width", StTrg.STCAM_TRIGGER_MODE_EXPTIME_PULSE_WIDTH)
														   };
							}
							Value = m_objStCamera.ExposureTimeType;
						}
						else
						{
							forceDisabled = true;
						}
					}
					break;
				//TriggerTiming
				//IO
				case (eStField.IOInOut0):
				case (eStField.IOInOut1):
				case (eStField.IOInOut2):
				case (eStField.IOInOut3):
					{
						byte ioNo = (byte)((int)stcb.StField - (int)eStField.IOInOut0);
						list = new StComboBoxItem[]{
													   new StComboBoxItem("Input", 0),
													   new StComboBoxItem("Output", 1)
												   };
						Value = m_objStCamera.IOPinInOut[ioNo];
						forceDisabled = true;	// !m_objStCamera.HasChangeIOFunction();
					}
					break;
				case (eStField.IOMode0):
				case (eStField.IOMode1):
				case (eStField.IOMode2):
				case (eStField.IOMode3):
					
					{
						byte ioNo = (byte)((int)stcb.StField - (int)eStField.IOMode0);

						if (1 == m_objStCamera.IOPinInOut[ioNo])
						{
							//Output
							if (m_objStCamera.HasTriggerThroughFunction())
							{
								list = new StComboBoxItem[]{
															   new StComboBoxItem("Disable", StTrg.STCAM_OUT_PIN_MODE_DISABLE),
															   new StComboBoxItem("General Output", StTrg.STCAM_OUT_PIN_MODE_GENERAL_OUTPUT),
															   new StComboBoxItem("Trigger Output Programmable", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_PROGRAMMABLE),
															   new StComboBoxItem("Trigger Output Loop Through", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_LOOP_THROUGH),
															   new StComboBoxItem("Exposure End", StTrg.STCAM_OUT_PIN_MODE_EXPOSURE_END),
															   new StComboBoxItem("CCD Read End Output", StTrg.STCAM_OUT_PIN_MODE_CCD_READ_END_OUTPUT),
															   new StComboBoxItem("Strobe Output Programmable", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_PROGRAMMABLE),
															   new StComboBoxItem("Strobe Output Exposure", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_EXPOSURE)
														   };
							}
							else
							{
								list = new StComboBoxItem[]{
															   new StComboBoxItem("Disable", StTrg.STCAM_OUT_PIN_MODE_DISABLE),
															   new StComboBoxItem("General Output", StTrg.STCAM_OUT_PIN_MODE_GENERAL_OUTPUT),
															   new StComboBoxItem("Trigger Output Programmable", StTrg.STCAM_OUT_PIN_MODE_TRIGGER_OUTPUT_PROGRAMMABLE),
															   new StComboBoxItem("Exposure End", StTrg.STCAM_OUT_PIN_MODE_EXPOSURE_END),
															   new StComboBoxItem("CCD Read End Output", StTrg.STCAM_OUT_PIN_MODE_CCD_READ_END_OUTPUT),
															   new StComboBoxItem("Strobe Output Programmable", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_PROGRAMMABLE),
															   new StComboBoxItem("Strobe Output Exposure", StTrg.STCAM_OUT_PIN_MODE_STROBE_OUTPUT_EXPOSURE)
														   };
							}
						}
						else
						{
							//Input
							if (m_objStCamera.HasStartStopExposureFunction())
							{
								list = new StComboBoxItem[]{
															   new StComboBoxItem("Disable", StTrg.STCAM_IN_PIN_MODE_DISABLE),
															   new StComboBoxItem("General Input", StTrg.STCAM_IN_PIN_MODE_GENERAL_INPUT),
															   new StComboBoxItem("Trigger Input", StTrg.STCAM_IN_PIN_MODE_TRIGGER_INPUT),
															   new StComboBoxItem("Readout Input", StTrg.STCAM_IN_PIN_MODE_READOUT_INPUT),
															   new StComboBoxItem("Sub Trigger Input", StTrg.STCAM_IN_PIN_MODE_SUB_TRIGGER_INPUT)
														   };

							}
							else
							{
								list = new StComboBoxItem[]{
															   new StComboBoxItem("Disable", StTrg.STCAM_IN_PIN_MODE_DISABLE),
															   new StComboBoxItem("General Input", StTrg.STCAM_IN_PIN_MODE_GENERAL_INPUT),
															   new StComboBoxItem("Trigger Input", StTrg.STCAM_IN_PIN_MODE_TRIGGER_INPUT),
															   new StComboBoxItem("Readout Input", StTrg.STCAM_IN_PIN_MODE_READOUT_INPUT)
														   };
							}
						}
						Value = m_objStCamera.IOPinMode[ioNo];
						forceDisabled = true;
					}
					break;
				case (eStField.IOPolarity0):
				case (eStField.IOPolarity1):
				case (eStField.IOPolarity2):
				case (eStField.IOPolarity3):
					
					{
						byte ioNo = (byte)((int)stcb.StField - (int)eStField.IOPolarity0);
						list = new StComboBoxItem[]{
													   new StComboBoxItem("Positive", 0),
													   new StComboBoxItem("Negative", 1)
												   };
						Value = m_objStCamera.IOPinPolarity[ioNo];

						uint ioMode = m_objStCamera.IOPinMode[ioNo];
						if (
							(StTrg.STCAM_IN_PIN_MODE_DISABLE == ioMode) ||
							(StTrg.STCAM_IN_PIN_MODE_GENERAL_INPUT == ioMode)
							)
						{
							forceDisabled = true;
						}
						forceDisabled = true;
					}
					break;
				case (eStField.IOStatus0):
				case (eStField.IOStatus1):
				case (eStField.IOStatus2):
				case (eStField.IOStatus3):
					
					{
						byte ioNo = (byte)((int)stcb.StField - (int)eStField.IOStatus0);
						list = new StComboBoxItem[]{
													   new StComboBoxItem("Low", 0),
													   new StComboBoxItem("High", 1)
												   };
						Value = m_objStCamera.IOPinStatus[ioNo];
						if (
							(0 == m_objStCamera.IOPinInOut[ioNo]) ||
							(StTrg.STCAM_OUT_PIN_MODE_GENERAL_OUTPUT != m_objStCamera.IOPinMode[ioNo])
							)
						{
							forceDisabled = true;
						}
						forceDisabled = true;
					}
					break;
				case (eStField.LED1_ONOFF):
					list = new StComboBoxItem[] {
							new StComboBoxItem("OFF", 0),
							new StComboBoxItem("ON", 1)
					};

					Value = m_objStCamera.LED1_ON;
					break;
				case (eStField.LED2_ONOFF):
					list = new StComboBoxItem[] {
							new StComboBoxItem("OFF", 0),
							new StComboBoxItem("ON", 1)
					};

					Value = m_objStCamera.LED2_ON;
					break;
				//HDR
				case (eStField.HDRMode):
					list = new StComboBoxItem[] {
							new StComboBoxItem("OFF", 0),
							new StComboBoxItem("ON", 1)
					};

					Value = m_objStCamera.HDRMode;
					break;
				case (eStField.ADCMode):
					list = new StComboBoxItem[] {
							new StComboBoxItem("10-bit linear", 2),
							new StComboBoxItem("12 to 10 bit companding", 3)
					};

					Value = m_objStCamera.ADCMode;
					break;
#region Other
				case (eStField.ScanMode):
					list = new StComboBoxItem[]{
											   new StComboBoxItem("Normal", StTrg.STCAM_SCAN_MODE_NORMAL),
											   new StComboBoxItem("Partial_1", StTrg.STCAM_SCAN_MODE_PARTIAL_1),
											   new StComboBoxItem("Partial_2", StTrg.STCAM_SCAN_MODE_PARTIAL_2),
											   new StComboBoxItem("Partial_4", StTrg.STCAM_SCAN_MODE_PARTIAL_4),
											   new StComboBoxItem("Variable Partial", StTrg.STCAM_SCAN_MODE_VARIABLE_PARTIAL),
										   };
					Value = m_objStCamera.ScanMode;
					break;
				case (eStField.ColorInterpolation):
					if (m_objStCamera.ColorArray != StTrg.STCAM_COLOR_ARRAY_MONO)
					{
						list = new StComboBoxItem[]{
													   new StComboBoxItem("None(MONO)", StTrg.STCAM_COLOR_INTERPOLATION_NONE_MONO),
													   new StComboBoxItem("None(Color)", StTrg.STCAM_COLOR_INTERPOLATION_NONE_COLOR),
													   new StComboBoxItem("Nearest Neighbor", StTrg.STCAM_COLOR_INTERPOLATION_NEAREST_NEIGHBOR),
													   new StComboBoxItem("Bilinear", StTrg.STCAM_COLOR_INTERPOLATION_BILINEAR),
													   new StComboBoxItem("Bicubic", StTrg.STCAM_COLOR_INTERPOLATION_BICUBIC)
												   };

						Value = m_objStCamera.ColorInterpolationMode;
					}
					break;
				case (eStField.SharpnessMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_SHARPNESS_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_SHARPNESS_ON)
											   };
					Value = m_objStCamera.SharpnessMode;
					break;
				case (eStField.Mirror):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_MIRROR_OFF),
												   new StComboBoxItem("Horizontal", StTrg.STCAM_MIRROR_HORIZONTAL),
												   new StComboBoxItem("Vertical", StTrg.STCAM_MIRROR_VERTICAL),
												   new StComboBoxItem("Horizontal/Vertical", StTrg.STCAM_MIRROR_HORIZONTAL_VERTICAL)
											   };

					Value = m_objStCamera.MirrorMode;
					break;
				case (eStField.Rotation):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_ROTATION_OFF),
												   new StComboBoxItem("CLOCKWISE_90", StTrg.STCAM_ROTATION_CLOCKWISE_90),
												   new StComboBoxItem("COUNTERCLOCKWISE_90", StTrg.STCAM_ROTATION_COUNTERCLOCKWISE_90)
											   };

					Value = m_objStCamera.RotationMode;
					break;
				case (eStField.YGammaMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_GAMMA_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_GAMMA_ON),
												   new StComboBoxItem("REVERSE", StTrg.STCAM_GAMMA_REVERSE)
											   };
					Value = m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_Y];
					break;
				case (eStField.TarnsferBitsPerPixel):
					uint enableTransferBitsPerPixel = m_objStCamera.EnableTransferBitsPerPixel;
					if ((enableTransferBitsPerPixel & StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_12) != 0)
					{
						list = new StComboBoxItem[] {
								new StComboBoxItem("8bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_08),
								new StComboBoxItem("10bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_10),
								new StComboBoxItem("12bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_12)
						};
					}
					else if ((enableTransferBitsPerPixel & StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_10) != 0)
					{
						list = new StComboBoxItem[] {
								new StComboBoxItem("8bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_08),
								new StComboBoxItem("10bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_10)
						};
					}
					else
					{
						list = new StComboBoxItem[] {
								new StComboBoxItem("8bits", StTrg.STCAM_TRANSFER_BITS_PER_PIXEL_08)
						};
						forceDisabled = true;
					}


					Value = m_objStCamera.TransferBitsPerPixel;
					break;
#endregion Other
#region ColorGamma
				case (eStField.RGammaMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_GAMMA_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_GAMMA_ON),
												   new StComboBoxItem("REVERSE", StTrg.STCAM_GAMMA_REVERSE)
											   };
					Value = m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_R];
					break;
				case (eStField.GrGammaMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_GAMMA_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_GAMMA_ON),
												   new StComboBoxItem("REVERSE", StTrg.STCAM_GAMMA_REVERSE)
											   };
					Value = m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GR];
					break;
				case (eStField.GbGammaMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_GAMMA_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_GAMMA_ON),
												   new StComboBoxItem("REVERSE", StTrg.STCAM_GAMMA_REVERSE)
											   };
					Value = m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_GB];
					break;
				case (eStField.BGammaMode):
					list = new StComboBoxItem[]{
												   new StComboBoxItem("OFF", StTrg.STCAM_GAMMA_OFF),
												   new StComboBoxItem("ON", StTrg.STCAM_GAMMA_ON),
												   new StComboBoxItem("REVERSE", StTrg.STCAM_GAMMA_REVERSE)
											   };
					Value = m_objStCamera.GammaMode[StTrg.STCAM_GAMMA_TARGET_B];
					break;
#endregion ColorGamma
			}



			if (null != list)
			{
				stcb.AddListAndSelect(list, Value);
				stcb.Enabled = true && (!forceDisabled);
			}
			else
			{
				stcb.Enabled = false;
			}
		}
		#endregion



		private void tabControl_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			//System.Console.WriteLine("Tab = " + ((TabControl)sender).SelectedIndex);
			UpdateDisplay();
		}

		private void SettingForm_Load(object sender, System.EventArgs e)
		{
			if(!m_objStCamera.HasTriggerFunction())
			{
				if(tabControl.TabPages.Contains(tabPageTriggerMode))
				{
					tabControl.TabPages.Remove(tabPageTriggerMode);
				}
				if(tabControl.TabPages.Contains(tabPageTriggerTiming))
				{
					tabControl.TabPages.Remove(tabPageTriggerTiming);
				}
				if(tabControl.TabPages.Contains(tabPageIO))
				{
					tabControl.TabPages.Remove(tabPageIO);
				}
			}
			if(m_objStCamera.ColorArray == StTrg.STCAM_COLOR_ARRAY_MONO)
			{
                if (tabControl.TabPages.Contains(tabPageColorGamma))
				{
                    tabControl.TabPages.Remove(tabPageColorGamma);
				}

                if (tabControl.TabPages.Contains(tabPageWB))
                {
                    tabControl.TabPages.Remove(tabPageWB);
                }
            }
			if (!m_objStCamera.IsJBA)
			{
				if (tabControl.TabPages.Contains(tabPageHDR))
				{
					tabControl.TabPages.Remove(tabPageHDR);
				}
			}

			foreach (TabPage tb in tabControl.TabPages)
			{
				tb.BackColor = SystemColors.Control;

			}
			UpdateDisplay();		
		}


		private void btnOK_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void btnSave_Click(object sender, System.EventArgs e)
		{
			SaveFileDialog dlg = new SaveFileDialog();
			dlg.Filter = "CFG File(*.cfg)|*.cfg|" +
				"All Files(*.*)|*.*";
			dlg.DefaultExt = "cfg";
			dlg.FileName = m_objStCamera.CameraUserName;

			if(DialogResult.OK == dlg.ShowDialog())
			{
				m_objStCamera.WriteSettingFile(dlg.FileName);
			}
		}

		private void btnLoad_Click(object sender, System.EventArgs e)
		{
			OpenFileDialog dlg = new OpenFileDialog();
			dlg.Filter = "CFG File(*.cfg)|*.cfg|" +
				"All Files(*.*)|*.*";
			dlg.DefaultExt = "cfg";
			

			if(DialogResult.OK == dlg.ShowDialog())
			{
				m_objStCamera.ReadSettingFile(dlg.FileName);
				if(null != m_objStCamera.OnSettingUpdate)
				{
					m_objStCamera.OnSettingUpdate();
				}

			}
			
			UpdateDisplay();
		}

		private void btnRefresh_Click(object sender, System.EventArgs e)
		{
			UpdateDisplay();
		}

	}
}
