using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace StCtlLib
{
	/// <summary>
	/// StComboBox ̊Tv̐łB
	/// </summary>
	public class StComboBox : ComboBox, IStField, IStField_Updatable
	{
		/// <summary>
		/// KvȃfUCiϐłB
		/// </summary>
		private System.ComponentModel.Container components = null;

		public StComboBox()
		{
			// ̌ĂяóAWindows.Forms tH[ fUCiŕKvłB
			InitializeComponent();

			// TODO: InitializeComponent Ăяǒɏǉ܂B
			DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
			SelectionChangeCommitted += new EventHandler(StComboBox_SelectionChangeCommitted);
		}

		protected bool m_IsDisplayUpdatting = true;
		void StComboBox_SelectionChangeCommitted(object sender, EventArgs e)
		{
			if (!m_IsDisplayUpdatting)
			{
				if (Updated != null)
				{
					Updated(this, new EventArgsStUpdate(m_StField, StValue));
				}
			}
		}

		/// <summary>
		/// gpĂ郊\[XɌ㏈s܂B
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region R|[lg fUCiŐꂽR[h 
		/// <summary>
		/// fUCi T|[gɕKvȃ\bhłB̃\bh̓e
		/// R[h GfB^ŕύXȂłB
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
		}
		#endregion
		[Browsable(false)]
		public Int64 StValue
		{
			get
			{	
				Int64 Value = 0;
				if(null != Items)
				{
					if(0 <= SelectedIndex)
					{
						Value = ((StComboBoxItem)Items[SelectedIndex]).Value;
					}

				}
				return(Value);
			}
			//set
			//{
			//    //StComboBoxItem[] list = (StComboBoxItem[])Items;

			//    if(null != Items)
			//    {
			//        int sel = -1;
			//        for(int i = 0; i < Items.Count; i++)
			//        {
			//            if(value == ((StComboBoxItem)Items[i]).Value)
			//            {
			//                sel = i;
			//                break;
			//            }
			//        }
			//        SelectedIndex = sel;
			//    }

			//}
		}

		public void AddListAndSelect(StComboBoxItem[] arrayItem, Int64 value)
		{
			m_IsDisplayUpdatting = true;
			this.Items.AddRange(arrayItem);


			if (null != Items)
			{
				int sel = -1;
				for (int i = 0; i < Items.Count; i++)
				{
					if (value == ((StComboBoxItem)Items[i]).Value)
					{
						sel = i;
						break;
					}
				}
				SelectedIndex = sel;
			}
			m_IsDisplayUpdatting = false;
		}

		#region IStField o


		protected eStField m_StField = eStField.Exposure;
		public eStField  StField
		{
			get 
			{ 
				return(m_StField); 
			}
			set 
			{ 
				m_StField = value; 
			}
		}

		#endregion

		#region IStField_Updatable o

		public event StFieldUpdateDelegate Updated;

		#endregion
	}
	public class StComboBoxItem
	{
		private string ItemName;
		private Int64 ItemValue;
		public StComboBoxItem(string ItemName, Int64 Value)
		{
			this.ItemName = ItemName;
			this.ItemValue = Value;
		}
		public override string ToString()
		{
			return(ItemName);
		}
		public Int64 Value
		{
			get
			{
				return(ItemValue);
			}
		}

	}
	public enum eStField
	{
		//Shutter, Gain
		Exposure,
		AnalogGain,
		DigitalGain,
		//WB
		WBMode,
		WBRGain,
		WBGrGain,
		WBGbGain,
		WBBGain,
		HueSaturationMode,
		Hue,
		Saturation,
		//TriggerMode
		TriggerType,
		TriggerSource,
		ExposureTimeType,
		RunTrigger,
		RunResetFrameNo,
		//TriggerTiming
		ExposureDelay,
		StrobeStartDelay,
		StrobeEndDelay,
		OutputPulseDelay,
		OutputPulseDuration,
		ReadOutDelay,
		//IO
		IOInOut0,
		IOInOut1,
		IOInOut2,
		IOInOut3,
		IOMode0,
		IOMode1,
		IOMode2,
		IOMode3,
		IOPolarity0,
		IOPolarity1,
		IOPolarity2,
		IOPolarity3,
		IOStatus0,
		IOStatus1,
		IOStatus2,
		IOStatus3,
		LED1_ONOFF,
		LED2_ONOFF,
		LED1_POWER,
		LED2_POWER,
		SWStatus0,
		SWStatus1,
		SWStatus2,
		SWStatus3,
		CameraType,
		FPGAVersion,
		FirmVersion,
		SDKVersion,
		//HDR
		HDRMode,
		T2Ratio,
		T3Ratio,
		V1Step,
		V2Step,
		V3Step,
		ADCMode,
		//Other
		ScanMode,
		AOIOffsetY,
		AOIHeight,
		ColorInterpolation,
		SharpnessMode,
		SharpnessGain,
		SharpnessCoring,
		Mirror,
		Rotation,
		YGammaMode,
		YGamma,
		TarnsferBitsPerPixel,
		//ColorGamma
		RGammaMode,
		RGamma,
		GrGammaMode,
		GrGamma,
		GbGammaMode,
		GbGamma,
		BGammaMode,
		BGamma
	}


	public interface IStField
	{
		eStField StField
		{
			set;get;
		}
	}
	public class EventArgsStUpdate : EventArgs
	{
		public EventArgsStUpdate(eStField field, Int64 value)
		{
			m_StField = field;
			m_Value = value;
		}
		protected Int64 m_Value = 0;
		public Int64 Value
		{
			get{return(m_Value);}
		}
		protected eStField m_StField = eStField.Exposure;
		public eStField StField
		{
			get { return (m_StField); }
		}
	}
	public delegate void StFieldUpdateDelegate(object sender, EventArgsStUpdate e);
	public interface IStField_Updatable
	{
		event StFieldUpdateDelegate Updated;
	}
}
