using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace StCtlLib
{
	public partial class StNumericUpDown : NumericUpDown, IStField, IStField_Updatable, IStRange
	{
		public StNumericUpDown()
		{
			InitializeComponent();
		}
		protected bool m_IsDisplayUpdatting = true;
		#region IStField o

		protected eStField m_StField = eStField.Exposure;
		public eStField StField
		{
			get
			{
				return (m_StField);
			}
			set
			{
				m_StField = value;
			}
		}


		#endregion

		#region IStField_Updatable o

		public event StFieldUpdateDelegate Updated;

		#endregion

		#region IStRange o

		public void SetRange(long min, long max, long value, long small, long large, bool enabled)
		{
			m_IsDisplayUpdatting = true;

			Minimum = min;
			Maximum = max;
			Value = value;
			//SmallChange = small;
			//LargeChange = large;
			Enabled = enabled;

			m_IsDisplayUpdatting = false;
		}

		#endregion

		private void StNumericUpDown_ValueChanged(object sender, EventArgs e)
		{
			if (!m_IsDisplayUpdatting)
			{

				if (Updated != null)
				{
					Updated(sender, new EventArgsStUpdate(StField, (long)Value));
				}
			}
		}
	}
}
