using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Windows.Forms;

namespace StCtlLib
{
	public partial class StTrackBar : TrackBar, IStField, IStField_Updatable, IStRange
	{
		public StTrackBar()
		{
			InitializeComponent();
		}

		protected bool m_IsDisplayUpdatting = true;
		#region IStField o

		protected eStField m_StField = eStField.Exposure;
		public eStField  StField
		{
			get 
			{ 
				return(m_StField); 
			}
			set 
			{ 
				m_StField = value; 
			}
		}


		#endregion

		#region IStField_Updatable o

		public event StFieldUpdateDelegate Updated;

		#endregion

		private void StTrackBar_Scroll(object sender, EventArgs e)
		{
			if(!m_IsDisplayUpdatting)
			{
				if(Updated != null)
				{
					Updated(sender, new EventArgsStUpdate(StField, Value));
				}
			}
		}

		#region IStRange o

		public void SetRange(long min, long max, long value, long small, long large, bool enabled)
		{
			m_IsDisplayUpdatting = true;

			Minimum = (int)min;
			Maximum = (int)max;
			Value = (int)value;
			SmallChange = (int)small;
			LargeChange = (int)large;
			Enabled = enabled;

			m_IsDisplayUpdatting = false;
		}

		#endregion
	}
	public interface IStRange
	{
		void SetRange(Int64 min, Int64 max, Int64 value, Int64 small, Int64 large, bool enabled);
	}
}
