// CameraSelectDlg.cpp
//

#include "stdafx.h"
#include "sttrgdisplay.h"
#include "CameraSelectDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCameraSelectDlg

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CCameraSelectDlg::CCameraSelectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCameraSelectDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CCameraSelectDlg)
	//}}AFX_DATA_INIT

	m_hCamera = INVALID_HANDLE_VALUE;
	m_nTimer = 0;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CCameraSelectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCameraSelectDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CCameraSelectDlg, CDialog)
	//{{AFX_MSG_MAP(CCameraSelectDlg)
	//}}AFX_MSG_MAP
	ON_WM_TIMER()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCameraSelectDlg

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
#ifdef _WIN64
void CCameraSelectDlg::OnTimer(UINT_PTR nIDEvent) 
#else
void CCameraSelectDlg::OnTimer(UINT nIDEvent) 
#endif
{
	GetCameraInfoList();
	if(0 != m_aCamera.GetSize())
	{
		KillTimer(m_nTimer);
		m_nTimer = 0;
	}
	CDialog::OnTimer(nIDEvent);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	GetCameraInfoList();
	if(0 == m_aCamera.GetSize())
	{
		m_nTimer = SetTimer(1, 500, NULL);
	}
	
	return TRUE;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CCameraSelectDlg::OnOK() 
{
	CComboBox objComboBox;
	objComboBox.Attach(GetDlgItem(IDC_COMBO_CAMERA_LIST)->GetSafeHwnd());
	int nCurSel = objComboBox.GetCurSel();
	if(0 <= nCurSel)
	{
		m_hCamera = m_aCamera.GetAt(objComboBox.GetCurSel());
	}
	objComboBox.Detach();

	CDialog::OnOK();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::DestroyWindow() 
{
	if(0 != m_nTimer)
	{
		KillTimer(m_nTimer);
		m_nTimer = 0;
	}
	
	while(m_aCamera.GetSize())
	{
		HANDLE hCamera = m_aCamera.GetAt(0);
		if(m_hCamera != hCamera)
		{
			StTrg_Close(hCamera);
		}
		m_aCamera.RemoveAt(0);
	}

	return CDialog::DestroyWindow();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::GetCameraInfoList()
{
	BOOL	bReval = TRUE;
	CComboBox objComboBox;
	objComboBox.Attach(GetDlgItem(IDC_COMBO_CAMERA_LIST)->GetSafeHwnd());
	while(objComboBox.GetCount())
	{
		objComboBox.DeleteString(0);
	}

	HANDLE hCamera = INVALID_HANDLE_VALUE;
	do{
		hCamera = StTrg_Open();
		if(INVALID_HANDLE_VALUE != hCamera)
		{
			DWORD	dwCameraID;
			TCHAR	szCameraID[MAX_PATH];
			memset(szCameraID, 0, sizeof(TCHAR) * MAX_PATH);
			
			do{
				bReval = StTrg_ReadCameraUserID(hCamera, &dwCameraID, szCameraID, MAX_PATH);
				if(!bReval) break;
			}while(0);
			if(!bReval)
			{
				StTrg_Close(hCamera);
			}
			else
			{
				objComboBox.AddString(szCameraID);
				m_aCamera.Add(hCamera);
			}
		}
	}while(INVALID_HANDLE_VALUE != hCamera);
	
	if(0 < m_aCamera.GetSize())
	{
		objComboBox.SetCurSel(0);
		objComboBox.EnableWindow(TRUE);
		::EnableWindow(GetDlgItem(IDOK)->GetSafeHwnd(), TRUE);
	}
	objComboBox.Detach();

	if(1 == m_aCamera.GetSize())
	{
		m_hCamera = m_aCamera.GetAt(0);
		EndDialog(IDOK);
	}

	return(bReval);
}




