// StTrgDisplayDoc.cpp
//

#include "stdafx.h"
#include "StTrgDisplay.h"

#include "StTrgDisplayDoc.h"

#include "CameraSelectDlg.h"
#include "MainFrm.h"	//for Update Status Bar
#include "InputCameraIDDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

IMPLEMENT_DYNCREATE(CStTrgDisplayDoc, CDocument)

BEGIN_MESSAGE_MAP(CStTrgDisplayDoc, CDocument)
	//{{AFX_MSG_MAP(CStTrgDisplayDoc)
	ON_COMMAND(ID_FILE_SAVE_BMP, OnFileSaveBmp)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_BMP, OnUpdateFileSaveBmp)
	ON_COMMAND(ID_MODE_SETTING, OnModeSetting)
	ON_COMMAND(ID_MODE_CAMERA_ID, OnModeCameraId)
	ON_COMMAND_RANGE(ID_MODE_TRIGGER_FRAMESTART, ID_MODE_TRIGGER_SENSOR_READ_OUT_START, OnMenuTriggerSoftware)
	ON_UPDATE_COMMAND_UI_RANGE(ID_MODE_TRIGGER_FRAMESTART, ID_MODE_TRIGGER_SENSOR_READ_OUT_START, OnUpdateTriggerSoftware)
	//}}AFX_MSG_MAP
	ON_COMMAND(ID_FILE_SAVE_RAW, &CStTrgDisplayDoc::OnFileSaveRaw)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE_RAW, &CStTrgDisplayDoc::OnUpdateFileSaveRaw)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStTrgDisplayDoc::CStTrgDisplayDoc():
#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	m_hRawMutex(NULL), m_dwRawFrameNo(0), m_dwRawWidth(0), m_dwRawHeight(0), m_dwRawDataSize(0), m_dwRawTransferBitsPerPixel(0), m_pbyteRawData(NULL), 	//For Raw Data
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION
	m_hBGRMutex(NULL), m_dwBGRFrameNo(0), m_dwBGRWidth(0), m_dwBGRHeight(0), m_dwBGRPixelFormat(0), m_pbyteBGRData(NULL), 	//For BGR Data
	m_pImageView(NULL),
	m_bTransferFg(FALSE),
	m_hSettingDlg(NULL),
	m_pbyte8BitsRawData(NULL), m_dw8BitsRawImageSize(0), m_dwALCSkipCount(0)
{
#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	//For Raw Data
	m_hRawMutex = CreateMutex(NULL, FALSE, NULL);
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION

	//For BGR Data
	m_hBGRMutex = CreateMutex(NULL, FALSE, NULL);

	//For FPS
	m_pobjFPS = new CFPS(100);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStTrgDisplayDoc::~CStTrgDisplayDoc()
{
#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	//For Raw Data
	if(NULL != m_hRawMutex)
	{
		CloseHandle(m_hRawMutex);
		m_hRawMutex = NULL;
	}
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION

	//For BGR Data
	if(NULL != m_hBGRMutex)
	{
		CloseHandle(m_hBGRMutex);
		m_hBGRMutex = NULL;
	}
	//For FPS
	if(NULL != m_pobjFPS)
	{
		delete m_pobjFPS;
		m_pobjFPS = NULL;
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStTrgDisplayDoc::OpenCamera()
{

	CCameraSelectDlg dlg;
	dlg.DoModal();
	HANDLE hCamera = dlg.m_hCamera;

	if(INVALID_HANDLE_VALUE == hCamera)
	{
		AfxMessageBox(TEXT("Couldn't open a USB Camera."), MB_ICONEXCLAMATION);
		return FALSE;
	}

	m_hCamera = hCamera;
	BOOL bReval = TRUE;
	
	do{
		//Counter
		m_dwReceiveCount = 0;
		m_dwDropCount = 0;

		bReval = InitializeCameraInfo();
		if(!bReval) break;


		UpdateDocTitle();


		bReval = StartTransfer();
		if(!bReval) break;

		m_bTransferFg = TRUE;
	}while(0);

	if(!bReval)
	{
		StTrg_Close(m_hCamera);
		m_hCamera = NULL;
		AfxMessageBox(TEXT("Error occurred while initializing."), MB_ICONEXCLAMATION);
		return FALSE;
	}
	return(bReval);
}


//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStTrgDisplayDoc::CloseCamera()
{
	BOOL bReval = TRUE;

	if(NULL != m_hSettingDlg)
	{
		m_hSettingDlg->m_pImageView = NULL;
		m_hSettingDlg->DestroyWindow();
		m_hSettingDlg = NULL;
	}

	if(NULL != m_hCamera)
	{
		StTrg_Close(m_hCamera);
		m_hCamera = NULL;
	}
	

#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	//For Raw Data
	WaitForSingleObject(m_hRawMutex, INFINITE);
	if(NULL != m_pbyteRawData)
	{
		delete[] m_pbyteRawData;
	}
	m_dwRawFrameNo = 0;
	m_dwRawWidth = 0;
	m_dwRawHeight = 0;
	m_dwRawTransferBitsPerPixel = 0;
	m_dwRawDataSize = 0;
	m_pbyteRawData = NULL;
	ReleaseMutex(m_hRawMutex);
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION


	//For BGR Data
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		delete[] m_pbyteBGRData;
	}
	m_dwBGRFrameNo = 0;
	m_dwBGRWidth = 0;
	m_dwBGRHeight = 0;
	m_dwBGRPixelFormat = 0;
	m_pbyteBGRData = NULL;
	ReleaseMutex(m_hBGRMutex);
	
	if(NULL != m_pbyte8BitsRawData)
	{
		delete[] m_pbyte8BitsRawData;
		m_pbyte8BitsRawData = NULL;
	}
	m_dw8BitsRawImageSize = 0;
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStTrgDisplayDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	
	return OpenCamera();
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

void CStTrgDisplayDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
	}
	else
	{
	}
}

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

#ifdef _DEBUG
void CStTrgDisplayDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CStTrgDisplayDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CStTrgDisplayDoc

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::DeleteContents() 
{
	CloseCamera();

	CDocument::DeleteContents();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void	CStTrgDisplayDoc::GetImageSize(SIZE *psizeImage)
{
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	psizeImage->cx = m_dwBGRWidth;
	psizeImage->cy = m_dwBGRHeight;
	ReleaseMutex(m_hBGRMutex);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void	CStTrgDisplayDoc::Draw(HDC hDC, CRect *pRect)
{
	if(NULL != m_hCamera)
	{
		WaitForSingleObject(m_hBGRMutex, INFINITE);
		if(NULL != m_pbyteBGRData)
		{
			StTrg_Draw(m_hCamera, hDC, 
				pRect->left, pRect->top, pRect->Width(), pRect->Height(),
				pRect->left, pRect->top, pRect->Width(), pRect->Height(),
				m_dwBGRWidth, m_dwBGRHeight, m_pbyteBGRData, m_dwBGRPixelFormat);
		}
		ReleaseMutex(m_hBGRMutex);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::TransferEndCallback(HANDLE hCamera, DWORD dwFrameNo, DWORD dwWidth, DWORD dwHeight, WORD wColorArray, PBYTE pbyteRaw)
{

	DWORD	dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_08;
	StTrg_GetTransferBitsPerPixel(hCamera, &dwTransferBitsPerPixel);


	//For Multi ROI
	if(1 < GetMaxROICount())
	{
		DWORD dwMultiWidth = 0;
		DWORD dwMultiHeight = 0;
		DWORD dwMultiLinePitch = 0;

		PBYTE pbyteDecodedRaw = NULL;
		StTrg_DecodingCombinedMultiROI(hCamera, STCAM_DECODING_COMBINED_MULTI_ROI_EXCEPT_BLANK_ROW_AND_COL, pbyteRaw, (PVOID*)&pbyteDecodedRaw, &dwMultiWidth, &dwMultiHeight, &dwMultiLinePitch);
		pbyteRaw = pbyteDecodedRaw;
		dwWidth = dwMultiWidth;
		dwHeight = dwMultiHeight;
	}

#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	//For Raw Data
	WaitForSingleObject(m_hRawMutex, INFINITE);
	if(
		(dwWidth != m_dwRawWidth) ||
		(dwHeight != m_dwRawHeight) ||
		(dwTransferBitsPerPixel != m_dwRawTransferBitsPerPixel)
	)
	{
		if(NULL != m_pbyteRawData)
		{
			delete[] m_pbyteRawData;
			m_pbyteRawData = NULL;
		}

		DWORD dwBufferSize = dwWidth * dwHeight;
		switch(dwTransferBitsPerPixel)
		{
		case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16):
			dwBufferSize *= 2;
			break;
		case(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08):
		case(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10):
			dwBufferSize = 0;
			break;
		}
		if(dwBufferSize != 0)
		{
			m_pbyteRawData = new BYTE[dwBufferSize];
		}
		if(NULL == m_pbyteRawData)
		{
			m_dwRawWidth = 0;
			m_dwRawHeight = 0;
			m_dwRawTransferBitsPerPixel = 0;
			m_dwRawDataSize = 0;
		}
		else
		{
			m_dwRawWidth = dwWidth;
			m_dwRawHeight = dwHeight;
			m_dwRawTransferBitsPerPixel = dwTransferBitsPerPixel;
			m_dwRawDataSize = dwBufferSize;
		}
	}
	if(NULL != m_pbyteRawData)
	{
		memcpy_s(m_pbyteRawData, m_dwRawDataSize, pbyteRaw, m_dwRawDataSize);
	}
	ReleaseMutex(m_hRawMutex);
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION

	DWORD	dwPixelFormat = m_dwPixelFormat;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(
		(dwWidth != m_dwBGRWidth) ||
		(dwHeight != m_dwBGRHeight) ||
		(dwPixelFormat != m_dwBGRPixelFormat)
	)
	{
		if(NULL != m_pbyteBGRData)
		{
			delete[] m_pbyteBGRData;
		}

		DWORD dwBufferSize = dwWidth;
		switch(dwPixelFormat)
		{
		case(STCAM_PIXEL_FORMAT_24_BGR):
			dwBufferSize *= 3;
			break;
		case(STCAM_PIXEL_FORMAT_32_BGR):
			dwBufferSize *= 4;
			break;
		}
		if(dwBufferSize & 3)
		{
			dwBufferSize += 4 - (dwBufferSize & 3);
		}
		dwBufferSize *= dwHeight;
		m_pbyteBGRData = new BYTE[dwBufferSize];
		if(NULL == m_pbyteBGRData)
		{
			m_dwBGRWidth = 0;
			m_dwBGRHeight = 0;
			m_dwBGRPixelFormat = 0;
		}
		else
		{
			m_dwBGRWidth = dwWidth;
			m_dwBGRHeight = dwHeight;
			m_dwBGRPixelFormat = dwPixelFormat;
		}
	}


	if(
		(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_08 == dwTransferBitsPerPixel) ||
		(STCAM_TRANSFER_BITS_PER_PIXEL_BGR_10 == dwTransferBitsPerPixel)
	)
	{
		//BGR8,10->dwPixelFormat
		StTrg_ConvYUVOrBGRToBGRImage(dwWidth, dwHeight, dwTransferBitsPerPixel, pbyteRaw, dwPixelFormat, m_pbyteBGRData);
	}
	else
	{
		//Raw or MONO		
		if(
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10P == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12P == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14 == dwTransferBitsPerPixel) ||
			(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16 == dwTransferBitsPerPixel)
		)
		{
			//16bits->8bits
			DWORD dw8BitsRawImageSize = dwWidth * dwHeight * 2;
			if(m_dw8BitsRawImageSize != dw8BitsRawImageSize)
			{
				if(NULL != m_pbyte8BitsRawData)
				{
					delete[] m_pbyte8BitsRawData;
					m_pbyte8BitsRawData = NULL;
					m_dw8BitsRawImageSize = 0;
				}
				m_pbyte8BitsRawData = new BYTE[dw8BitsRawImageSize];
				if(NULL != m_pbyte8BitsRawData)
				{
					m_dw8BitsRawImageSize = dw8BitsRawImageSize;
				}
			}
			if(NULL != m_pbyte8BitsRawData)
			{
				StTrg_ConvTo8BitsImage(dwWidth, dwHeight, dwTransferBitsPerPixel, (PWORD)pbyteRaw, m_pbyte8BitsRawData);
				pbyteRaw = m_pbyte8BitsRawData;

				if(
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10P == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12P == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14 == dwTransferBitsPerPixel) ||
					(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16 == dwTransferBitsPerPixel)
				)
				{
					dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08;
				}
				else
				{
					dwTransferBitsPerPixel = STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08;
				}
			}
		}
		if(dwTransferBitsPerPixel == STCAM_TRANSFER_BITS_PER_PIXEL_MONO_08)
		{
			wColorArray = STCAM_COLOR_ARRAY_MONO;
		}

		//PC Side ALC
		if((!HasAE()) && (!HasAGC()))
		{
			if(0 < m_dwALCSkipCount)
			{
				m_dwALCSkipCount--;
			}
			else
			{
				BYTE byteALCMode = STCAM_ALCMODE_OFF;
				StTrg_GetALCMode(hCamera, &byteALCMode);

				if(byteALCMode != STCAM_ALCMODE_OFF)
				{
					float	pfAverage[4];
					StTrg_GetAveragePixelValue(dwWidth, dwHeight, wColorArray, STCAM_TRANSFER_BITS_PER_PIXEL_RAW_08, pbyteRaw, 0, 0, dwWidth, dwHeight, pfAverage);

					WORD	wAverage = 0;
					if(STCAM_COLOR_ARRAY_MONO == wColorArray)
					{
						wAverage = (WORD)pfAverage[0];	//B/W
					}
					else
					{
						wAverage = (WORD)((pfAverage[1] + pfAverage[2]) / 2);	//(Gr + Gb) / 2
					}
					DWORD	dwALCStatus = 0;
					StTrg_ALC(hCamera, wAverage, &dwALCStatus);

					if(dwALCStatus & 0x03)
					{
						m_dwALCSkipCount = 5;
					}

				}
			}
		}
		BYTE	byteColorInterpolationMethod = m_byteColorInterpolationMethod;

		if(NULL != m_pbyteBGRData)
		{
			m_dwBGRFrameNo = dwFrameNo;

			//Noise Reduction
			StTrg_NoiseReduction(hCamera, m_dwNoiseReductionMode, dwWidth, dwHeight, wColorArray, pbyteRaw);

			//Shading Correction
			StTrg_ShadingCorrection(hCamera, dwWidth, dwHeight, dwWidth, pbyteRaw, 8);

			if(STCAM_COLOR_ARRAY_MONO != wColorArray)
			{
				//WhiteBalance
				StTrg_WhiteBalance(hCamera, pbyteRaw);
			
				//Color Gamma
				StTrg_RawColorGamma(hCamera, dwWidth, dwHeight, wColorArray, pbyteRaw);
			}

			//Mirror Rotation
			StTrg_MirrorRotation(m_byteMirrorMode, m_byteRotationMode, &dwWidth, &dwHeight, &wColorArray, pbyteRaw);
			m_dwBGRWidth = dwWidth;
			m_dwBGRHeight = dwHeight;

			//Color Interpolation
			StTrg_ColorInterpolation(dwWidth, dwHeight, wColorArray, pbyteRaw, m_pbyteBGRData, byteColorInterpolationMethod, dwPixelFormat);
				
			//Gamma
			StTrg_BGRGamma(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);

			if(STCAM_COLOR_ARRAY_MONO != wColorArray)
			{
				//HueSaturationColorMatrix
				StTrg_HueSaturationColorMatrix(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);
			}

			//Sharpness
			StTrg_Sharpness(hCamera, dwWidth, dwHeight, dwPixelFormat, m_pbyteBGRData);

		}
	}
	ReleaseMutex(m_hBGRMutex);
	
	if(NULL != m_pImageView)
	{
		StTrg_SetDelayedInvalidateRequest(hCamera, m_pImageView->GetSafeHwnd());
		//m_pImageView->Invalidate(FALSE);
	}

	//Counter
	m_dwReceiveCount++;

	m_pobjFPS->Rcv();

	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_TRANSFER_END, (WPARAM)hCamera, (LPARAM)dwFrameNo);
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::ExposureEndCallback(HANDLE hCamera, DWORD dwFrameNo)
{


	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_EXPOSURE_END, (WPARAM)hCamera, (LPARAM)dwFrameNo);
	}	
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::RcvErrorCallback(HANDLE hCamera, DWORD dwErrorCode)
{
	//Counter
	if(
		(ERR_EXPOSURE_END_DROPPED == dwErrorCode) ||
		(ERR_IMAGE_DATA_DROPPED == dwErrorCode)
	)
	{
		m_dwDropCount++;	
	}

	//Access Denied
	if(ERROR_ACCESS_DENIED == dwErrorCode)
	{
		m_bTransferFg = FALSE;
	}
	
	//Post Message
	if(NULL != m_pImageView)
	{
		PostMessage(m_pImageView->GetSafeHwnd(), WM_APP_RCV_ERROR, (WPARAM)hCamera, (LPARAM)dwErrorCode);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnFileSaveBmp() 
{
	DWORD dwJpegQuality = 0;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		CFileDialog dlg(FALSE, TEXT("bmp"), TEXT(""), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
			TEXT("Bitmap(*.bmp)|*.bmp|Tiff(*.tif)|*.tif|JPEG(*.jpg)|*.jpg|All Files(*.*)|*.*||"), NULL);
		if(IDOK == dlg.DoModal())
		{
			StTrg_SaveImage(m_dwBGRWidth, m_dwBGRHeight, m_dwBGRPixelFormat, m_pbyteBGRData, dlg.GetPathName(), dwJpegQuality);
		}
	}
	ReleaseMutex(m_hBGRMutex);	
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateFileSaveBmp(CCmdUI* pCmdUI) 
{
	BOOL	bEnabled = FALSE;
	WaitForSingleObject(m_hBGRMutex, INFINITE);
	if(NULL != m_pbyteBGRData)
	{
		bEnabled = TRUE;
	}
	ReleaseMutex(m_hBGRMutex);	
	pCmdUI->Enable(bEnabled);	
}
//-----------------------------------------------------------------------------
//For Raw Data
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnFileSaveRaw()
{
#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	DWORD dwJpegQuality = 0;
	WaitForSingleObject(m_hRawMutex, INFINITE);
	if(NULL != m_pbyteRawData)
	{
		CFileDialog dlg(FALSE, TEXT("tif"), TEXT(""), OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, 
			TEXT("Tiff(*.tif)|*.tif|Raw(*.raw)|*.raw|All Files(*.*)|*.*||"), NULL);
		if(IDOK == dlg.DoModal())
		{
			DWORD dwPixelFormat = STCAM_PIXEL_FORMAT_08_MONO_OR_RAW;
			switch(m_dwRawTransferBitsPerPixel)
			{
			case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_10):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_12):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_14):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_MONO_16):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_10):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_12):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_14):
			case(STCAM_TRANSFER_BITS_PER_PIXEL_RAW_16):
				dwPixelFormat = STCAM_PIXEL_FORMAT_16_MONO_OR_RAW;
				break;
			}
			StTrg_SaveImage(m_dwRawWidth, m_dwRawHeight, dwPixelFormat, m_pbyteRawData, dlg.GetPathName(), dwJpegQuality);
		}
	}
	ReleaseMutex(m_hRawMutex);	
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION
}

//-----------------------------------------------------------------------------
//For Raw Data
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateFileSaveRaw(CCmdUI *pCmdUI)
{
#ifndef DISABLE_RAW_DATA_SAVE_FUNCTION
	BOOL	bEnabled = FALSE;
	WaitForSingleObject(m_hRawMutex, INFINITE);
	if(NULL != m_pbyteRawData)
	{
		bEnabled = TRUE;
	}
	ReleaseMutex(m_hRawMutex);	
	pCmdUI->Enable(bEnabled);
#else
	
	pCmdUI->m_pParentMenu->RemoveMenu(pCmdUI->m_nID, MF_BYCOMMAND);
#endif //DISABLE_RAW_DATA_SAVE_FUNCTION
}


//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnMenuTriggerSoftware(UINT nID)
{
	BOOL bReval = TRUE;
	if(NULL != m_hCamera)
	{
		DWORD dwTriggerSelector;
		switch(nID)
		{
		case(ID_MODE_TRIGGER_FRAMESTART):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_FRAME_START; break;
		case(ID_MODE_TRIGGER_EXPOSURESTART):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_EXPOSURE_START; break;
		case(ID_MODE_TRIGGER_EXPOSUREEND):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_EXPOSURE_END; break;
		case(ID_MODE_TRIGGER_SENSOR_READ_OUT_START):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_SENSOR_READ_OUT_START; break;
		}
		bReval = TriggerSoftware(dwTriggerSelector);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnUpdateTriggerSoftware(CCmdUI* pCmdUI) 
{
	BOOL	bEnabled = FALSE;
	if(NULL != m_hCamera)
	{
		DWORD dwTriggerSelector;
		switch(pCmdUI->m_nID)
		{
		case(ID_MODE_TRIGGER_FRAMESTART):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_FRAME_START; break;
		case(ID_MODE_TRIGGER_EXPOSURESTART):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_EXPOSURE_START; break;
		case(ID_MODE_TRIGGER_EXPOSUREEND):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_EXPOSURE_END; break;
		case(ID_MODE_TRIGGER_SENSOR_READ_OUT_START):	dwTriggerSelector = STCAM_TRIGGER_SELECTOR_SENSOR_READ_OUT_START; break;
		}
		bEnabled = IsEnableTriggerSoftware(dwTriggerSelector);
	}

	pCmdUI->Enable(bEnabled);
}




//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::GetStatusInfo(PSSTATUS_INFO pStatusInfo)
{
	pStatusInfo->dblFPS = m_pobjFPS->GetFPS();
	pStatusInfo->dwFrameNo = m_dwBGRFrameNo;
	pStatusInfo->dwRcvCount = m_dwReceiveCount;
	pStatusInfo->dwDropCount = m_dwDropCount;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeSetting() 
{
	if(NULL != m_hSettingDlg)
	{
		m_hSettingDlg->SetFocus();
	}
	else
	{
		m_hSettingDlg = new CTabParentDlg;
		m_hSettingDlg->m_pImageView = m_pImageView;
		m_hSettingDlg->m_pStCamera = (CStCamera*)this;

		m_hSettingDlg->m_hCamera = m_hCamera;

		m_hSettingDlg->Create(IDD_TAB_PARENT_DIALOG, CWnd::GetDesktopWindow());
		m_hSettingDlg->ShowWindow(SW_SHOW);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CStTrgDisplayDoc::OnModeCameraId() 
{
	CInputCameraIDDlg	dlg;
	BOOL bReval = TRUE;
	dlg.m_szCameraName = m_szCameraName;
	dlg.m_dwCameraNumber = m_dwCameraNo;
	if(IDOK == dlg.DoModal())
	{
		_tcscpy_s(m_szCameraName, _countof(m_szCameraName), dlg.m_szCameraName.GetBuffer(250));
		dlg.m_szCameraName.ReleaseBuffer();
		m_dwCameraNo = dlg.m_dwCameraNumber;
		do{
			bReval = StTrg_WriteCameraUserID(m_hCamera, m_dwCameraNo, m_szCameraName, sizeof(m_szCameraName));
			if(!bReval) break;

			bReval = StTrg_ReadCameraUserID(m_hCamera, &m_dwCameraNo, m_szCameraName, sizeof(m_szCameraName));
			if(!bReval) break;
		}while(0);
		UpdateDocTitle();
	}
}
