#include <windows.h>
#include <tchar.h>
#include <stdio.h>
#include <math.h>
#include "../../../include/StTrgApi.h"

#ifdef _WIN64
#pragma comment(lib, "../../../lib/x64/StTrgApi.lib")
#else //_WIN64
#pragma comment(lib, "../../../lib/x86/StTrgApi.lib")
#endif //_WIN64

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void Display(PBYTE pbyteBuffer, size_t nCount)
{
	TCHAR szText[1024];
	for(size_t i = 0; i < nCount; i++)
	{
		if((i & 0xF) == 0)
		{
			_stprintf_s(szText, _countof(szText), TEXT("%03X"), i);
		}

		TCHAR szTmp[1024];
		_stprintf_s(szTmp, _countof(szTmp), TEXT(" %02X"), pbyteBuffer[i]);

		_tcscat_s(szText, _countof(szText), szTmp);

		if((i & 0xF) == 0xF)
		{
			_tcscat_s(szText, _countof(szText), TEXT("\r\n"));
			_tprintf(szText);
		}
	}

	if((nCount & 0xF ) != 0)
	{
		_tprintf(szText);
	}
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DWORD ReadUserMemory(HANDLE hCamera)
{
	DWORD dwError = NO_ERROR;
	BYTE pbyteBuffer[1024];
	memset(pbyteBuffer, 0, sizeof(pbyteBuffer));
	if(!StTrg_ReadUserMemory(hCamera, pbyteBuffer, 0, sizeof(pbyteBuffer)))
	{
		dwError = GetLastError();
	}
	else
	{
		_tprintf(TEXT("Read Data\r\n"));
		Display(pbyteBuffer, sizeof(pbyteBuffer));
	}
	return(dwError);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
DWORD WriteUserMemory(HANDLE hCamera)
{
	DWORD dwError = NO_ERROR;
	BYTE pbyteBuffer[1024];

	for(int i = 0; i < _countof(pbyteBuffer); i++)
	{
		pbyteBuffer[i] = (BYTE)(rand() % 0x100);
	}

	if(!StTrg_WriteUserMemory(hCamera, pbyteBuffer, 0, sizeof(pbyteBuffer)))
	{
		dwError = GetLastError();
	}
	else
	{
		_tprintf(TEXT("Write Data\r\n"));
		Display(pbyteBuffer, sizeof(pbyteBuffer));
	}
	return(dwError);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
int main(int argc, char* argv[])
{
	HANDLE hCamera = INVALID_HANDLE_VALUE;

	//-------------------------------------------------------------------------
	//Open
	//-------------------------------------------------------------------------
	hCamera = StTrg_Open();
	if(INVALID_HANDLE_VALUE == hCamera)
	{
		_tprintf(TEXT("Couldn't Open.\n"));
		return(-1);
	}

	//-------------------------------------------------------------------------
	//
	//-------------------------------------------------------------------------
	_tprintf(TEXT("R[Enter] - Read data form the eeprom.\n"));
	_tprintf(TEXT("W[Enter] - Write random data to the eeprom.\n"));
	_tprintf(TEXT("E[Enter] - Exit.\n"));
	TCHAR	szInput[2] = {0, 0};

	BOOL bExit = FALSE;
	while(!bExit)
	{
		szInput[0] = _gettchar();
		_tcsupr_s(szInput, _countof(szInput));
		switch(szInput[0])
		{
		case(TEXT('R')):
			ReadUserMemory(hCamera);
			break;
		case(TEXT('W')):
			WriteUserMemory(hCamera);
			break;
		case(TEXT('E')):
			bExit = TRUE;
			break;

		}
	}	//while(!g_bExitMenu)

	
	//-------------------------------------------------------------------------
	//Close
	//-------------------------------------------------------------------------
	StTrg_Close(hCamera);


	return 0;
}

