using System;
using System.Collections.Generic;
using System.Text;

using System.Runtime.InteropServices;
using System.Security;
namespace Sentech
{
	[ComImport, System.Security.SuppressUnmanagedCodeSecurity,
	Guid("430A9E41-9242-4192-AF1C-6E0AC0A19553"),
	InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IStUSB
	{
		#region IStUSB
		//IStUSB
		[PreserveSig]
		int get_CameraId(out uint iCameraId);
		[PreserveSig]
		int get_InterpolationMode(out byte byteInterpolationMode);
		[PreserveSig]
		int put_InterpolationMode(byte byteInterpolationMode);
		[PreserveSig]
		int get_MirrorMode(out byte byteMirrorMode);
		[PreserveSig]
		int put_MirrorMode(byte byteMirrorMode);
		[PreserveSig]
		int get_SharpnessMode(out byte fSharpnessMode);
		[PreserveSig]
		int put_SharpnessMode(byte fSharpnessMode);
		[PreserveSig]
		int get_SharpnessCoring(out byte byteSharpnessCoring);
		[PreserveSig]
		int put_SharpnessCoring(byte byteSharpnessCoring);
		[PreserveSig]
		int get_SharpnessGain(out ushort wSharpnessGain);
		[PreserveSig]
		int put_SharpnessGain(ushort wSharpnessGain);
		[PreserveSig]
		int get_BrightnessTarget(out byte byteBrightnessTarget);
		[PreserveSig]
		int put_BrightnessTarget(byte byteBrightnessTarget);
		[PreserveSig]
		int get_BrightnessTolerance(out byte byteBrightnessTolerance);
		[PreserveSig]
		int put_BrightnessTolerance(byte byteBrightnessTolerance);
		[PreserveSig]
		int get_BrightnessThreshold(out byte byteBrightnessThreshold);
		[PreserveSig]
		int put_BrightnessThreshold(byte byteBrightnessThreshold);
		[PreserveSig]
		int get_AlcMode(out byte byteAlcMode);
		[PreserveSig]
		int put_AlcMode(byte byteAlcMode);
		[PreserveSig]
		int get_Gain(out ushort wGain);
		[PreserveSig]
		int put_Gain(ushort wGain);
		[PreserveSig]
		int get_ShutterLine(out ushort wShutterLine);
		[PreserveSig]
		int put_ShutterLine(ushort wShutterLine);
		[PreserveSig]
		int get_ShutterClock(out ushort wShutterClock);
		[PreserveSig]
		int put_ShutterClock(ushort wShutterClock);
		[PreserveSig]
		int get_TotalVLine(out ushort wFrame);
		[PreserveSig]
		int get_TotalHClock(out ushort wClock);
		[PreserveSig]
		int get_WhiteBalanceMode(out byte byteWBMode);
		[PreserveSig]
		int put_WhiteBalanceMode(byte byteWBMode);
		[PreserveSig]
		int get_WhiteBalanceGainR(out ushort wGainR);
		[PreserveSig]
		int put_WhiteBalanceGainR(ushort wGainR);
		[PreserveSig]
		int get_WhiteBalanceGainGr(out ushort wGainGr);
		[PreserveSig]
		int put_WhiteBalanceGainGr(ushort wGainGr);
		[PreserveSig]
		int get_WhiteBalanceGainGb(out ushort wGainGb);
		[PreserveSig]
		int put_WhiteBalanceGainGb(ushort wGainGb);
		[PreserveSig]
		int get_WhiteBalanceGainB(out ushort wGainB);
		[PreserveSig]
		int put_WhiteBalanceGainB(ushort wGainB);
		[PreserveSig]
		int get_WhiteBalanceTargetR(out ushort wTargetR);
		[PreserveSig]
		int put_WhiteBalanceTargetR(ushort wTargetR);
		[PreserveSig]
		int get_WhiteBalanceTargetB(out ushort wTargetB);
		[PreserveSig]
		int put_WhiteBalanceTargetB(ushort wTargetB);
		[PreserveSig]
		int get_HueSaturationMode(out byte byteHueSaturationMode);
		[PreserveSig]
		int put_HueSaturationMode(byte byteHueSaturationMode);
		[PreserveSig]
		int get_Hue(out short sHue);
		[PreserveSig]
		int put_Hue(short sHue);
		[PreserveSig]
		int get_Saturation(out ushort wSaturation);
		[PreserveSig]
		int put_Saturation(ushort wSaturation);
		[PreserveSig]
		int get_ColorMatrixMode(out byte byteColorMatrix);
		[PreserveSig]
		int put_ColorMatrixMode(byte byteColorMatrix);
		[PreserveSig]
		int get_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		int put_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		int get_GammaMode(out byte byteGammaMode);
		[PreserveSig]
		int put_GammaMode(byte byteGammaMode);
		[PreserveSig]
		int get_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		int put_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		int get_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		int put_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		int get_Gamma(out ushort wGamma);
		[PreserveSig]
		int put_Gamma(ushort wGamma);
		[PreserveSig]
		int get_ClockMode(out uint dwClockMode);
		[PreserveSig]
		int put_ClockMode(uint dwClockMode);
		[PreserveSig]
		int get_ClockFrequency(out uint dwClockFrequency);
		[PreserveSig]
		int put_ClockFrequency(uint dwClockFrequency);
		[PreserveSig]
		int get_ClockFrequencyStandard(out uint dwClockFrequency);
		[PreserveSig]
		int get_ClockFrequencyMin(out uint dwClockFrequency);
		[PreserveSig]
		int get_ClockFrequencyMax(out uint dwClockFrequency);
		[PreserveSig]
		int get_ProductId(out ushort wProductId);
		[PreserveSig]
		int get_SDKFileVersion(out uint llVersion);
		[PreserveSig]
		int get_SDKProductVersion(out uint llVersion);
		[PreserveSig]
		int get_HWShutterFix(out byte byteMode);
		[PreserveSig]
		int get_AlcWeight([MarshalAs(UnmanagedType.LPArray)]  byte[] byteWeight);
		[PreserveSig]
		int put_AlcWeight([MarshalAs(UnmanagedType.LPArray)] byte[] byteWeight);
		[PreserveSig]
		int get_GainControlRangeMin(out ushort wMin);
		[PreserveSig]
		int put_GainControlRangeMin(ushort wMin);
		[PreserveSig]
		int get_GainControlRangeMax(out ushort wMax);
		[PreserveSig]
		int put_GainControlRangeMax(ushort wMax);
		[PreserveSig]
		int get_ShutterControlRangeClockMin(out ushort wMin);
		[PreserveSig]
		int put_ShutterControlRangeClockMin(ushort wMin);
		[PreserveSig]
		int get_ShutterControlRangeClockMax(out ushort wMax);
		[PreserveSig]
		int put_ShutterControlRangeClockMax(ushort wMax);
		[PreserveSig]
		int get_ShutterControlRangeLineMin(out ushort wMin);
		[PreserveSig]
		int put_ShutterControlRangeLineMin(ushort wMin);
		[PreserveSig]
		int get_ShutterControlRangeLineMax(out ushort wMax);
		[PreserveSig]
		int put_ShutterControlRangeLineMax(ushort wMax);
		[PreserveSig]
		int get_ScanMode(out ushort wMode);
		[PreserveSig]
		int put_ScanMode(ushort wMode);
		[PreserveSig]
		int get_CameraHandle(out IntPtr handle);
		[PreserveSig]
		int ResetToDefault();
		#endregion IStUSB
	}
	[ComImport, System.Security.SuppressUnmanagedCodeSecurity,
	Guid("22A496AE-0A04-45FE-9524-58197662D090"),
	InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IStUSB2 : IStUSB
	{

		#region IStUSB-new
		//IStUSB
		[PreserveSig]
		new int get_CameraId(out uint iCameraId);
		[PreserveSig]
		new int get_InterpolationMode(out byte byteInterpolationMode);
		[PreserveSig]
		new int put_InterpolationMode(byte byteInterpolationMode);
		[PreserveSig]
		new int get_MirrorMode(out byte byteMirrorMode);
		[PreserveSig]
		new int put_MirrorMode(byte byteMirrorMode);
		[PreserveSig]
		new int get_SharpnessMode(out byte fSharpnessMode);
		[PreserveSig]
		new int put_SharpnessMode(byte fSharpnessMode);
		[PreserveSig]
		new int get_SharpnessCoring(out byte byteSharpnessCoring);
		[PreserveSig]
		new int put_SharpnessCoring(byte byteSharpnessCoring);
		[PreserveSig]
		new int get_SharpnessGain(out ushort wSharpnessGain);
		[PreserveSig]
		new int put_SharpnessGain(ushort wSharpnessGain);
		[PreserveSig]
		new int get_BrightnessTarget(out byte byteBrightnessTarget);
		[PreserveSig]
		new int put_BrightnessTarget(byte byteBrightnessTarget);
		[PreserveSig]
		new int get_BrightnessTolerance(out byte byteBrightnessTolerance);
		[PreserveSig]
		new int put_BrightnessTolerance(byte byteBrightnessTolerance);
		[PreserveSig]
		new int get_BrightnessThreshold(out byte byteBrightnessThreshold);
		[PreserveSig]
		new int put_BrightnessThreshold(byte byteBrightnessThreshold);
		[PreserveSig]
		new int get_AlcMode(out byte byteAlcMode);
		[PreserveSig]
		new int put_AlcMode(byte byteAlcMode);
		[PreserveSig]
		new int get_Gain(out ushort wGain);
		[PreserveSig]
		new int put_Gain(ushort wGain);
		[PreserveSig]
		new int get_ShutterLine(out ushort wShutterLine);
		[PreserveSig]
		new int put_ShutterLine(ushort wShutterLine);
		[PreserveSig]
		new int get_ShutterClock(out ushort wShutterClock);
		[PreserveSig]
		new int put_ShutterClock(ushort wShutterClock);
		[PreserveSig]
		new int get_TotalVLine(out ushort wFrame);
		[PreserveSig]
		new int get_TotalHClock(out ushort wClock);
		[PreserveSig]
		new int get_WhiteBalanceMode(out byte byteWBMode);
		[PreserveSig]
		new int put_WhiteBalanceMode(byte byteWBMode);
		[PreserveSig]
		new int get_WhiteBalanceGainR(out ushort wGainR);
		[PreserveSig]
		new int put_WhiteBalanceGainR(ushort wGainR);
		[PreserveSig]
		new int get_WhiteBalanceGainGr(out ushort wGainGr);
		[PreserveSig]
		new int put_WhiteBalanceGainGr(ushort wGainGr);
		[PreserveSig]
		new int get_WhiteBalanceGainGb(out ushort wGainGb);
		[PreserveSig]
		new int put_WhiteBalanceGainGb(ushort wGainGb);
		[PreserveSig]
		new int get_WhiteBalanceGainB(out ushort wGainB);
		[PreserveSig]
		new int put_WhiteBalanceGainB(ushort wGainB);
		[PreserveSig]
		new int get_WhiteBalanceTargetR(out ushort wTargetR);
		[PreserveSig]
		new int put_WhiteBalanceTargetR(ushort wTargetR);
		[PreserveSig]
		new int get_WhiteBalanceTargetB(out ushort wTargetB);
		[PreserveSig]
		new int put_WhiteBalanceTargetB(ushort wTargetB);
		[PreserveSig]
		new int get_HueSaturationMode(out byte byteHueSaturationMode);
		[PreserveSig]
		new int put_HueSaturationMode(byte byteHueSaturationMode);
		[PreserveSig]
		new int get_Hue(out short sHue);
		[PreserveSig]
		new int put_Hue(short sHue);
		[PreserveSig]
		new int get_Saturation(out ushort wSaturation);
		[PreserveSig]
		new int put_Saturation(ushort wSaturation);
		[PreserveSig]
		new int get_ColorMatrixMode(out byte byteColorMatrix);
		[PreserveSig]
		new int put_ColorMatrixMode(byte byteColorMatrix);
		[PreserveSig]
		new int get_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		new int put_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		new int get_GammaMode(out byte byteGammaMode);
		[PreserveSig]
		new int put_GammaMode(byte byteGammaMode);
		[PreserveSig]
		new int get_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		new int put_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		new int get_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		new int put_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		new int get_Gamma(out ushort wGamma);
		[PreserveSig]
		new int put_Gamma(ushort wGamma);
		[PreserveSig]
		new int get_ClockMode(out uint dwClockMode);
		[PreserveSig]
		new int put_ClockMode(uint dwClockMode);
		[PreserveSig]
		new int get_ClockFrequency(out uint dwClockFrequency);
		[PreserveSig]
		new int put_ClockFrequency(uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyStandard(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyMin(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyMax(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ProductId(out ushort wProductId);
		[PreserveSig]
		new int get_SDKFileVersion(out uint llVersion);
		[PreserveSig]
		new int get_SDKProductVersion(out uint llVersion);
		[PreserveSig]
		new int get_HWShutterFix(out byte byteMode);
		[PreserveSig]
		new int get_AlcWeight([MarshalAs(UnmanagedType.LPArray)]  byte[] byteWeight);
		[PreserveSig]
		new int put_AlcWeight([MarshalAs(UnmanagedType.LPArray)] byte[] byteWeight);
		[PreserveSig]
		new int get_GainControlRangeMin(out ushort wMin);
		[PreserveSig]
		new int put_GainControlRangeMin(ushort wMin);
		[PreserveSig]
		new int get_GainControlRangeMax(out ushort wMax);
		[PreserveSig]
		new int put_GainControlRangeMax(ushort wMax);
		[PreserveSig]
		new int get_ShutterControlRangeClockMin(out ushort wMin);
		[PreserveSig]
		new int put_ShutterControlRangeClockMin(ushort wMin);
		[PreserveSig]
		new int get_ShutterControlRangeClockMax(out ushort wMax);
		[PreserveSig]
		new int put_ShutterControlRangeClockMax(ushort wMax);
		[PreserveSig]
		new int get_ShutterControlRangeLineMin(out ushort wMin);
		[PreserveSig]
		new int put_ShutterControlRangeLineMin(ushort wMin);
		[PreserveSig]
		new int get_ShutterControlRangeLineMax(out ushort wMax);
		[PreserveSig]
		new int put_ShutterControlRangeLineMax(ushort wMax);
		[PreserveSig]
		new int get_ScanMode(out ushort wMode);
		[PreserveSig]
		new int put_ScanMode(ushort wMode);
		[PreserveSig]
		new int get_CameraHandle(out IntPtr handle);
		[PreserveSig]
		new int ResetToDefault();
		#endregion IStUSB


		#region IStUSB2
		//IStUSB2
		[PreserveSig]
		int put_CameraId(uint iCameraId);
		[PreserveSig]
		int get_CameraName(System.Text.StringBuilder pstrName, int iSize);
		[PreserveSig]
		int put_CameraName(string pstrName, int iSize);
		[PreserveSig]
		int get_DigitalGain(out ushort wGain);
		[PreserveSig]
		int put_DigitalGain(ushort wGain);
		#endregion IStUSB2
	}
	[ComImport, System.Security.SuppressUnmanagedCodeSecurity,
	Guid("530A9E41-9242-4192-AF1C-6E0AC0A19553"),
	InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IStUSB3 : IStUSB2
	{
		#region IStUSB-new
		//IStUSB
		[PreserveSig]
		new int get_CameraId(out uint iCameraId);
		[PreserveSig]
		new int get_InterpolationMode(out byte byteInterpolationMode);
		[PreserveSig]
		new int put_InterpolationMode(byte byteInterpolationMode);
		[PreserveSig]
		new int get_MirrorMode(out byte byteMirrorMode);
		[PreserveSig]
		new int put_MirrorMode(byte byteMirrorMode);
		[PreserveSig]
		new int get_SharpnessMode(out byte fSharpnessMode);
		[PreserveSig]
		new int put_SharpnessMode(byte fSharpnessMode);
		[PreserveSig]
		new int get_SharpnessCoring(out byte byteSharpnessCoring);
		[PreserveSig]
		new int put_SharpnessCoring(byte byteSharpnessCoring);
		[PreserveSig]
		new int get_SharpnessGain(out ushort wSharpnessGain);
		[PreserveSig]
		new int put_SharpnessGain(ushort wSharpnessGain);
		[PreserveSig]
		new int get_BrightnessTarget(out byte byteBrightnessTarget);
		[PreserveSig]
		new int put_BrightnessTarget(byte byteBrightnessTarget);
		[PreserveSig]
		new int get_BrightnessTolerance(out byte byteBrightnessTolerance);
		[PreserveSig]
		new int put_BrightnessTolerance(byte byteBrightnessTolerance);
		[PreserveSig]
		new int get_BrightnessThreshold(out byte byteBrightnessThreshold);
		[PreserveSig]
		new int put_BrightnessThreshold(byte byteBrightnessThreshold);
		[PreserveSig]
		new int get_AlcMode(out byte byteAlcMode);
		[PreserveSig]
		new int put_AlcMode(byte byteAlcMode);
		[PreserveSig]
		new int get_Gain(out ushort wGain);
		[PreserveSig]
		new int put_Gain(ushort wGain);
		[PreserveSig]
		new int get_ShutterLine(out ushort wShutterLine);
		[PreserveSig]
		new int put_ShutterLine(ushort wShutterLine);
		[PreserveSig]
		new int get_ShutterClock(out ushort wShutterClock);
		[PreserveSig]
		new int put_ShutterClock(ushort wShutterClock);
		[PreserveSig]
		new int get_TotalVLine(out ushort wFrame);
		[PreserveSig]
		new int get_TotalHClock(out ushort wClock);
		[PreserveSig]
		new int get_WhiteBalanceMode(out byte byteWBMode);
		[PreserveSig]
		new int put_WhiteBalanceMode(byte byteWBMode);
		[PreserveSig]
		new int get_WhiteBalanceGainR(out ushort wGainR);
		[PreserveSig]
		new int put_WhiteBalanceGainR(ushort wGainR);
		[PreserveSig]
		new int get_WhiteBalanceGainGr(out ushort wGainGr);
		[PreserveSig]
		new int put_WhiteBalanceGainGr(ushort wGainGr);
		[PreserveSig]
		new int get_WhiteBalanceGainGb(out ushort wGainGb);
		[PreserveSig]
		new int put_WhiteBalanceGainGb(ushort wGainGb);
		[PreserveSig]
		new int get_WhiteBalanceGainB(out ushort wGainB);
		[PreserveSig]
		new int put_WhiteBalanceGainB(ushort wGainB);
		[PreserveSig]
		new int get_WhiteBalanceTargetR(out ushort wTargetR);
		[PreserveSig]
		new int put_WhiteBalanceTargetR(ushort wTargetR);
		[PreserveSig]
		new int get_WhiteBalanceTargetB(out ushort wTargetB);
		[PreserveSig]
		new int put_WhiteBalanceTargetB(ushort wTargetB);
		[PreserveSig]
		new int get_HueSaturationMode(out byte byteHueSaturationMode);
		[PreserveSig]
		new int put_HueSaturationMode(byte byteHueSaturationMode);
		[PreserveSig]
		new int get_Hue(out short sHue);
		[PreserveSig]
		new int put_Hue(short sHue);
		[PreserveSig]
		new int get_Saturation(out ushort wSaturation);
		[PreserveSig]
		new int put_Saturation(ushort wSaturation);
		[PreserveSig]
		new int get_ColorMatrixMode(out byte byteColorMatrix);
		[PreserveSig]
		new int put_ColorMatrixMode(byte byteColorMatrix);
		[PreserveSig]
		new int get_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		new int put_ColorMatrix([MarshalAs(UnmanagedType.LPArray)] short[] sColorMatrix);
		[PreserveSig]
		new int get_GammaMode(out byte byteGammaMode);
		[PreserveSig]
		new int put_GammaMode(byte byteGammaMode);
		[PreserveSig]
		new int get_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		new int put_GammaTarget(byte byteGammaTarget);
		[PreserveSig]
		new int get_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		new int put_GammaTable([MarshalAs(UnmanagedType.LPArray)] byte[] byteGammaTable);
		[PreserveSig]
		new int get_Gamma(out ushort wGamma);
		[PreserveSig]
		new int put_Gamma(ushort wGamma);
		[PreserveSig]
		new int get_ClockMode(out uint dwClockMode);
		[PreserveSig]
		new int put_ClockMode(uint dwClockMode);
		[PreserveSig]
		new int get_ClockFrequency(out uint dwClockFrequency);
		[PreserveSig]
		new int put_ClockFrequency(uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyStandard(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyMin(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ClockFrequencyMax(out uint dwClockFrequency);
		[PreserveSig]
		new int get_ProductId(out ushort wProductId);
		[PreserveSig]
		new int get_SDKFileVersion(out uint llVersion);
		[PreserveSig]
		new int get_SDKProductVersion(out uint llVersion);
		[PreserveSig]
		new int get_HWShutterFix(out byte byteMode);
		[PreserveSig]
		new int get_AlcWeight([MarshalAs(UnmanagedType.LPArray)]  byte[] byteWeight);
		[PreserveSig]
		new int put_AlcWeight([MarshalAs(UnmanagedType.LPArray)] byte[] byteWeight);
		[PreserveSig]
		new int get_GainControlRangeMin(out ushort wMin);
		[PreserveSig]
		new int put_GainControlRangeMin(ushort wMin);
		[PreserveSig]
		new int get_GainControlRangeMax(out ushort wMax);
		[PreserveSig]
		new int put_GainControlRangeMax(ushort wMax);
		[PreserveSig]
		new int get_ShutterControlRangeClockMin(out ushort wMin);
		[PreserveSig]
		new int put_ShutterControlRangeClockMin(ushort wMin);
		[PreserveSig]
		new int get_ShutterControlRangeClockMax(out ushort wMax);
		[PreserveSig]
		new int put_ShutterControlRangeClockMax(ushort wMax);
		[PreserveSig]
		new int get_ShutterControlRangeLineMin(out ushort wMin);
		[PreserveSig]
		new int put_ShutterControlRangeLineMin(ushort wMin);
		[PreserveSig]
		new int get_ShutterControlRangeLineMax(out ushort wMax);
		[PreserveSig]
		new int put_ShutterControlRangeLineMax(ushort wMax);
		[PreserveSig]
		new int get_ScanMode(out ushort wMode);
		[PreserveSig]
		new int put_ScanMode(ushort wMode);
		[PreserveSig]
		new int get_CameraHandle(out IntPtr handle);
		[PreserveSig]
		new int ResetToDefault();
		#endregion IStUSB


		#region IStUSB2-new
		//IStUSB2
		[PreserveSig]
		new int put_CameraId(uint iCameraId);
		[PreserveSig]
		new int get_CameraName(System.Text.StringBuilder pstrName, int iSize);
		[PreserveSig]
		new int put_CameraName(string pstrName, int iSize);
		[PreserveSig]
		new int get_DigitalGain(out ushort wGain);
		[PreserveSig]
		new int put_DigitalGain(ushort wGain);
		#endregion IStUSB2

		#region IStUSB3
		//IStUSB3
		[PreserveSig]
		int get_CurrentFrameNumber(out uint dwFrameNum);
		[PreserveSig]
		int put_TriggerMode(uint dwTriggerMode);
		[PreserveSig]
		int get_TriggerMode(out uint dwTriggerMode);
		[PreserveSig]
		int put_ExposureClock(uint dwExposureClock);
		[PreserveSig]
		int get_ExposureClock(out uint dwExposureClock);
		[PreserveSig]
		int put_NoiseReduction(uint dwNoiseReduction);
		[PreserveSig]
		int get_NoiseReduction(out uint dwNoiseReduction);
		[PreserveSig]
		int put_SoftTrigger();
		[PreserveSig]
		int put_SoftSubTrigger();
		[PreserveSig]
		int put_TriggerReadOut();
		[PreserveSig]
		int put_resetCounter();
		[PreserveSig]
		int put_TriggerTiming(uint dwTriggerTimingType, uint dwValue);
		[PreserveSig]
		int get_TriggerTiming(uint dwTriggerTimingType, out uint dwValue);
		[PreserveSig]
		int put_IOPinDirection(uint dwDirection);
		[PreserveSig]
		int get_IOPinDirection(out uint dwDirection);
		[PreserveSig]
		int put_IOPinMode(byte bytePinNo, uint dwMode);
		[PreserveSig]
		int get_IOPinMode(byte bytePinNo, out uint dwMode);
		[PreserveSig]
		int put_IOPinPolarity(uint dwPolarity);
		[PreserveSig]
		int get_IOPinPolarity(out uint dwPolarity);
		[PreserveSig]
		int put_IOPinStatus(uint dwStatus);
		[PreserveSig]
		int get_IOPinStatus(out uint dwStatus);
		[PreserveSig]
		int get_SwStatus(out uint dwSwStatus);
		[PreserveSig]
		int put_LEDStatus(uint dwLEDStatus);
		[PreserveSig]
		int get_LEDStatus(out uint dwLEDStatus);
		[PreserveSig]
		int put_SetEvent(int EventType, IntPtr EventObject);
		[PreserveSig]
		int put_LoadReg(string RegNo);
		[PreserveSig]
		int put_SaveReg(string RegNo);
		[PreserveSig]
		int put_DeleteReg(string RegNo);
		[PreserveSig]
		int put_DefaultReg(string RegNo);
		[PreserveSig]
		int get_DefaultReg(System.Text.StringBuilder RegNo, int RegLen);
		[PreserveSig]
		int get_ParametersList(System.Text.StringBuilder pRegList, int RegListLen);
		[PreserveSig]
		int get_ParametersListNum(out int pRegListNum);
		[PreserveSig]
		int get_HasFunction(uint FuncFlags, out bool hasFunction);
		[PreserveSig]
		int get_DigitalGainInit(out ushort wGain);
		[PreserveSig]
		int get_ColorArray(out ushort wColorArray);
		[PreserveSig]
		int put_AutoSubTrigger(int isAutoSubTriggerMode, uint dwAutoSubTriggerTime);
		[PreserveSig]
		int get_AutoSubTrigger(out int isAutoSubTriggerMode, out uint dwAutoSubTriggerTime);
		#endregion IStUSB3
	}


}
