/*
 * $Workfile: IStUSBCam.h $
 * $Revision: 7 $
 *
 *  Copyright (c) 2005-2011 SENSOR TECHNOLOGY CO., LTD.  All Rights Reserved.
 *
 * @file
 * @brief	
 *
 * @date	$Date: 2011/12/12 $
 *
 */

#ifndef _ISTUSBCAM_H
#define _ISTUSBCAM_H

#ifdef __cplusplus
extern "C" {
#endif


//
// StUSBCam 
//
// IID_IStUSBCam
// {430A9E41-9242-4192-AF1C-6E0AC0A19553}
DEFINE_GUID(IID_IStUSBCam, 0x430a9e41, 0x9242, 0x4192, 0xaf, 0x1c, 0x6e, 0xa, 0xc0, 0xa1, 0x95, 0x53);	//1

// IID_IStUSBCam2
// {22A496AE-0A04-45fe-9524-58197662D090}
DEFINE_GUID(IID_IStUSBCam2, 0x22A496AE, 0x0A04, 0x45fe, 0x95, 0x24, 0x58, 0x19, 0x76, 0x62, 0xD0, 0x90);

// IStUSBCam3
// {530A9E41-9242-4192-AF1C-6E0AC0A19553}
DEFINE_GUID(IID_IStUSBCam3, 0x530A9E41, 0x9242, 0x4192, 0xAF, 0x1C, 0x6E, 0x0A, 0xC0, 0xA1, 0x95, 0x53);	//3

//
// IStUSBCam
//
DECLARE_INTERFACE_(IStUSBCam, IUnknown)
{
	STDMETHOD(get_CameraId) (THIS_ int *iCameraId) PURE;

	STDMETHOD(get_InterpolationMode) (THIS_ BYTE *byteInterpolationMode) PURE;
	STDMETHOD(put_InterpolationMode) (THIS_ BYTE byteInterpolationMode) PURE;

	STDMETHOD(get_MirrorMode) (THIS_ BYTE *byteMirrorMode) PURE;
	STDMETHOD(put_MirrorMode) (THIS_ BYTE byteMirrorMode) PURE;

	STDMETHOD(get_SharpnessMode) (THIS_ BYTE *fSharpnessMode) PURE;
	STDMETHOD(put_SharpnessMode) (THIS_ BYTE fSharpnessMode) PURE;

	STDMETHOD(get_SharpnessCoring) (THIS_ BYTE *byteSharpnessCoring) PURE;
	STDMETHOD(put_SharpnessCoring) (THIS_ BYTE byteSharpnessCoring) PURE;

	STDMETHOD(get_SharpnessGain) (THIS_ WORD *wSharpnessGain) PURE;
	STDMETHOD(put_SharpnessGain) (THIS_ WORD wSharpnessGain) PURE;

	STDMETHOD(get_BrightnessTarget) (THIS_ BYTE *byteBrightnessTarget) PURE;
	STDMETHOD(put_BrightnessTarget) (THIS_ BYTE byteBrightnessTarget) PURE;

	STDMETHOD(get_BrightnessTolerance) (THIS_ BYTE *byteBrightnessTolerance) PURE;
	STDMETHOD(put_BrightnessTolerance) (THIS_ BYTE byteBrightnessTolerance) PURE;

	STDMETHOD(get_BrightnessThreshold) (THIS_ BYTE *byteBrightnessThreshold) PURE;
	STDMETHOD(put_BrightnessThreshold) (THIS_ BYTE byteBrightnessThreshold) PURE;

	STDMETHOD(get_AlcMode) (THIS_ BYTE *byteAlcMode) PURE;
	STDMETHOD(put_AlcMode) (THIS_ BYTE byteAlcMode) PURE;

	STDMETHOD(get_Gain) (THIS_ WORD *wGain) PURE;
	STDMETHOD(put_Gain) (THIS_ WORD wGain) PURE;

	STDMETHOD(get_ShutterLine) (THIS_ WORD *wShutterLine) PURE;
	STDMETHOD(put_ShutterLine) (THIS_ WORD wShutterLine) PURE;

	STDMETHOD(get_ShutterClock) (THIS_ WORD *wShutterClock) PURE;
	STDMETHOD(put_ShutterClock) (THIS_ WORD wShutterClock) PURE;

	STDMETHOD(get_Frame) (THIS_ WORD *wFrame) PURE;

	STDMETHOD(get_Clock) (THIS_ WORD *wClock) PURE;

	STDMETHOD(get_WhiteBalanceMode) (THIS_ BYTE *byteWBMode) PURE;
	STDMETHOD(put_WhiteBalanceMode) (THIS_ BYTE byteWBMode) PURE;

	STDMETHOD(get_WhiteBalanceGainR) (THIS_ WORD *wGainR) PURE;
	STDMETHOD(put_WhiteBalanceGainR) (THIS_ WORD wGainR) PURE;

	STDMETHOD(get_WhiteBalanceGainGr) (THIS_ WORD *wGainGr) PURE;
	STDMETHOD(put_WhiteBalanceGainGr) (THIS_ WORD wGainGr) PURE;

	STDMETHOD(get_WhiteBalanceGainGb) (THIS_ WORD *wGainGb) PURE;
	STDMETHOD(put_WhiteBalanceGainGb) (THIS_ WORD wGainGb) PURE;

	STDMETHOD(get_WhiteBalanceGainB) (THIS_ WORD *wGainB) PURE;
	STDMETHOD(put_WhiteBalanceGainB) (THIS_ WORD wGainB) PURE;

	STDMETHOD(get_WhiteBalanceTargetR) (THIS_ WORD *wTargetR) PURE;
	STDMETHOD(put_WhiteBalanceTargetR) (THIS_ WORD wTargetR) PURE;

	STDMETHOD(get_WhiteBalanceTargetB) (THIS_ WORD *wTargetB) PURE;
	STDMETHOD(put_WhiteBalanceTargetB) (THIS_ WORD wTargetB) PURE;

	STDMETHOD(get_HueSaturationMode) (THIS_ BYTE *byteHueSaturation) PURE;
	STDMETHOD(put_HueSaturationMode) (THIS_ BYTE byteHueSaturation) PURE;

	STDMETHOD(get_Hue) (THIS_ SHORT *sHue) PURE;
	STDMETHOD(put_Hue) (THIS_ SHORT sHue) PURE;

	STDMETHOD(get_Saturation) (THIS_ WORD *wSaturation) PURE;
	STDMETHOD(put_Saturation) (THIS_ WORD wSaturation) PURE;

	STDMETHOD(get_ColorMatrixMode) (THIS_ BYTE *byteColorMatrix) PURE;
	STDMETHOD(put_ColorMatrixMode) (THIS_ BYTE byteColorMatrix) PURE;

	STDMETHOD(get_ColorMatrix) (THIS_ SHORT *sHue) PURE;
	STDMETHOD(put_ColorMatrix) (THIS_ SHORT *sHue) PURE;

	STDMETHOD(get_GammaMode) (THIS_ BYTE *byteGammaMode) PURE;
	STDMETHOD(put_GammaMode) (THIS_ BYTE byteGammaMode) PURE;

	STDMETHOD(get_GammaTarget) (THIS_ BYTE *byteGammaTarget) PURE;
	STDMETHOD(put_GammaTarget) (THIS_ BYTE byteGammaTarget) PURE;

	STDMETHOD(get_GammaTable) (THIS_ BYTE *byteGammaTable) PURE;
	STDMETHOD(put_GammaTable) (THIS_ BYTE *byteGammaTable) PURE;

	STDMETHOD(get_Gamma) (THIS_ WORD *wGamma) PURE;
	STDMETHOD(put_Gamma) (THIS_ WORD wGamma) PURE;

	STDMETHOD(get_ClockMode) (THIS_ DWORD *dwClockMode) PURE;
	STDMETHOD(put_ClockMode) (THIS_ DWORD dwClockMode) PURE;

	STDMETHOD(get_ClockFrequency) (THIS_ DWORD *dwClockFrequency) PURE;
	STDMETHOD(put_ClockFrequency) (THIS_ DWORD dwClockFrequency) PURE;

	STDMETHOD(get_ClockFrequencyStandard) (THIS_ DWORD *dwClockFrequency) PURE;

	STDMETHOD(get_ClockFrequencyMin) (THIS_ DWORD *dwClockFrequency) PURE;

	STDMETHOD(get_ClockFrequencyMax) (THIS_ DWORD *dwClockFrequency) PURE;

	STDMETHOD(get_ProductId) (THIS_ WORD *wProductId) PURE;

	STDMETHOD(get_SDKFileVersion) (THIS_ LONGLONG *llVersion) PURE;
	STDMETHOD(get_SDKProductVersion) (THIS_ LONGLONG *llVersion) PURE;

	STDMETHOD(get_HWShutterFix) (THIS_ BYTE *byteMode) PURE;

	//
	STDMETHOD(get_AlcWeight) (THIS_ BYTE *byteWeight) PURE;
	STDMETHOD(put_AlcWeight) (THIS_ BYTE *byteWeight) PURE;

	STDMETHOD(get_GainControlRangeMin) (THIS_ WORD *wMin) PURE;
	STDMETHOD(put_GainControlRangeMin) (THIS_ WORD wMin) PURE;

	STDMETHOD(get_GainControlRangeMax) (THIS_ WORD *wMax) PURE;
	STDMETHOD(put_GainControlRangeMax) (THIS_ WORD wMax) PURE;

	STDMETHOD(get_ShutterControlRangeClockMin) (THIS_ WORD *wMin) PURE;
	STDMETHOD(put_ShutterControlRangeClockMin) (THIS_ WORD wMin) PURE;

	STDMETHOD(get_ShutterControlRangeClockMax) (THIS_ WORD *wMax) PURE;
	STDMETHOD(put_ShutterControlRangeClockMax) (THIS_ WORD wMax) PURE;

	STDMETHOD(get_ShutterControlRangeLineMin) (THIS_ WORD *wMin) PURE;
	STDMETHOD(put_ShutterControlRangeLineMin) (THIS_ WORD wMin) PURE;

	STDMETHOD(get_ShutterControlRangeLineMax) (THIS_ WORD *wMax) PURE;
	STDMETHOD(put_ShutterControlRangeLineMax) (THIS_ WORD wMax) PURE;

	STDMETHOD(get_ScanMode) (THIS_ WORD *wMode) PURE;
	STDMETHOD(put_ScanMode) (THIS_ WORD wMode) PURE;

	STDMETHOD(get_CameraHandle) (THIS_ HANDLE *handle) PURE;

	//
	STDMETHOD(ResetToDefault)(THIS_ void) PURE;
};


//
// IStUSBCam2
//
DECLARE_INTERFACE_(IStUSBCam2, IStUSBCam)
{

	STDMETHOD(put_CameraId) (THIS_ int iCameraId ) PURE;

	STDMETHOD(get_CameraName) (THIS_ LPWSTR pstrName, int iSize ) PURE;
	STDMETHOD(put_CameraName) (THIS_ LPWSTR pstrName, int iSize ) PURE;

	STDMETHOD(get_DigitalGain) (THIS_ WORD* wGain ) PURE;
	STDMETHOD(put_DigitalGain) (THIS_ WORD wGain ) PURE;
};
//
// IStUSBCam3
//
DECLARE_INTERFACE_(IStUSBCam3, IStUSBCam2)
{
	STDMETHOD(get_CurrentFrameNumber) (THIS_ DWORD* dwFrameNum )  PURE;

	STDMETHOD(put_TriggerMode) (THIS_ DWORD dwTriggerMode )  PURE;
	STDMETHOD(get_TriggerMode) (THIS_ DWORD* pdwTriggerMode )  PURE;

	STDMETHOD(put_ExposureClock) (THIS_ DWORD dwExposureClock )  PURE;
	STDMETHOD(get_ExposureClock) (THIS_ DWORD* pdwExposureClock )  PURE;

	STDMETHOD(put_NoiseReduction) (THIS_ ULONG NoiseReduction )  PURE;
	STDMETHOD(get_NoiseReduction) (THIS_ ULONG* pNoiseReduction )  PURE;

	STDMETHOD(put_SoftTrigger) (THIS_ )  PURE;

	STDMETHOD(put_SoftSubTrigger) (THIS_ )  PURE;

	STDMETHOD(put_TriggerReadOut) (THIS_ )  PURE;

	STDMETHOD(put_ResetCounter) (THIS_ )  PURE;

	STDMETHOD(put_TriggerTiming) (THIS_ DWORD dwTriggerTimingType, DWORD dwValue )  PURE;
	STDMETHOD(get_TriggerTiming) (THIS_ DWORD dwTriggerTimingType, DWORD* pdwValue )  PURE;

	STDMETHOD(put_IOPinDirection) (THIS_ DWORD dwDirection )  PURE;
	STDMETHOD(get_IOPinDirection) (THIS_ DWORD* pdwDirection )  PURE;

	STDMETHOD(put_IOPinMode) (THIS_ BYTE bytePinNo, DWORD dwMode )  PURE;
	STDMETHOD(get_IOPinMode) (THIS_ BYTE bytePinNo, DWORD* pdwMode )  PURE;

	STDMETHOD(put_IOPinPolarity) (THIS_ DWORD dwPolarity )  PURE;
	STDMETHOD(get_IOPinPolarity) (THIS_ DWORD* pdwPolarity )  PURE;

	STDMETHOD(put_IOPinStatus) (THIS_ DWORD dwStatus )  PURE;
	STDMETHOD(get_IOPinStatus) (THIS_ DWORD* pdwStatus )  PURE;

	STDMETHOD(get_SwStatus) (THIS_ DWORD* pdwSwStatus )  PURE;

	STDMETHOD(put_LEDStatus) (THIS_ DWORD dwLEDStatus )  PURE;
	STDMETHOD(get_LEDStatus) (THIS_ DWORD* pdwLEDStatus )  PURE;

	STDMETHOD(put_SetEvent) (THIS_ DWORD EventType, HANDLE EventObject )  PURE;

	STDMETHOD(put_LoadReg) (THIS_ WCHAR* RegNo )  PURE;

	STDMETHOD(put_SaveReg) (THIS_ WCHAR* RegNo )  PURE;

	STDMETHOD(put_DeleteReg) (THIS_ WCHAR* RegNo )  PURE;

	STDMETHOD(put_DefaultReg) (THIS_ WCHAR* RegNo )  PURE;

	STDMETHOD(get_DefaultReg) (THIS_ WCHAR* RegNo, ULONG RegLen )  PURE;

	STDMETHOD(get_ParametersList) (THIS_ WCHAR* pRegList, DWORD RegListNum )  PURE;

	STDMETHOD(get_ParametersListNum) (THIS_ DWORD* pRegListNum )  PURE;

	STDMETHOD(get_HasFunction) (THIS_ DWORD dwFunc, BOOL* hasFunction )  PURE;

	STDMETHOD(get_DigitalGainInit) (THIS_ WORD* wGain )  PURE;
        
	STDMETHOD(put_AutoSubTrigger) (THIS_ DWORD bAutoSubTriggerMode, DWORD dwAutSubTriggerTime )  PURE;
        
	STDMETHOD(get_AutoSubTrigger) (THIS_ DWORD *pbAutoSubTriggerMode, DWORD *pdwAutoSubTriggerTime )  PURE;
};

#ifdef __cplusplus
}
#endif

#endif //_ISTUSBCAM_H

