VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CStCamera"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private m_hCamera As Long

Private m_IsOverlappedWindow As Boolean
Private m_hPreviewParentWnd As Long

'Original Image
Private m_wScanMode As Integer
Private m_dwOrgImageWidth As Long
Private m_dwOrgImageHeight As Long

'Display Mode
Private m_byteDisplayMode As Byte

'Aspect Mode
Private m_byteAspectMode As Byte

'Preview Window
Private m_lPreviewWindowOffsetX As Long
Private m_lPreviewWindowOffsetY As Long
Private m_dwPreviewWindowWidth As Long
Private m_dwPreviewWindowHeight As Long

'Preview Mask
Private m_dwPreviewMaskOffsetX As Long
Private m_dwPreviewMaskOffsetY As Long
Private m_dwPreviewMaskWidth As Long
Private m_dwPreviewMaskHeight As Long

'Preview Dest
Private m_dwPreviewDestOffsetX As Long
Private m_dwPreviewDestOffsetY As Long
Private m_dwPreviewDestWidth As Long
Private m_dwPreviewDestHeight As Long

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Class_Initialize()
    On Error GoTo ErrTrap
    
    'Original Image
    m_wScanMode = 0
    m_dwOrgImageWidth = 0
    m_dwOrgImageHeight = 0

    'Display Mode
    m_byteDisplayMode = STCAM_DISPLAY_MODE_GDI

    'Aspect Mode
    m_byteAspectMode = STCAM_ASPECT_MODE_FIXED

    'Preview Window
    m_lPreviewWindowOffsetX = 0
    m_lPreviewWindowOffsetY = 0
    m_dwPreviewWindowWidth = 0
    m_dwPreviewWindowHeight = 0
    
    'Preview Mask
    m_dwPreviewMaskOffsetX = 0
    m_dwPreviewMaskOffsetY = 0
    m_dwPreviewMaskWidth = 0
    m_dwPreviewMaskHeight = 0
    
    'Preview Dest
    m_dwPreviewDestOffsetX = 0
    m_dwPreviewDestOffsetY = 0
    m_dwPreviewDestWidth = 0
    m_dwPreviewDestHeight = 0
Exit Sub
ErrTrap:
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Class_Terminate()
    On Error GoTo ErrTrap

    If m_hCamera Then
        StCam_Close (m_hCamera)
    End If

Exit Sub
ErrTrap:
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function OpenCamera() As Long
    On Error GoTo ErrTrap
    
    'm_hCamera = StCam_Open(0)
    Dim lReval As Long
    
    Dim SelectCamera As frmSelectCamera
    Set SelectCamera = New frmSelectCamera
    m_hCamera = SelectCamera.GetCameraHandle()
    Unload SelectCamera
    Set SelectCamera = Nothing
    If m_hCamera = 0 Then
        GoTo ErrTrap
    End If
    
    
    lReval = mRefresh()
    OpenCamera = lReval
    
Exit Function
ErrTrap:
    OpenCamera = 0
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mRefresh() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    
    Do
        lReval = mGetImageSize()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lReval = mGetDisplayMode()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lReval = mGetAspectMode()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lReval = mGetPreviewMaskSize()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lReval = mGetPreviewDestSize()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    Loop While 0
    mRefresh = lReval

Exit Function
ErrTrap:
    mRefresh = lReval
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function CreateOverlappedWindow() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    
    Const clngFalse As Long = -1
    Do
        lReval = StCam_CreatePreviewWindowA(m_hCamera, "Preview", WS_OVERLAPPEDWINDOW Or WS_VISIBLE Or WS_HSCROLL Or WS_VSCROLL, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight, 0, 0, clngFalse)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        lReval = mGetPreviewWindowSize()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    Loop While 0
    
    m_IsOverlappedWindow = True
    m_hPreviewParentWnd = 0
    
    CreateOverlappedWindow = lReval
Exit Function
ErrTrap:
    CreateOverlappedWindow = lReval
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function CreateChildWindow(ByVal vhwnd As Long) As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    
    Const clngFalse As Long = 0
    Do
        lReval = StCam_CreatePreviewWindowA(m_hCamera, "Preview", WS_CHILDWINDOW Or WS_VISIBLE Or WS_HSCROLL Or WS_VSCROLL, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight, vhwnd, 0, clngFalse)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        lReval = mGetPreviewWindowSize()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    Loop While 0
    
    m_IsOverlappedWindow = False
    m_hPreviewParentWnd = vhwnd
    
    CreateChildWindow = lReval
Exit Function
ErrTrap:
    CreateChildWindow = lReval
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function StartTransfer() As Long
    On Error GoTo ErrTrap
    StartTransfer = StCam_StartTransfer(m_hCamera)
    
Exit Function
ErrTrap:
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function StopTransfer() As Long
    On Error GoTo ErrTrap
    StopTransfer = StCam_StopTransfer(m_hCamera)
    
Exit Function
ErrTrap:
End Function
'==============================================================================
'ImageSize
'==============================================================================
Private Function mGetImageSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    Dim dwSize As Long
    Dim dwLinePitch As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetPreviewDataSize(m_hCamera, dwSize, m_dwOrgImageWidth, m_dwOrgImageHeight, dwLinePitch)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetImageSize = lReval
Exit Function
ErrTrap:
    mGetImageSize = lReval
End Function
Property Get OrgImageWidth() As Long
    OrgImageWidth = m_dwOrgImageWidth
End Property
Property Get OrgImageHeight() As Long
    OrgImageHeight = m_dwOrgImageHeight
End Property
'==============================================================================
'Display Mode
'==============================================================================
Private Function mGetDisplayMode() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetDisplayMode(m_hCamera, m_byteDisplayMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetDisplayMode = lReval
Exit Function
ErrTrap:
    mGetDisplayMode = lReval
End Function
Private Function mSetDisplayMode() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_DestroyPreviewWindow(m_hCamera)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        lReval = StCam_SetDisplayMode(m_hCamera, m_byteDisplayMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        
        If m_IsOverlappedWindow Then
            Call CreateOverlappedWindow
        Else
            Call CreateChildWindow(m_hPreviewParentWnd)
        End If
    End If
    mSetDisplayMode = lReval
Exit Function
ErrTrap:
    mSetDisplayMode = lReval
End Function
Property Get DisplayMode() As Long
    DisplayMode = m_byteDisplayMode
End Property
Property Let DisplayMode(ByVal Value As Long)
    m_byteDisplayMode = Value
    Call mSetDisplayMode
End Property

'==============================================================================
'Aspect Mode
'==============================================================================
Private Function mGetAspectMode() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetAspectMode(m_hCamera, m_byteAspectMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetAspectMode = lReval
Exit Function
ErrTrap:
    mGetAspectMode = lReval
End Function
Private Function mSetAspectMode() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_SetAspectMode(m_hCamera, m_byteAspectMode)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
        lReval = mRefresh()
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mSetAspectMode = lReval
Exit Function
ErrTrap:
    mSetAspectMode = lReval
End Function
Property Get AspectMode() As Long
    AspectMode = m_byteAspectMode
End Property
Property Let AspectMode(ByVal Value As Long)
    m_byteAspectMode = Value
    Call mSetAspectMode
End Property

'==============================================================================
'Preview Window
'==============================================================================
Private Function mGetPreviewWindowSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetPreviewWindowSize(m_hCamera, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetPreviewWindowSize = lReval
Exit Function
ErrTrap:
    mGetPreviewWindowSize = lReval
End Function
Private Function mSetPreviewWindowSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_SetPreviewWindowSize(m_hCamera, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mSetPreviewWindowSize = lReval
Exit Function
ErrTrap:
    mSetPreviewWindowSize = lReval
End Function
Property Get PreviewWindowOffsetX() As Long
    PreviewWindowOffsetX = m_lPreviewWindowOffsetX
End Property
Property Let PreviewWindowOffsetX(ByVal Value As Long)
    m_lPreviewWindowOffsetX = Value
    Call mSetPreviewWindowSize
End Property
Property Get PreviewWindowOffsetY() As Long
    PreviewWindowOffsetY = m_lPreviewWindowOffsetY
End Property
Property Let PreviewWindowOffsetY(ByVal Value As Long)
    m_lPreviewWindowOffsetY = Value
    Call mSetPreviewWindowSize
End Property
Property Get PreviewWindowWidth() As Long
    PreviewWindowWidth = m_dwPreviewWindowWidth
End Property
Property Let PreviewWindowWidth(ByVal Value As Long)
    m_dwPreviewWindowWidth = Value
    Call mSetPreviewWindowSize
End Property
Property Get PreviewWindowHeight() As Long
    PreviewWindowHeight = m_dwPreviewWindowHeight
End Property
Property Let PreviewWindowHeight(ByVal Value As Long)
    m_dwPreviewWindowHeight = Value
    Call mSetPreviewWindowSize
End Property

'==============================================================================
'Preview Mask
'==============================================================================
Private Function mGetPreviewMaskSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetPreviewMaskSize(m_hCamera, m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetPreviewMaskSize = lReval
Exit Function
ErrTrap:
    mGetPreviewMaskSize = lReval
End Function
Private Function mSetPreviewMaskSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_SetPreviewMaskSize(m_hCamera, m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mSetPreviewMaskSize = lReval
Exit Function
ErrTrap:
    mSetPreviewMaskSize = lReval
End Function
Property Get PreviewMaskOffsetX() As Long
    PreviewMaskOffsetX = m_dwPreviewMaskOffsetX
End Property
Property Let PreviewMaskOffsetX(ByVal Value As Long)
    m_dwPreviewMaskOffsetX = Value
    Call mSetPreviewMaskSize
End Property
Property Get PreviewMaskOffsetY() As Long
    PreviewMaskOffsetY = m_dwPreviewMaskOffsetY
End Property
Property Let PreviewMaskOffsetY(ByVal Value As Long)
    m_dwPreviewMaskOffsetY = Value
    Call mSetPreviewMaskSize
End Property
Property Get PreviewMaskWidth() As Long
    PreviewMaskWidth = m_dwPreviewMaskWidth
End Property
Property Let PreviewMaskWidth(ByVal Value As Long)
    m_dwPreviewMaskWidth = Value
    Call mSetPreviewMaskSize
End Property
Property Get PreviewMaskHeight() As Long
    PreviewMaskHeight = m_dwPreviewMaskHeight
End Property
Property Let PreviewMaskHeight(ByVal Value As Long)
    m_dwPreviewMaskHeight = Value
    Call mSetPreviewMaskSize
End Property

'==============================================================================
'Preview Dest
'==============================================================================
Private Function mGetPreviewDestSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_GetPreviewDestSize(m_hCamera, m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, m_dwPreviewDestHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mGetPreviewDestSize = lReval
Exit Function
ErrTrap:
    mGetPreviewDestSize = lReval
End Function
Private Function mSetPreviewDestSize() As Long
    On Error GoTo ErrTrap
    Dim lReval As Long
    If 0 <> m_hCamera Then
        lReval = StCam_SetPreviewDestSize(m_hCamera, m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, m_dwPreviewDestHeight)
        If 0 = lReval Then
            GoTo ErrTrap
        End If
    End If
    mSetPreviewDestSize = lReval
Exit Function
ErrTrap:
    mSetPreviewDestSize = lReval
End Function
Property Get PreviewDestOffsetX() As Long
    PreviewDestOffsetX = m_dwPreviewDestOffsetX
End Property
Property Let PreviewDestOffsetX(ByVal Value As Long)
    m_dwPreviewDestOffsetX = Value
    Call mSetPreviewDestSize
End Property
Property Get PreviewDestOffsetY() As Long
    PreviewDestOffsetY = m_dwPreviewDestOffsetY
End Property
Property Let PreviewDestOffsetY(ByVal Value As Long)
    m_dwPreviewDestOffsetY = Value
    Call mSetPreviewDestSize
End Property
Property Get PreviewDestWidth() As Long
    PreviewDestWidth = m_dwPreviewDestWidth
End Property
Property Let PreviewDestWidth(ByVal Value As Long)
    m_dwPreviewDestWidth = Value
    Call mSetPreviewDestSize
End Property
Property Get PreviewDestHeight() As Long
    PreviewDestHeight = m_dwPreviewDestHeight
End Property
Property Let PreviewDestHeight(ByVal Value As Long)
    m_dwPreviewDestHeight = Value
    Call mSetPreviewDestSize
End Property



