VERSION 5.00
Begin VB.Form frmSelectCamera 
   BorderStyle     =   3  'Œ޲۸
   Caption         =   "SelectCamera"
   ClientHeight    =   1245
   ClientLeft      =   45
   ClientTop       =   435
   ClientWidth     =   5415
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   1245
   ScaleWidth      =   5415
   ShowInTaskbar   =   0   'False
   StartUpPosition =   3  'Windows ̊l
   Begin VB.ComboBox cmbCameraList 
      Height          =   300
      Left            =   360
      Style           =   2  'ۯ޳ ؽ
      TabIndex        =   2
      Top             =   240
      Width           =   4935
   End
   Begin VB.Timer timerSearch 
      Left            =   600
      Top             =   480
   End
   Begin VB.CommandButton cmdOKCancel 
      Caption         =   "&OK"
      Height          =   375
      Index           =   1
      Left            =   2880
      TabIndex        =   1
      Top             =   720
      Width           =   1215
   End
   Begin VB.CommandButton cmdOKCancel 
      Caption         =   "&Cancel"
      Height          =   375
      Index           =   0
      Left            =   4080
      TabIndex        =   0
      Top             =   720
      Width           =   1215
   End
End
Attribute VB_Name = "frmSelectCamera"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_CameraHandle As Long
Private m_CameraCount As Long

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function GetCameraHandle() As Long
    On Error GoTo ErrTrap
    
    Call mbCreateCameraList
    
    If m_CameraCount = 1 Then
        Call cmdOKCancel_Click(1)
    Else
        timerSearch.Interval = 500
        timerSearch.Enabled = (m_CameraCount = 0)
        Me.Show vbModal
    End If
    
    GetCameraHandle = m_CameraHandle
    
Exit Function
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.GetCameraHandle])"
    End If
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub cmdOKCancel_Click(Index As Integer)
    On Error GoTo ErrTrap
    
    With cmbCameraList
        If (Index <> 0) And (m_CameraCount <> 0) Then
            m_CameraHandle = .ItemData(.ListIndex)
        End If
    End With
    Hide
    
Exit Sub
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.cmdOKCancel_Click])"
    End If
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    On Error GoTo ErrTrap
    
    m_CameraHandle = 0
    m_CameraCount = 0
    cmdOKCancel(1).Enabled = False
        
Exit Sub
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.Form_Load])"
    End If
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    On Error GoTo ErrTrap
    
    timerSearch.Enabled = False
    Call mbCloseCameraList
    
Exit Sub
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.Form_Unload])"
    End If
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub timerSearch_Timer()
    On Error GoTo ErrTrap
    
    Call mbCreateCameraList
    timerSearch.Enabled = (m_CameraCount = 0)
    If m_CameraCount = 1 Then
        Call cmdOKCancel_Click(1)
    End If
    
Exit Sub
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.timerSearch_Timer])"
    End If
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbCreateCameraList() As Boolean
    On Error GoTo ErrTrap
    mbCreateCameraList = True
    
    Dim lCameraHandle As Long
    With cmbCameraList
        Do
            lCameraHandle = StCam_Open(0)
            If lCameraHandle = 0 Then
                Exit Do
            End If
            
            Dim strCameraName As String
            strCameraName = mstrGetCameraName(lCameraHandle)
            .AddItem (strCameraName)
            .ItemData(.ListCount - 1) = lCameraHandle
            m_CameraCount = m_CameraCount + 1
        Loop
        If 0 < m_CameraCount Then
            .ListIndex = 0
            cmdOKCancel(1).Enabled = True
            cmbCameraList.Enabled = True
        Else
            cmdOKCancel(1).Enabled = False
            cmbCameraList.Enabled = False
        End If
    End With

Exit Function
ErrTrap:
    mbCreateCameraList = False
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.mbCreateCameraList])"
    End If
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mstrGetCameraName(ByVal lCameraHandle As Long) As String
    On Error GoTo ErrTrap
    
    Dim lReval As Long
    Dim lCameraNo As Long
    Dim strCameraName As String
    
    mstrGetCameraName = ""
    
    strCameraName = Space(250)
    lReval = StCam_ReadCameraUserIDA(lCameraHandle, lCameraNo, strCameraName, Len(strCameraName))
    If 0 = lReval Then
        GoTo ErrTrap
    End If
    
    mstrGetCameraName = "[" & lCameraNo & "]" & strCameraName
    
Exit Function
ErrTrap:
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.mstrGetCameraName])"
    End If
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Function mbCloseCameraList() As Boolean
    On Error GoTo ErrTrap
    mbCloseCameraList = True
    
    With cmbCameraList
        Do While cmbCameraList.ListCount <> 0
            If m_CameraHandle <> .ItemData(0) Then
                Call StCam_Close(.ItemData(0))
            End If
            .RemoveItem (0)
        Loop
    End With
    
Exit Function
ErrTrap:
    mbCloseCameraList = False
    If Err.Number <> 0 Then
        MsgBox Err.Description & "(No." & Err.Number & "[frmSelectCamera.mbCloseCameraList])"
    End If
End Function

