VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "SampleErrMsg"
   ClientHeight    =   735
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   2070
   LinkTopic       =   "Form1"
   ScaleHeight     =   735
   ScaleWidth      =   2070
   StartUpPosition =   3
   Begin VB.CommandButton cmdPreview 
      Caption         =   "Preview"
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_hCamera As Long

Public m_lpPreviewWndProc As Long
Public m_bStatusTransfer As Boolean
Public m_bStatusAVIFile As Boolean
Public m_bStatusPreviewWnd As Boolean
Private m_hWnd As Long
Private m_bHooked As Boolean

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub cmdPreview_Click()
    Dim lngReval As Long

    Const clngTrue As Long = -1

    
    If m_bStatusPreviewWnd And m_bStatusTransfer Then
        'STOP
        lngReval = StCam_StopTransfer(m_hCamera)
        If lngReval = 0 Then
            Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
        End If
    Else
        'START
        If Not m_bStatusPreviewWnd Then
            lngReval = StCam_CreatePreviewWindowA( _
                m_hCamera, _
                "Preview", _
                WS_OVERLAPPEDWINDOW Or WS_VISIBLE, _
                0, 0, 0, 0, 0, 0, clngTrue)
                If lngReval = 0 Then
                    Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
                End If
        End If
        If Not m_bStatusTransfer Then
            lngReval = StCam_StartTransfer(m_hCamera)
            If lngReval = 0 Then
                Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
            End If
        End If
    End If

End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    Dim lngReval As Long
    m_hCamera = StCam_Open(0)
    If m_hCamera = 0 Then
        Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
    End If
    
    m_bStatusTransfer = False
    m_bStatusAVIFile = False
    m_bStatusPreviewWnd = False
    
    m_hWnd = Me.hWnd
    m_lpPreviewWndProc = SetWindowLong(m_hWnd, GWL_WNDPROC, AddressOf WindowProc)
    m_bHooked = True
    lngReval = StCam_SetReceiveMsgWindow(m_hCamera, m_hWnd)
    If lngReval = 0 Then
        Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
    End If
    Call StatusChanged
    
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Dim tmp As Long
    
    If m_bHooked Then
        tmp = SetWindowLong(m_hWnd, GWL_WNDPROC, m_lpPreviewWndProc)
        m_bHooked = False
    End If
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    If m_hCamera Then StCam_Close (m_hCamera)
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub StatusChanged()
    If m_bStatusPreviewWnd And m_bStatusTransfer Then
        cmdPreview.Caption = "STOP"
    Else
        cmdPreview.Caption = "START"
    End If
End Sub
