Attribute VB_Name = "mdlCommon"
Option Explicit

Public Declare Function CallWindowProc Lib "user32" Alias _
    "CallWindowProcA" (ByVal lpPrevWndFunc As Long, _
    ByVal hWnd As Long, ByVal Msg As Long, _
    ByVal wParam As Long, ByVal lParam As Long) As Long
 
Public Declare Function SetWindowLong Lib "user32" Alias _
    "SetWindowLongA" (ByVal hWnd As Long, _
    ByVal nIndex As Long, ByVal dwNewLong As Long) As Long
 

Public Declare Function FormatMessage Lib "kernel32" Alias _
    "FormatMessageA" (ByVal dwFlags As Long, _
    ByVal lpSource As Long, ByVal dwMessageId As Long, _
    ByVal dwLanguageId As Long, ByVal lpBuffer As String, _
    ByVal nSize As Long, Arguments As Long) As Long
Public Declare Function LoadLibraryEx Lib "kernel32" Alias _
    "LoadLibraryExA" (ByVal lpLibFileName As String, _
    ByVal hFile As Long, ByVal dwFlags As Long) As Long
Public Declare Function FreeLibrary Lib "kernel32" _
    (ByVal hLibModule As Long) As Long
    
Public Declare Function SetDIBitsToDevice Lib "gdi32" _
    (ByVal hdc As Long, ByVal x As Long, ByVal y As Long, _
    ByVal dx As Long, ByVal dy As Long, ByVal SrcX As Long, _
    ByVal SrcY As Long, ByVal Scan As Long, _
    ByVal NumScans As Long, Bits As Any, BitsInfo As BITMAPINFO, _
    ByVal wUsage As Long) As Long
Public Type RGBQUAD
        rgbBlue As Byte
        rgbGreen As Byte
        rgbRed As Byte
        rgbReserved As Byte
End Type
    
Public Type BITMAPINFOHEADER
        biSize As Long
        biWidth As Long
        biHeight As Long
        biPlanes As Integer
        biBitCount As Integer
        biCompression As Long
        biSizeImage As Long
        biXPelsPerMeter As Long
        biYPelsPerMeter As Long
        biClrUsed As Long
        biClrImportant As Long
End Type

Public Type BITMAPINFO
        bmiHeader As BITMAPINFOHEADER
        bmiColors(256) As RGBQUAD
End Type

    
    
Public Const FORMAT_MESSAGE_IGNORE_INSERTS = &H200
Public Const FORMAT_MESSAGE_FROM_SYSTEM = &H1000
Public Const FORMAT_MESSAGE_FROM_HMODULE = &H800

Public Const PROCESS_DEFAULT_LANGUAGE = &H400
Public Const DONT_RESOLVE_DLL_REFERENCES = &H1




Public Const GWL_WNDPROC = -4
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function WindowProc(ByVal hw As Long, ByVal uMsg As Long, ByVal wParam As Long, ByVal lParam As Long) As Long
    WindowProc = 0

    Select Case (uMsg)
        Case WM_STCAM_TRANSFER_START:
            frmMain.m_bStatusTransfer = True
            Call frmMain.StatusChanged
        Case WM_STCAM_TRANSFER_FINISH:
            frmMain.m_bStatusTransfer = False
            If lParam Then
                Call ShowErrorMsg(lParam)
            End If
            Call frmMain.StatusChanged
        Case WM_STCAM_AVI_FILE_START:
            frmMain.m_bStatusAVIFile = True
            Call frmMain.StatusChanged
        Case WM_STCAM_AVI_FILE_FINISH:
            frmMain.m_bStatusAVIFile = False
            If lParam Then
                Call ShowErrorMsg(lParam)
            End If
            Call frmMain.StatusChanged
        Case WM_STCAM_PREVIEW_WINDOW_CREATE:
            frmMain.m_bStatusPreviewWnd = True
            Call frmMain.StatusChanged
        Case WM_STCAM_PREVIEW_WINDOW_CLOSE:
            frmMain.m_bStatusPreviewWnd = False
            If lParam Then
                Call ShowErrorMsg(lParam)
            End If
            Call frmMain.StatusChanged
        Case Else
            WindowProc = CallWindowProc(frmMain.m_lpPreviewWndProc, hw, uMsg, wParam, lParam)
    End Select
  
End Function

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub ShowErrorMsg(ByVal dwErrorCode As Long)
    Dim strLastErrorMsgBuffer As String * 1024
    Dim strLastErrorMsg As String
    Dim lngReval As Long
    Dim hDll As Long
    Dim bFoundErrorMsg As Boolean
    
    bFoundErrorMsg = False
    lngReval = FormatMessage( _
        FORMAT_MESSAGE_FROM_SYSTEM Or _
        FORMAT_MESSAGE_IGNORE_INSERTS, _
        0, _
        dwErrorCode, _
        PROCESS_DEFAULT_LANGUAGE, _
        strLastErrorMsgBuffer, _
        Len(strLastErrorMsgBuffer), _
        0)
    If lngReval Then
        bFoundErrorMsg = True
    Else
        hDll = LoadLibraryEx("StCamMsg.dll", 0, DONT_RESOLVE_DLL_REFERENCES)
        If hDll Then
            lngReval = FormatMessage( _
               FORMAT_MESSAGE_FROM_HMODULE Or _
               FORMAT_MESSAGE_FROM_SYSTEM Or _
               FORMAT_MESSAGE_IGNORE_INSERTS, _
               hDll, _
               dwErrorCode, _
               PROCESS_DEFAULT_LANGUAGE, _
               strLastErrorMsgBuffer, _
               Len(strLastErrorMsgBuffer), _
               0)
            If lngReval Then
                bFoundErrorMsg = True
            End If
            FreeLibrary (hDll)
        End If
    End If
    
    If Not bFoundErrorMsg Then
        strLastErrorMsg = "Not Found The Error Message."
    Else
        strLastErrorMsg = _
            Left(strLastErrorMsgBuffer, _
                InStr(strLastErrorMsgBuffer, _
                vbNullChar) - 1)
    End If
    MsgBox strLastErrorMsg, vbOKOnly Or vbCritical, "Error Messsage"
    
End Sub
