VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "SampleSnap"
   ClientHeight    =   1335
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   2070
   LinkTopic       =   "Form1"
   ScaleHeight     =   1335
   ScaleWidth      =   2070
   StartUpPosition =   3  'Windows ̊l
   Begin VB.CommandButton cmdSnap 
      Caption         =   "Snap"
      Height          =   495
      Left            =   120
      TabIndex        =   1
      Top             =   720
      Width           =   1815
   End
   Begin VB.CommandButton cmdPreview 
      Caption         =   "Preview"
      Height          =   495
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   1815
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_hCamera As Long

Public m_lpPreviewWndProc As Long
Public m_bStatusTransfer As Boolean
Public m_bStatusAVIFile As Boolean
Public m_bStatusPreviewWnd As Boolean
Private m_hWnd As Long
Private m_bHooked As Boolean


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub cmdPreview_Click()
    Dim lngReval As Long

    Const clngTrue As Long = -1

    
    If m_bStatusPreviewWnd And m_bStatusTransfer Then
        'STOP
        lngReval = StCam_StopTransfer(m_hCamera)
        If lngReval = 0 Then
            Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
        End If
    Else
        'START
        If Not m_bStatusPreviewWnd Then
            lngReval = StCam_CreatePreviewWindowA( _
                m_hCamera, _
                "Preview", _
                WS_OVERLAPPEDWINDOW Or WS_VISIBLE, _
                0, 0, 0, 0, 0, 0, clngTrue)
                If lngReval = 0 Then
                    Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
                End If
        End If
        If Not m_bStatusTransfer Then
            lngReval = StCam_StartTransfer(m_hCamera)
            If lngReval = 0 Then
                Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
            End If
        End If
    End If

End Sub

Private Sub cmdSnap_Click()
    Dim dwLastErrorNo As Long
    Dim bReval As Boolean
    
    
    'GetPreviewDataSize
    Dim dwBufferSize As Long
    Dim dwWidth, dwHeight As Long
    Dim dwLinePitch As Long
    
    'Get Preview Pixel Format
    Dim dwPreviewPixelFormat As Long
    
    'Allocate Memory
    Dim pbyteImageBuffer() As Byte
    
    'Take Snap Shot
    Dim dwNumberOfByteTrans As Long
    Dim dwFrameNo As Long
    Dim dwMilliseconds As Long
    
    dwLastErrorNo = 0
    
    Do
        'GetPreviewDataSize
        bReval = StCam_GetPreviewDataSize(m_hCamera, dwBufferSize, dwWidth, dwHeight, dwLinePitch)
        If Not bReval Then
            dwLastErrorNo = StCam_GetLastError(m_hCamera)
            Exit Do
        End If
    
        'Get Preview Pixel Format
        bReval = StCam_GetPreviewPixelFormat( _
            m_hCamera, dwPreviewPixelFormat)
        If Not bReval Then
            dwLastErrorNo = StCam_GetLastError(m_hCamera)
            Exit Do
        End If
            
        'Allocate Memory
        ReDim pbyteImageBuffer(dwBufferSize)
            
        'Take Snap Shot
        dwMilliseconds = 1000
        bReval = StCam_TakePreviewSnapShot( _
            m_hCamera, pbyteImageBuffer(0), _
            dwBufferSize, dwNumberOfByteTrans, dwFrameNo, _
            dwMilliseconds)
        If Not bReval Then
            dwLastErrorNo = StCam_GetLastError(m_hCamera)
            Exit Do
        End If
        
        'Display Snap Image
        frmSnap.Show vbModeless, Me
        bReval = frmSnap.bUpdateSnapShot( _
            m_hCamera, dwWidth, dwHeight, _
            dwPreviewPixelFormat, pbyteImageBuffer, dwBufferSize, _
            dwLastErrorNo)
            
        Exit Do
    Loop

    'Show Error Message
    If Not bReval Then
        Call ShowErrorMsg(dwLastErrorNo)
    End If

End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    Dim lngReval As Long
    m_hCamera = StCam_Open(0)
    If m_hCamera = 0 Then
        Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
    End If
    
    m_bStatusTransfer = False
    m_bStatusAVIFile = False
    m_bStatusPreviewWnd = False
    
    m_hWnd = Me.hWnd
    m_lpPreviewWndProc = SetWindowLong(m_hWnd, GWL_WNDPROC, AddressOf WindowProc)
    m_bHooked = True
    lngReval = StCam_SetReceiveMsgWindow(m_hCamera, m_hWnd)
    If lngReval = 0 Then
        Call ShowErrorMsg(StCam_GetLastError(m_hCamera))
    End If
    Call StatusChanged
    
    
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    Dim tmp As Long
    
    If m_bHooked Then
        tmp = SetWindowLong(m_hWnd, GWL_WNDPROC, m_lpPreviewWndProc)
        m_bHooked = False
    End If
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Unload(Cancel As Integer)
    If m_hCamera Then StCam_Close (m_hCamera)
End Sub

'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Sub StatusChanged()
    If m_bStatusPreviewWnd And m_bStatusTransfer Then
        cmdPreview.Caption = "STOP"
    Else
        cmdPreview.Caption = "START"
    End If
End Sub
