VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "comdlg32.ocx"
Begin VB.Form frmSnap 
   BorderStyle     =   1  'Œ()
   Caption         =   "Snap Shot"
   ClientHeight    =   3195
   ClientLeft      =   150
   ClientTop       =   795
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3195
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows ̊l
   Begin MSComDlg.CommonDialog cdSave 
      Left            =   720
      Top             =   1800
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin VB.Menu mnuPopup 
      Caption         =   "Popup"
      Index           =   0
      Begin VB.Menu mnuSave 
         Caption         =   "Save"
         Index           =   0
      End
   End
End
Attribute VB_Name = "frmSnap"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private m_pBitmapInfoHeader As BITMAPINFO
Private m_pbyteImageBuffer() As Byte
Private m_dwWidth As Long
Private m_dwHeight As Long
Private m_dwPreviewPixelFormat As Long
Private m_dwImageBufferSize As Long
Private m_bNotSavedFg As Boolean
Private m_bImageDataExist As Boolean
Private m_hCamera As Long


'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Load()
    m_dwWidth = 0
    m_dwHeight = 0
    m_dwPreviewPixelFormat = 0
    m_bNotSavedFg = False
    m_hCamera = 0
    m_dwImageBufferSize = 0
    m_bImageDataExist = False
    mnuPopup(0).Visible = False
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub bSaveImage()
    On Error GoTo ErrTrap
    Dim lngReval As Long
    
    If m_bImageDataExist Then
        cdSave.CancelError = True
        cdSave.DefaultExt = "*.bmp"
        cdSave.Filter = "Bitmap(*.bmp)|*.bmp|" & _
            "TIFF(*.tif)|*.tif|JPEG(*.jpg)|*.jpg|" & _
            "PNG(*.png)|*.png|All Files(*.*)|*.*||"
        cdSave.ShowSave

        lngReval = StCam_SaveImageA( _
            m_hCamera, m_dwWidth, m_dwHeight, _
            m_dwPreviewPixelFormat, _
            m_pbyteImageBuffer(0), _
            cdSave.FileName, 0)
        m_bNotSavedFg = False
    End If
Exit Sub
ErrTrap:

End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Public Function bUpdateSnapShot(ByVal hCamera As Long, _
    ByVal dwWidth As Long, ByVal dwHeight As Long, _
    ByVal dwPreviewPixelFormat As Long, _
    ByRef pbyteImageBuffer() As Byte, ByVal dwBufferSize As Long, _
    ByRef pdwLastErrorNo As Long) As Boolean
    
    Dim lngPos As Long

    bUpdateSnapShot = True
    
    m_dwWidth = dwWidth
    m_dwHeight = dwHeight
    m_dwPreviewPixelFormat = dwPreviewPixelFormat
    m_bNotSavedFg = False
    m_hCamera = hCamera
    m_bImageDataExist = False
    
    'Create Buffer
    m_dwImageBufferSize = dwBufferSize
    ReDim m_pbyteImageBuffer(m_dwImageBufferSize)
    
    'Copy Image Data
    For lngPos = 0 To m_dwImageBufferSize - 1
        m_pbyteImageBuffer(lngPos) = pbyteImageBuffer(lngPos)
    Next lngPos

    'BitmapInfoHeader
    With m_pBitmapInfoHeader.bmiHeader
        .biSize = 40
        .biWidth = m_dwWidth
        .biHeight = -m_dwHeight
        .biPlanes = 1
        .biCompression = 0
        .biSizeImage = m_dwImageBufferSize
        .biXPelsPerMeter = 0
        .biYPelsPerMeter = 0
        Select Case (m_dwPreviewPixelFormat)
            Case STCAM_PIXEL_FORMAT_08_MONO_OR_RAW:
                .biBitCount = 8
                .biClrUsed = 256
                .biClrImportant = 256
            Case STCAM_PIXEL_FORMAT_24_BGR:
                .biBitCount = 24
                .biClrUsed = 0
                .biClrImportant = 0
            Case STCAM_PIXEL_FORMAT_32_BGR:
                .biBitCount = 32
                .biClrUsed = 0
                .biClrImportant = 0
        End Select
    End With 'm_pBitmapInfoHeader.bmiHeader
    If m_dwPreviewPixelFormat = STCAM_PIXEL_FORMAT_08_MONO_OR_RAW Then
        For lngPos = 0 To 255
            With m_pBitmapInfoHeader.bmiColors(lngPos)
                .rgbBlue = lngPos
                .rgbGreen = lngPos
                .rgbRed = lngPos
            End With 'm_pBitmapInfoHeader.bmiColors(lngPos)
        Next lngPos
    End If
    
    
    m_bNotSavedFg = True
    m_bImageDataExist = True
    
    'Window Size
    With Me
        .BorderStyle = vbFixedDialog
        .ScaleMode = vbTwips
        .Width = m_dwWidth * Screen.TwipsPerPixelX _
            + .Width - .ScaleWidth
        .Height = m_dwHeight * Screen.TwipsPerPixelY _
            + .Height - .ScaleHeight
        .Refresh
    End With 'Me
    
End Function
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_Paint()

    Dim lngReval As Long
    
    If m_bImageDataExist Then
        lngReval = SetDIBitsToDevice( _
            Me.hDC, _
            0, 0, m_dwWidth, m_dwHeight, _
            0, 0, 0, m_dwHeight, _
            m_pbyteImageBuffer(0), _
            m_pBitmapInfoHeader, 0)
    End If

End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If m_bNotSavedFg Then
        If vbYes = MsgBox( _
            "Do You Want To Save The Image?", _
            vbYesNo Or vbQuestion, _
            "Save Image") Then
            Call bSaveImage
        End If
    End If
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------

Private Sub mnuSave_Click(Index As Integer)
    Call bSaveImage
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = vbRightButton Then
        Me.PopupMenu mnuPopup(0)
    End If
End Sub
'------------------------------------------------------------------------------
'
'------------------------------------------------------------------------------
Private Sub Form_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = 93 Then
        Me.PopupMenu mnuPopup(0)
    End If
End Sub
