// CameraSelectDlg.cpp : 
//

#include "stdafx.h"
#include "PreviewSize.h"
#include "CameraSelectDlg.h"
#include <dbt.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCameraSelectDlg 


CCameraSelectDlg::CCameraSelectDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCameraSelectDlg::IDD, pParent),
	m_hCamera(NULL)
{
	//{{AFX_DATA_INIT(CCameraSelectDlg)
		// 
	//}}AFX_DATA_INIT
}


void CCameraSelectDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CCameraSelectDlg)
		// 
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CCameraSelectDlg, CDialog)
	//{{AFX_MSG_MAP(CCameraSelectDlg)
	//}}AFX_MSG_MAP
	ON_WM_DEVICECHANGE()
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCameraSelectDlg 

BOOL CCameraSelectDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	GetCameraInfoList();

	return TRUE;
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::OnDeviceChange(UINT nEventType, DWORD dwData)
{
	switch(nEventType)
	{
		case(DBT_DEVNODES_CHANGED):
			GetCameraInfoList();
			break;
	}
	return(TRUE);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::GetCameraInfoList()
{
	BOOL	bReval = TRUE;

	CloseAllCameraExceptChoiced();
	OpenAllCamera();
	mUpdateDisplay();

	if(1 == m_aCamera.GetSize())
	{
		m_hCamera = m_aCamera.GetAt(0);
		EndDialog(IDOK);
	}

	return(TRUE);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CCameraSelectDlg::mUpdateDisplay()
{
	CComboBox objComboBox;
	objComboBox.Attach(GetDlgItem(IDC_COMBO_CAMERA_LIST)->GetSafeHwnd());

	INT iListIndex = objComboBox.GetCurSel();
	BOOL bCameraExist = 0 < m_aCamera.GetSize();
	
	//Clear Combo Box
	while(objComboBox.GetCount())
	{
		objComboBox.DeleteString(0);
	}
	
	//Add Item To Combo Box
	if(0 < m_aCamera.GetSize())
	{
		for(INT i = 0; i < m_aCamera.GetSize(); i++)
		{
			DWORD	dwCameraID;
			TCHAR	szCameraID[MAX_PATH];
			memset(szCameraID, 0, sizeof(TCHAR) * MAX_PATH);
			
			HANDLE hCamera = m_aCamera.GetAt(i);
			BOOL bReval = StCam_ReadCameraUserID(hCamera, &dwCameraID, szCameraID, MAX_PATH);
			if(bReval)
			{
				objComboBox.AddString(szCameraID);
			}
		}
		if(
			(iListIndex < 0) ||
			(objComboBox.GetCount() <= iListIndex)
		)
		{
			iListIndex = 0;
		}
		
		objComboBox.SetCurSel(iListIndex);
	}

	objComboBox.EnableWindow(bCameraExist);
	::EnableWindow(GetDlgItem(IDOK)->GetSafeHwnd(), bCameraExist);

	objComboBox.Detach();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CCameraSelectDlg::OnOK() 
{
	CComboBox objComboBox;
	objComboBox.Attach(GetDlgItem(IDC_COMBO_CAMERA_LIST)->GetSafeHwnd());
	int nCurSel = objComboBox.GetCurSel();
	if(0 <= nCurSel)
	{
		m_hCamera = m_aCamera.GetAt(objComboBox.GetCurSel());
	}
	objComboBox.Detach();

	CDialog::OnOK();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CCameraSelectDlg::DestroyWindow() 
{
	CloseAllCameraExceptChoiced();
	return CDialog::DestroyWindow();
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL	CCameraSelectDlg::OpenAllCamera()
{
	BOOL	bReval = TRUE;

	do{
		HANDLE hCamera = StCam_Open(0);
		if(NULL == hCamera)
		{
			break;
		}
		m_aCamera.Add(hCamera);
	}while(1);
	

	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL	CCameraSelectDlg::CloseAllCameraExceptChoiced()
{
	while(m_aCamera.GetSize())
	{
		HANDLE hCamera = m_aCamera.GetAt(0);
		if(m_hCamera != hCamera)
		{
			StCam_Close(hCamera);
		}
		m_aCamera.RemoveAt(0);
	}
	return(TRUE);
}
