// StCamera.cpp: CStCamera 
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "PreviewSize.h"
#include "StCamera.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// 
//////////////////////////////////////////////////////////////////////

CStCamera::CStCamera(HANDLE hCamera):
	m_hCamera(hCamera),
	m_IsOverlappedWindow(FALSE), m_hPreviewParentWnd(NULL), 
	m_wScanMode(0), m_dwOrgImageOffsetX(0), m_dwOrgImageOffsetY(0), m_dwOrgImageWidth(0), m_dwOrgImageHeight(0), //Original Image
	m_byteDisplayMode(0), //Display Mode
	m_byteAspectMode(0), //Aspect Mode
	m_lPreviewWindowOffsetX(0), m_lPreviewWindowOffsetY(0), m_dwPreviewWindowWidth(0), m_dwPreviewWindowHeight(0), //Preview Window
	m_dwPreviewMaskOffsetX(0), m_dwPreviewMaskOffsetY(0), m_dwPreviewMaskWidth(0), m_dwPreviewMaskHeight(0), //Preview Mask
	m_dwPreviewDestOffsetX(0), m_dwPreviewDestOffsetY(0), m_dwPreviewDestWidth(0), m_dwPreviewDestHeight(0) //Preview Dest
{
	mRefresh();
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
CStCamera::~CStCamera()
{
	if(NULL != m_hCamera)
	{
		StCam_Close(m_hCamera);
		m_hCamera = NULL;
	}
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::CreateOverlappedWindow()
{
    BOOL bReval = TRUE;
    
    do{
        bReval = StCam_CreatePreviewWindow(m_hCamera, TEXT("Preview"), WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight, 0, 0, TRUE);
        if(!bReval) break;

        bReval = mGetPreviewWindowSize();
        if(!bReval) break;

		m_IsOverlappedWindow = TRUE;
	}while(0);
    
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::CreateChildWindow(HWND hParentWnd)
{
    BOOL bReval = TRUE;
    
    do{
        bReval = StCam_CreatePreviewWindow(m_hCamera, TEXT("Preview"), WS_CHILDWINDOW | WS_VISIBLE | WS_HSCROLL | WS_VSCROLL, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight, hParentWnd, 0, FALSE);
        if(!bReval) break;

        bReval = mGetPreviewWindowSize();
        if(!bReval) break;

		m_IsOverlappedWindow = FALSE;
		m_hPreviewParentWnd = hParentWnd;
	}while(0);
    
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mRefresh()
{
	BOOL bReval = TRUE;

	do{
		bReval = mGetImageSize();
		if(!bReval) break;

		bReval = mGetDisplayMode();
		if(!bReval) break;

		bReval = mGetAspectMode();
		if(!bReval) break;
		
		bReval = mGetPreviewMaskSize();
		if(!bReval) break;
		
		bReval = mGetPreviewDestSize();
		if(!bReval) break;

	}while(0);

	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetImageSize()
{
	DWORD dwReserved = 0;
	return(StCam_GetImageSize(m_hCamera, &dwReserved, &m_wScanMode, &m_dwOrgImageOffsetX, &m_dwOrgImageOffsetY, &m_dwOrgImageWidth, &m_dwOrgImageHeight));
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetDisplayMode()
{
	return(StCam_GetDisplayMode(m_hCamera, &m_byteDisplayMode));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mSetDisplayMode()
{
	BOOL bReval = TRUE;

	do{
        bReval = StCam_DestroyPreviewWindow(m_hCamera);
        if(!bReval) break;
        
        bReval = StCam_SetDisplayMode(m_hCamera, m_byteDisplayMode);
        if(!bReval) break;
        
        if(m_IsOverlappedWindow)
		{
            bReval = CreateOverlappedWindow();
		}
		else
		{
            bReval = CreateChildWindow(m_hPreviewParentWnd);
        }
	}while(0);
	return(bReval);
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetAspectMode()
{
	return(StCam_GetAspectMode(m_hCamera, &m_byteAspectMode));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mSetAspectMode()
{
	return(StCam_SetAspectMode(m_hCamera, m_byteAspectMode));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetPreviewWindowSize()
{
	return(StCam_GetPreviewWindowSize(m_hCamera, &m_lPreviewWindowOffsetX, &m_lPreviewWindowOffsetY, &m_dwPreviewWindowWidth, &m_dwPreviewWindowHeight));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mSetPreviewWindowSize()
{
	return(StCam_SetPreviewWindowSize(m_hCamera, m_lPreviewWindowOffsetX, m_lPreviewWindowOffsetY, m_dwPreviewWindowWidth, m_dwPreviewWindowHeight));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetPreviewMaskSize()
{
	return(StCam_GetPreviewMaskSize(m_hCamera, &m_dwPreviewMaskOffsetX, &m_dwPreviewMaskOffsetY, &m_dwPreviewMaskWidth, &m_dwPreviewMaskHeight));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mSetPreviewMaskSize()
{
	return(StCam_SetPreviewMaskSize(m_hCamera, m_dwPreviewMaskOffsetX, m_dwPreviewMaskOffsetY, m_dwPreviewMaskWidth, m_dwPreviewMaskHeight));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mGetPreviewDestSize()
{
	return(StCam_GetPreviewDestSize(m_hCamera, &m_dwPreviewDestOffsetX, &m_dwPreviewDestOffsetY, &m_dwPreviewDestWidth, &m_dwPreviewDestHeight));
}
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
BOOL CStCamera::mSetPreviewDestSize()
{
	return(StCam_SetPreviewDestSize(m_hCamera, m_dwPreviewDestOffsetX, m_dwPreviewDestOffsetY, m_dwPreviewDestWidth, m_dwPreviewDestHeight));
}
