// SampleCallbackDlg.cpp
//

#include "stdafx.h"
#include "SampleCallback.h"
#include "SampleCallbackDlg.h"
#include <sys\timeb.h>
#include <time.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleCallbackDlg

CSampleCallbackDlg::CSampleCallbackDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSampleCallbackDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSampleCallbackDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

}

void CSampleCallbackDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleCallbackDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSampleCallbackDlg, CDialog)
	//{{AFX_MSG_MAP(CSampleCallbackDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_PREVIEW, OnBtnPreview)
	ON_BN_CLICKED(IDC_BTN_SNAPSHOT, OnBtnSnapshot)
	ON_BN_CLICKED(IDC_BTN_MOVIE, OnBtnMovie)
	ON_BN_CLICKED(IDC_BTN_FPS, OnBtnFps)
	//}}AFX_MSG_MAP
	ON_MESSAGE( WM_STCAM_TRANSFER_START, OnTransferStart )
	ON_MESSAGE( WM_STCAM_TRANSFER_FINISH, OnTransferFinish )
	ON_MESSAGE( WM_STCAM_AVI_FILE_START, OnAVIFileStart )
	ON_MESSAGE( WM_STCAM_AVI_FILE_FINISH, OnAVIFileFinish )
	ON_MESSAGE( WM_STCAM_PREVIEW_WINDOW_CREATE, OnPreviewWindowCreate)
	ON_MESSAGE( WM_STCAM_PREVIEW_WINDOW_CLOSE, OnPreviewWindowClose)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleCallbackDlg

BOOL CSampleCallbackDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);
	
	m_hCamera = StCam_Open(0);
	if(!m_hCamera)	ShowErrorMsg(StCam_GetLastError(m_hCamera));
	m_bStatusTransfer = FALSE;
	m_bStatusAVIFile = FALSE;
	m_bStatusPreviewWnd = FALSE;
	m_dwGDICallbackNoFPS = 0;
	m_fCurrentFPS = 0.0f;
	if(!StCam_SetReceiveMsgWindow(m_hCamera, this->m_hWnd))
		ShowErrorMsg(StCam_GetLastError(m_hCamera));
	StatusChanged();
	m_pdlgSnapDisplayDlg = new CSnapDisplayDlg;
	m_pdlgSnapDisplayDlg->Create(IDD_SNAPDISPLAY_DIALOG);
	return TRUE;
}

void CSampleCallbackDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CSampleCallbackDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CSampleCallbackDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSampleCallbackDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	if(m_pdlgSnapDisplayDlg)	delete m_pdlgSnapDisplayDlg;
	if(m_hCamera) StCam_Close(m_hCamera);
	
}

void CSampleCallbackDlg::OnBtnPreview() 
{
	if(m_bStatusPreviewWnd && m_bStatusTransfer)
	{
		//STOP
		if(!StCam_StopTransfer(m_hCamera))
			ShowErrorMsg(StCam_GetLastError(m_hCamera));
	}
	else
	{
		//START
		if(!m_bStatusPreviewWnd)
			if(!StCam_CreatePreviewWindow(m_hCamera,TEXT("Preview"),WS_OVERLAPPEDWINDOW | WS_VISIBLE,0,0,0,0,NULL,NULL,TRUE))
				ShowErrorMsg(StCam_GetLastError(m_hCamera));
		if(!m_bStatusTransfer)
			if(!StCam_StartTransfer(m_hCamera))
				ShowErrorMsg(StCam_GetLastError(m_hCamera));
	}	
}
afx_msg LRESULT CSampleCallbackDlg::OnTransferStart(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusTransfer = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleCallbackDlg::OnTransferFinish(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusTransfer = FALSE;
	if(lParam) ShowErrorMsg((DWORD)lParam);
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleCallbackDlg::OnAVIFileStart(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusAVIFile = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleCallbackDlg::OnAVIFileFinish(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusAVIFile = FALSE;
	if(lParam) ShowErrorMsg((DWORD)lParam);
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleCallbackDlg::OnPreviewWindowCreate(WPARAM wParam, LPARAM lParam)
{
	m_bStatusPreviewWnd = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleCallbackDlg::OnPreviewWindowClose(WPARAM wParam, LPARAM lParam)
{
	m_bStatusPreviewWnd = FALSE;
	if(lParam) ShowErrorMsg((DWORD)lParam);
	StatusChanged();
	return(0);
}

void CSampleCallbackDlg::StatusChanged(void)
{
	TCHAR	szCaption[1024];
	if(m_bStatusPreviewWnd && m_bStatusTransfer)
		_tcscpy(szCaption,TEXT("STOP"));
	else
		_tcscpy(szCaption,TEXT("START"));
	::SetWindowText(GetDlgItem(IDC_BTN_PREVIEW)->m_hWnd,szCaption);

	::EnableWindow(GetDlgItem(IDC_BTN_MOVIE)->m_hWnd, !m_bStatusAVIFile);

	if(m_dwGDICallbackNoFPS)
		_tcscpy(szCaption,TEXT("Erase FPS"));
	else
		_tcscpy(szCaption,TEXT("Show FPS"));
	::SetWindowText(GetDlgItem(IDC_BTN_FPS)->m_hWnd,szCaption);
}

//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
void CSampleCallbackDlg::ShowErrorMsg(DWORD dwErrorCode)
{
	HLOCAL hlocal = NULL;

	BOOL bFoundErrMsg = FormatMessage(
		FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ALLOCATE_BUFFER,
		NULL,
		dwErrorCode,
		MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
		(LPTSTR)&hlocal,
		0,
		NULL);

	if(!bFoundErrMsg)
	{
		//Check Inside StCamMsg.dll
		HMODULE	hDll = LoadLibraryEx(TEXT("StCamMsg.dll"), NULL, DONT_RESOLVE_DLL_REFERENCES);

		if(hDll != NULL)
		{
			bFoundErrMsg = FormatMessage(
					FORMAT_MESSAGE_FROM_HMODULE | FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_ALLOCATE_BUFFER,
					hDll,
					dwErrorCode,
					MAKELANGID(LANG_NEUTRAL,SUBLANG_DEFAULT),
					(LPTSTR)&hlocal,
					0,
					NULL);
			FreeLibrary(hDll);
		}
	}
	
	if(bFoundErrMsg)
	{
		MessageBox((LPCTSTR)hlocal,TEXT("Error Message"),MB_OK | MB_TASKMODAL | MB_ICONEXCLAMATION);
		LocalFree(hlocal);
	}
	else
	{
		TCHAR szErrorMsg[1024];
		_stprintf(szErrorMsg,TEXT("Error No:%X (Not Found The Error Message.)"),dwErrorCode);
		MessageBox(szErrorMsg,TEXT("Error Message"),MB_OK | MB_TASKMODAL | MB_ICONEXCLAMATION);
	}
}
void CSampleCallbackDlg::OnBtnSnapshot() 
{
	BOOL bReval = TRUE;
	DWORD	dwLastErrorNo = NO_ERROR;
	PBYTE	pbyteImageBuffer = NULL;
	do
	{
		//Get Image Size
		DWORD	dwReserved;
		DWORD	dwOffsetX,dwOffsetY;
		DWORD	dwWidth,dwHeight;
		WORD	wScanMode;
		bReval = StCam_GetImageSize(m_hCamera, &dwReserved, &wScanMode,
				&dwOffsetX, &dwOffsetY, &dwWidth, &dwHeight);
		if(!bReval)
		{
			dwLastErrorNo = StCam_GetLastError(m_hCamera);
			break;
		}

		//Get Preview Pixel Format
		DWORD	dwPreviewPixelFormat;
		bReval = StCam_GetPreviewPixelFormat(m_hCamera, &dwPreviewPixelFormat);
		if(!bReval)
		{
			dwLastErrorNo = StCam_GetLastError(m_hCamera);
			break;
		}

		//Allocate Memory
		DWORD	dwBufferSize = dwWidth * dwHeight;
		if(dwPreviewPixelFormat == STCAM_PIXEL_FORMAT_24_BGR)		dwBufferSize *= 3;
		else if(dwPreviewPixelFormat == STCAM_PIXEL_FORMAT_32_BGR)	dwBufferSize *= 4;
		pbyteImageBuffer = (PBYTE) new BYTE[dwBufferSize];
		if(!pbyteImageBuffer)
		{
			bReval = FALSE;
			dwLastErrorNo = ERROR_NOT_ENOUGH_MEMORY;
			break;
		}

		//Take Snap Shot
		DWORD	dwNumberOfByteTrans,dwFrameNo;
		DWORD	dwMilliseconds = 1000;
		bReval = StCam_TakePreviewSnapShot(m_hCamera,pbyteImageBuffer, dwBufferSize, &dwNumberOfByteTrans, &dwFrameNo, dwMilliseconds);
		if(!bReval)
		{
			dwLastErrorNo = StCam_GetLastError(m_hCamera);
			break;
		}

		//Display Snap Image
		bReval = m_pdlgSnapDisplayDlg->bUpdateSnapShot(m_hCamera,dwWidth,dwHeight,dwPreviewPixelFormat,pbyteImageBuffer,&dwLastErrorNo);
	}while(0);

	//Delete Buffer
	if(pbyteImageBuffer)
	{
		delete[] pbyteImageBuffer;
	}

	//Show Error Message
	if(!bReval)
	{
		ShowErrorMsg(dwLastErrorNo);
	}
}

void CSampleCallbackDlg::OnBtnMovie() 
{
	BOOL bReval = TRUE;

	CFileDialog *fdlgSave = new CFileDialog(
		FALSE,
		TEXT(".avi"),
		NULL,
		OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
		TEXT("AVI(*.avi)|*.avi|")
		TEXT("All Files(*.*)|*.*||"),
		GetParent());
	
	if(IDOK == fdlgSave->DoModal())
	{
		bReval = StCam_SaveAVI(
					m_hCamera,
					fdlgSave->GetPathName(),
					STCAM_AVI_COMPRESSOR_UNCOMPRESSED,
					300,
					NULL);
		if(!bReval)
		{
			ShowErrorMsg(StCam_GetLastError(m_hCamera));
		}
	}
}
VOID __stdcall CSampleCallbackDlg::GDICallbackFPS(HDC hDc,DWORD dwWidth,DWORD dwHeight,DWORD dwFrameNo,LPVOID lpContext, LPVOID lpReserved)
{
	const int		ciFrameCount = 100;
	static int		siTimePos = 0;
	static BOOL		bEnoughDataExist = FALSE;
	static struct _timeb sTime[ciFrameCount];
	CSampleCallbackDlg*	pdlgSampleCallbackDlg = (CSampleCallbackDlg*)lpContext;

	//Get Current System Time
	_ftime(&sTime[siTimePos]);

	int iLastTimePos = siTimePos++;
	if(siTimePos >= ciFrameCount)
	{
		bEnoughDataExist = TRUE;
		siTimePos = 0;
	}

	TCHAR szFPS[256];
	if(bEnoughDataExist)
	{
		DWORD dwIntervalMS = sTime[iLastTimePos].time - sTime[siTimePos].time;
		dwIntervalMS *= 1000;
		dwIntervalMS += sTime[iLastTimePos].millitm;
		dwIntervalMS -= sTime[siTimePos].millitm; 
		FLOAT fFPS = 1000 * (ciFrameCount - 1) / (FLOAT)dwIntervalMS;

		_stprintf(szFPS,TEXT("FPS:%.1f"),fFPS);
		pdlgSampleCallbackDlg->m_fCurrentFPS = fFPS;
	}
	else
	{
		_tcscpy(szFPS,TEXT("FPS:---"));
	}
	UINT uiOldMode = SetTextAlign(hDc,TA_RIGHT | TA_TOP);
	TextOut(hDc,dwWidth - 1,0,szFPS,_tcslen(szFPS));
	uiOldMode = SetTextAlign(hDc,uiOldMode);
}

void CSampleCallbackDlg::OnBtnFps() 
{
	BOOL bReval = TRUE;
	if(m_dwGDICallbackNoFPS)
	{
		bReval = StCam_RemovePreviewGDICallback(
			m_hCamera,
			m_dwGDICallbackNoFPS);
		m_dwGDICallbackNoFPS = 0;
	}
	else
	{
		bReval = StCam_AddPreviewGDICallback(
			m_hCamera,
			CSampleCallbackDlg::GDICallbackFPS,
			(LPVOID)this,
			&m_dwGDICallbackNoFPS);
	}
	if(!bReval)
	{
		ShowErrorMsg(StCam_GetLastError(m_hCamera));
	}
	StatusChanged();
}
