// SampleRcvMsgDlg.cpp
//

#include "stdafx.h"
#include "SampleRcvMsg.h"
#include "SampleRcvMsgDlg.h"
#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleRcvMsgDlg

CSampleRcvMsgDlg::CSampleRcvMsgDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSampleRcvMsgDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSampleRcvMsgDlg)
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);

}

void CSampleRcvMsgDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSampleRcvMsgDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSampleRcvMsgDlg, CDialog)
	//{{AFX_MSG_MAP(CSampleRcvMsgDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_PREVIEW, OnBtnPreview)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_STCAM_TRANSFER_START,OnTransferStart)
	ON_MESSAGE(WM_STCAM_TRANSFER_FINISH,OnTransferFinish)
	ON_MESSAGE(WM_STCAM_AVI_FILE_START,OnAVIFileStart)
	ON_MESSAGE(WM_STCAM_AVI_FILE_FINISH,OnAVIFileFinish)
	ON_MESSAGE(WM_STCAM_PREVIEW_WINDOW_CREATE,OnPreviewWindowCreate)
	ON_MESSAGE(WM_STCAM_PREVIEW_WINDOW_CLOSE,OnPreviewWindowClose)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSampleRcvMsgDlg

BOOL CSampleRcvMsgDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);
	SetIcon(m_hIcon, FALSE);
	
	m_hCamera = StCam_Open(0);
	m_bStatusTransfer = FALSE;
	m_bStatusAVIFile = FALSE;
	m_bStatusPreviewWnd = FALSE;
	StCam_SetReceiveMsgWindow(m_hCamera, this->m_hWnd);
	StatusChanged();
	return TRUE;
}

void CSampleRcvMsgDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CSampleRcvMsgDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CSampleRcvMsgDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSampleRcvMsgDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	if(m_hCamera) StCam_Close(m_hCamera);
	
}

void CSampleRcvMsgDlg::OnBtnPreview() 
{
	if(m_bStatusPreviewWnd && m_bStatusTransfer)
	{
		//STOP
		StCam_StopTransfer(m_hCamera);
	}
	else
	{
		//START
		if(!m_bStatusPreviewWnd)
			StCam_CreatePreviewWindow(m_hCamera,TEXT("Preview"),WS_OVERLAPPEDWINDOW | WS_VISIBLE,0,0,0,0,NULL,NULL,TRUE);
		if(!m_bStatusTransfer)
			StCam_StartTransfer(m_hCamera);
	}	
}
afx_msg LRESULT CSampleRcvMsgDlg::OnTransferStart(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusTransfer = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleRcvMsgDlg::OnTransferFinish(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusTransfer = FALSE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleRcvMsgDlg::OnAVIFileStart(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusAVIFile = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleRcvMsgDlg::OnAVIFileFinish(WPARAM wParam, LPARAM lParam) 
{
	m_bStatusAVIFile = FALSE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleRcvMsgDlg::OnPreviewWindowCreate(WPARAM wParam, LPARAM lParam)
{
	m_bStatusPreviewWnd = TRUE;
	StatusChanged();
	return(0);
}
afx_msg LRESULT CSampleRcvMsgDlg::OnPreviewWindowClose(WPARAM wParam, LPARAM lParam)
{
	m_bStatusPreviewWnd = FALSE;
	StatusChanged();
	return(0);
}

void CSampleRcvMsgDlg::StatusChanged(void)
{
	TCHAR	szCaption[1024];
	if(m_bStatusPreviewWnd && m_bStatusTransfer)
		_tcscpy(szCaption,TEXT("STOP"));
	else
		_tcscpy(szCaption,TEXT("START"));
	::SetWindowText(GetDlgItem(IDC_BTN_PREVIEW)->m_hWnd,szCaption);
}